/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.viewservices.feedbackmanager.ffdc.FeedbackManagerErrorCode;
import org.odpi.openmetadata.viewservices.feedbackmanager.handler.CollaborationManagerHandler;

public class FeedbackManagerInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.FEEDBACK_MANAGER;
    private final Map<String, CollaborationManagerHandler> collaborationManagerHandlerMap = new HashMap<String, CollaborationManagerHandler>();
    private final List<ViewServiceConfig> activeViewServices;

    public FeedbackManagerInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL, List<ViewServiceConfig> activeViewServices) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.activeViewServices = activeViewServices;
    }

    public CollaborationManagerHandler getCollaborationManagerHandler(String viewServiceURLMarker, String methodName) throws InvalidParameterException {
        CollaborationManagerHandler collaborationManagerHandler = null;
        if (viewServiceURLMarker != null && (collaborationManagerHandler = this.collaborationManagerHandlerMap.get(viewServiceURLMarker)) == null) {
            for (ViewServiceConfig viewServiceConfig : this.activeViewServices) {
                String viewServicePartnerService;
                if (!viewServiceConfig.getViewServiceURLMarker().equals(viewServiceURLMarker) || (viewServicePartnerService = viewServiceConfig.getViewServicePartnerService()) == null) continue;
                for (AccessServiceDescription accessServiceDescription : AccessServiceDescription.values()) {
                    if (!accessServiceDescription.getAccessServiceFullName().equals(viewServicePartnerService)) continue;
                    collaborationManagerHandler = new CollaborationManagerHandler(this.serverName, viewServiceConfig.getOMAGServerName(), viewServiceConfig.getOMAGServerPlatformRootURL(), this.auditLog, accessServiceDescription.getAccessServiceURLMarker(), this.maxPageSize);
                    this.collaborationManagerHandlerMap.put(viewServiceURLMarker, collaborationManagerHandler);
                }
            }
        }
        if (collaborationManagerHandler == null) {
            throw new InvalidParameterException(FeedbackManagerErrorCode.INVALID_URL_MARKER.getMessageDefinition(viewServiceURLMarker), ((Object)((Object)this)).getClass().getName(), methodName, "viewServiceURLMarker");
        }
        return collaborationManagerHandler;
    }
}

