/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementStub;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.CommentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.NoteLogProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.NoteProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.RatingProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.TagProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.CommentConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.InformalTagConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.LikeConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.NoteConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.NoteLogConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.RatingConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.handler.OpenMetadataStoreHandler;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.CommentElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.InformalTagElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.LikeElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.NoteElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.NoteLogElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.RatingElement;

public class CollaborationManagerHandler {
    private final OpenMetadataStoreHandler client;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final AuditLog auditLog;
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final CommentConverter<CommentElement> commentConverter;
    private final LikeConverter<LikeElement> likeConverter;
    private final RatingConverter<RatingElement> ratingConverter;
    private final InformalTagConverter<InformalTagElement> tagConverter;
    private final NoteLogConverter<NoteLogElement> noteLogConverter;
    private final NoteConverter<NoteElement> noteConverter;

    public CollaborationManagerHandler(String localServerName, String serverName, String serverPlatformURLRoot, AuditLog auditLog, String accessServiceURLMarker, int maxPageSize) throws InvalidParameterException {
        this.client = new OpenMetadataStoreHandler(serverName, serverPlatformURLRoot, accessServiceURLMarker, maxPageSize);
        this.auditLog = auditLog;
        String serviceName = ViewServiceDescription.FEEDBACK_MANAGER.getViewServiceFullName();
        this.commentConverter = new CommentConverter(this.propertyHelper, serviceName, localServerName);
        this.likeConverter = new LikeConverter(this.propertyHelper, serviceName, localServerName);
        this.ratingConverter = new RatingConverter(this.propertyHelper, serviceName, localServerName);
        this.tagConverter = new InformalTagConverter(this.propertyHelper, serviceName, localServerName);
        this.noteLogConverter = new NoteLogConverter(this.propertyHelper, serviceName, localServerName);
        this.noteConverter = new NoteConverter(this.propertyHelper, serviceName, localServerName);
    }

    private void addFeedbackToElement(String userId, String elementGUID, String elementTypeName, String relationshipTypeName, boolean isPublic, ElementProperties elementProperties, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedMetadataElement existingFeedback = this.getFeedbackForUser(userId, elementGUID, relationshipTypeName, effectiveTime);
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        if (existingFeedback == null) {
            this.client.createMetadataElementInStore(userId, elementTypeName, ElementStatus.ACTIVE, null, elementGUID, false, null, null, elementProperties, elementGUID, relationshipTypeName, relationshipProperties, true);
        } else {
            this.client.updateMetadataElementInStore(userId, existingFeedback.getElement().getElementGUID(), false, false, false, elementProperties, effectiveTime);
            this.client.updateRelatedElementsInStore(userId, existingFeedback.getRelationshipGUID(), false, false, false, relationshipProperties, effectiveTime);
        }
    }

    private RelatedMetadataElement getFeedbackForUser(String userId, String elementGUID, String relationshipTypeName, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int startFrom = 0;
        RelatedMetadataElementList attachedFeedbacks = this.client.getRelatedMetadataElements(userId, elementGUID, 1, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
        RelatedMetadataElement existingFeedback = null;
        while (existingFeedback == null && attachedFeedbacks != null && attachedFeedbacks.getElementList() != null) {
            for (RelatedMetadataElement attachedFeedback : attachedFeedbacks.getElementList()) {
                if (attachedFeedback == null || !userId.equals(attachedFeedback.getVersions().getCreatedBy())) continue;
                existingFeedback = attachedFeedback;
                break;
            }
            attachedFeedbacks = this.client.getRelatedMetadataElements(userId, elementGUID, 1, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
        }
        return existingFeedback;
    }

    public void addRatingToElement(String userId, String elementGUID, boolean isPublic, RatingProperties properties, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addRatingToElement";
        String propertiesParameterName = "properties";
        String starRatingParameterName = "properties.starRating";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "addRatingToElement");
        this.invalidParameterHandler.validateObject((Object)properties.getStarRating(), "properties.starRating", "addRatingToElement");
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.REVIEW.name, properties.getReview());
        if (properties.getStarRating() != null) {
            elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.STARS.name, StarRating.getOpenTypeName(), properties.getStarRating().getName());
        }
        this.addFeedbackToElement(userId, elementGUID, OpenMetadataType.RATING.typeName, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName, isPublic, elementProperties, effectiveTime);
    }

    public void removeRatingFromElement(String userId, String elementGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedMetadataElement existingRating = this.getFeedbackForUser(userId, elementGUID, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName, effectiveTime);
        if (existingRating != null) {
            this.client.deleteMetadataElementInStore(userId, existingRating.getElement().getElementGUID(), false, false, effectiveTime);
        }
    }

    public List<RatingElement> getAttachedRatings(String userId, String elementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttachedRatings";
        RelatedMetadataElementList relatedMetadataElements = this.client.getRelatedMetadataElements(userId, elementGUID, 1, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getRatingsFromRelatedMetadataElement(relatedMetadataElements, "getAttachedRatings");
    }

    private List<RatingElement> getRatingsFromRelatedMetadataElement(RelatedMetadataElementList relatedMetadataElements, String methodName) throws PropertyServerException {
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<RatingElement> results = new ArrayList<RatingElement>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                if (relatedMetadataElement == null) continue;
                results.add(this.ratingConverter.getNewBean(RatingElement.class, relatedMetadataElement.getElement(), methodName));
            }
            return results;
        }
        return null;
    }

    public void addLikeToElement(String userId, String elementGUID, boolean isPublic, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.addFeedbackToElement(userId, elementGUID, OpenMetadataType.LIKE.typeName, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName, isPublic, null, effectiveTime);
    }

    public void removeLikeFromElement(String userId, String elementGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedMetadataElement existingLike = this.getFeedbackForUser(userId, elementGUID, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName, effectiveTime);
        if (existingLike != null) {
            this.client.deleteMetadataElementInStore(userId, existingLike.getElement().getElementGUID(), false, false, effectiveTime);
        }
    }

    public List<LikeElement> getAttachedLikes(String userId, String elementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttachedLikes";
        RelatedMetadataElementList relatedMetadataElements = this.client.getRelatedMetadataElements(userId, elementGUID, 1, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getLikesFromRelatedMetadataElement(relatedMetadataElements, "getAttachedLikes");
    }

    private List<LikeElement> getLikesFromRelatedMetadataElement(RelatedMetadataElementList relatedMetadataElements, String methodName) throws PropertyServerException {
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<LikeElement> results = new ArrayList<LikeElement>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                if (relatedMetadataElement == null) continue;
                results.add(this.likeConverter.getNewBean(LikeElement.class, relatedMetadataElement.getElement(), methodName));
            }
            return results;
        }
        return null;
    }

    public String addCommentToElement(String userId, String elementGUID, boolean isPublic, CommentProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentToElement";
        ElementProperties elementProperties = this.getElementPropertiesForComment(properties, "addCommentToElement");
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        return this.client.createMetadataElementInStore(userId, OpenMetadataType.COMMENT.typeName, ElementStatus.ACTIVE, null, elementGUID, false, properties.getEffectiveFrom(), properties.getEffectiveTo(), elementProperties, elementGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, relationshipProperties, true);
    }

    private ElementProperties getElementPropertiesForComment(CommentProperties properties, String methodName) throws InvalidParameterException {
        String propertiesParameterName = "properties";
        String commentQNameParameterName = "properties.qualifiedName";
        String commentTextParameterName = "properties.commentText";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", methodName);
        this.invalidParameterHandler.validateText(properties.getCommentText(), "properties.commentText", methodName);
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.TEXT.name, properties.getCommentText());
        elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
        if (properties.getCommentType() != null) {
            elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.COMMENT_TYPE.name, CommentType.getOpenTypeName(), properties.getCommentType().getName());
        }
        return elementProperties;
    }

    public String addCommentReply(String userId, String elementGUID, String commentGUID, boolean isPublic, CommentProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentToElement";
        ElementProperties elementProperties = this.getElementPropertiesForComment(properties, "addCommentToElement");
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        return this.client.createMetadataElementInStore(userId, OpenMetadataType.COMMENT.typeName, ElementStatus.ACTIVE, null, elementGUID, false, properties.getEffectiveFrom(), properties.getEffectiveTo(), elementProperties, commentGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, relationshipProperties, true);
    }

    public void updateComment(String userId, String commentGUID, boolean isMergeUpdate, CommentProperties properties, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateComment";
        ElementProperties elementProperties = this.getElementPropertiesForComment(properties, "updateComment");
        this.client.updateMetadataElementInStore(userId, commentGUID, !isMergeUpdate, false, false, elementProperties, effectiveTime);
    }

    public void updateCommentVisibility(String userId, String parentGUID, String commentGUID, boolean isPublic, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        OpenMetadataRelationshipList relationships = this.client.getMetadataElementRelationships(userId, parentGUID, commentGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, null, 0, 0);
        if (relationships != null && relationships.getElementList() != null) {
            for (OpenMetadataRelationship relationship : relationships.getElementList()) {
                if (relationship == null) continue;
                this.client.updateRelatedElementsInStore(userId, relationship.getRelationshipGUID(), false, false, false, relationshipProperties, effectiveTime);
                break;
            }
        }
    }

    public void setupAcceptedAnswer(String userId, String questionCommentGUID, String answerCommentGUID, boolean isPublic, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        this.client.createRelatedElementsInStore(userId, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeName, questionCommentGUID, answerCommentGUID, false, false, null, null, relationshipProperties, effectiveTime);
    }

    public void clearAcceptedAnswer(String userId, String questionCommentGUID, String answerCommentGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OpenMetadataRelationshipList relationships = this.client.getMetadataElementRelationships(userId, questionCommentGUID, answerCommentGUID, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, 0, 0);
        if (relationships != null && relationships.getElementList() != null) {
            for (OpenMetadataRelationship relationship : relationships.getElementList()) {
                if (relationship == null) continue;
                this.client.deleteRelatedElementsInStore(userId, relationship.getRelationshipGUID(), false, false, effectiveTime);
                break;
            }
        }
    }

    public void removeComment(String userId, String commentGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.client.deleteMetadataElementInStore(userId, commentGUID, false, false, effectiveTime);
    }

    public CommentElement getComment(String userId, String commentGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getComment";
        OpenMetadataElement commentElement = this.client.getMetadataElementByGUID(userId, commentGUID, false, false, null, effectiveTime);
        if (commentElement != null) {
            return this.commentConverter.getNewBean(CommentElement.class, commentElement, "getComment");
        }
        return null;
    }

    public List<CommentElement> getAttachedComments(String userId, String elementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttachedComments";
        RelatedMetadataElementList relatedMetadataElements = this.client.getRelatedMetadataElements(userId, elementGUID, 1, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getCommentsFromRelatedMetadataElement(relatedMetadataElements, "getAttachedComments");
    }

    private List<CommentElement> getCommentsFromRelatedMetadataElement(RelatedMetadataElementList relatedMetadataElements, String methodName) throws PropertyServerException {
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<CommentElement> results = new ArrayList<CommentElement>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                if (relatedMetadataElement == null) continue;
                results.add(this.commentConverter.getNewBean(CommentElement.class, relatedMetadataElement.getElement(), methodName));
            }
            return results;
        }
        return null;
    }

    public List<CommentElement> findComments(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findComments";
        List openMetadataElements = this.client.findMetadataElementsWithString(userId, searchString, OpenMetadataType.COMMENT.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getCommentsFromOpenMetadataElement(openMetadataElements, "findComments");
    }

    private List<CommentElement> getCommentsFromOpenMetadataElement(List<OpenMetadataElement> openMetadataElements, String methodName) throws PropertyServerException {
        if (openMetadataElements != null) {
            ArrayList<CommentElement> results = new ArrayList<CommentElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                results.add(this.commentConverter.getNewBean(CommentElement.class, openMetadataElement, methodName));
            }
            return results;
        }
        return null;
    }

    public String createInformalTag(String userId, TagProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createInformalTag";
        String propertiesParameterName = "properties";
        String nameParameterName = "properties.name";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createInformalTag");
        this.invalidParameterHandler.validateName(properties.getName(), "properties.name", "createInformalTag");
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.TAG_NAME.name, properties.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.TAG_DESCRIPTION.name, properties.getDescription());
        elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.IS_PUBLIC.name, !properties.getIsPrivateTag());
        return this.client.createMetadataElementInStore(userId, OpenMetadataType.INFORMAL_TAG.typeName, ElementStatus.ACTIVE, null, null, true, null, null, elementProperties, null, null, null, true);
    }

    public void updateTagDescription(String userId, String tagGUID, String tagDescription, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.client.updateMetadataElementInStore(userId, tagGUID, false, false, false, this.propertyHelper.addStringProperty(null, OpenMetadataProperty.TAG_DESCRIPTION.name, tagDescription), effectiveTime);
    }

    public void deleteTag(String userId, String tagGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.client.deleteMetadataElementInStore(userId, tagGUID, false, false, effectiveTime);
    }

    public InformalTagElement getTag(String userId, String tagGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTag";
        OpenMetadataElement openMetadataElement = this.client.getMetadataElementByGUID(userId, tagGUID, false, false, null, effectiveTime);
        if (openMetadataElement != null) {
            return this.tagConverter.getNewBean(InformalTagElement.class, openMetadataElement, "getTag");
        }
        return null;
    }

    public List<InformalTagElement> getTagsByName(String userId, String tag, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTagsByName";
        String nameParameterName = "tag";
        this.invalidParameterHandler.validateUserId(userId, "getTagsByName");
        this.invalidParameterHandler.validateName(tag, "tag", "getTagsByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTagsByName");
        List<String> propertyNames = Collections.singletonList(OpenMetadataProperty.TAG_NAME.name);
        List openMetadataElements = this.client.findMetadataElements(userId, OpenMetadataType.INFORMAL_TAG.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, tag, PropertyComparisonOperator.EQ), null, null, null, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, effectiveTime, startFrom, pageSize);
        if (openMetadataElements != null) {
            return this.getTagsFromOpenMetadataElement(openMetadataElements, "getTagsByName");
        }
        return null;
    }

    private List<InformalTagElement> getTagsFromOpenMetadataElement(List<OpenMetadataElement> openMetadataElements, String methodName) throws PropertyServerException {
        if (openMetadataElements != null) {
            ArrayList<InformalTagElement> results = new ArrayList<InformalTagElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                results.add(this.tagConverter.getNewBean(InformalTagElement.class, openMetadataElement, methodName));
            }
            return results;
        }
        return null;
    }

    public List<InformalTagElement> findTags(String userId, String tag, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findTags";
        List openMetadataElements = this.client.findMetadataElementsWithString(userId, tag, OpenMetadataType.INFORMAL_TAG.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getTagsFromOpenMetadataElement(openMetadataElements, "findTags");
    }

    public List<InformalTagElement> findMyTags(String userId, String tag, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<InformalTagElement> allMatchingTags = this.findTags(userId, tag, startFrom, pageSize, effectiveTime);
        if (allMatchingTags != null) {
            ArrayList<InformalTagElement> myTags = new ArrayList<InformalTagElement>();
            for (InformalTagElement tagElement : allMatchingTags) {
                if (tagElement != null && !tagElement.getProperties().getIsPrivateTag()) continue;
                myTags.add(tagElement);
            }
            return myTags;
        }
        return null;
    }

    public void addTagToElement(String userId, String elementGUID, String tagGUID, boolean isPublic, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        this.client.createRelatedElementsInStore(userId, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName, elementGUID, tagGUID, false, false, null, null, relationshipProperties, effectiveTime);
    }

    public void removeTagFromElement(String userId, String elementGUID, String tagGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataRelationshipList relationships = this.client.getMetadataElementRelationships(userId, elementGUID, tagGUID, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, 0, 0);
        if (relationships != null) {
            for (OpenMetadataRelationship relationship : relationships.getElementList()) {
                if (relationship == null) continue;
                this.client.deleteRelatedElementsInStore(userId, relationship.getRelationshipGUID(), false, false, effectiveTime);
            }
        }
    }

    public List<RelatedMetadataElementStub> getElementsByTag(String userId, String tagGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedMetadataElementList relatedMetadataElements = this.client.getRelatedMetadataElements(userId, tagGUID, 2, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<RelatedMetadataElementStub> stubs = new ArrayList<RelatedMetadataElementStub>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                if (relatedMetadataElement == null) continue;
                RelatedMetadataElementStub stub = new RelatedMetadataElementStub(relatedMetadataElement);
                stubs.add(stub);
            }
            return stubs;
        }
        return null;
    }

    public List<InformalTagElement> getAttachedTags(String userId, String elementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttachedTags";
        RelatedMetadataElementList relatedMetadataElements = this.client.getRelatedMetadataElements(userId, elementGUID, 1, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getTagsFromRelatedMetadataElement(relatedMetadataElements, "getAttachedTags");
    }

    private List<InformalTagElement> getTagsFromRelatedMetadataElement(RelatedMetadataElementList relatedMetadataElements, String methodName) throws PropertyServerException {
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<InformalTagElement> results = new ArrayList<InformalTagElement>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                if (relatedMetadataElement == null) continue;
                results.add(this.tagConverter.getNewBean(InformalTagElement.class, relatedMetadataElement.getElement(), methodName));
            }
            return results;
        }
        return null;
    }

    public String createNoteLog(String userId, String elementGUID, NoteLogProperties noteLogProperties, boolean isPublic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createNoteLog";
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "createNoteLog");
        ElementProperties elementProperties = this.getElementPropertiesForNoteLog(noteLogProperties, "createNoteLog");
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        return this.client.createMetadataElementInStore(userId, OpenMetadataType.NOTE_LOG.typeName, ElementStatus.ACTIVE, null, elementGUID, false, noteLogProperties.getEffectiveFrom(), noteLogProperties.getEffectiveTo(), elementProperties, elementGUID, OpenMetadataType.ATTACHED_NOTE_LOG_RELATIONSHIP.typeName, relationshipProperties, true);
    }

    private ElementProperties getElementPropertiesForNoteLog(NoteLogProperties properties, String methodName) throws InvalidParameterException {
        String propertiesParameterName = "properties";
        String commentQNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", methodName);
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAME.name, properties.getDisplayName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
        elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
        return elementProperties;
    }

    public void updateNoteLog(String userId, String noteLogGUID, boolean isMergeUpdate, NoteLogProperties noteLogProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateNoteLog";
        ElementProperties elementProperties = this.getElementPropertiesForNoteLog(noteLogProperties, "updateNoteLog");
        this.client.updateMetadataElementInStore(userId, noteLogGUID, !isMergeUpdate, false, false, elementProperties, effectiveTime);
    }

    public void removeNoteLog(String userId, String noteLogGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.deleteMetadataElementInStore(userId, noteLogGUID, false, false, effectiveTime);
    }

    public List<NoteLogElement> findNoteLogs(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findNoteLogs";
        List openMetadataElements = this.client.findMetadataElementsWithString(userId, searchString, OpenMetadataType.NOTE_LOG.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getNoteLogsFromOpenMetadataElement(openMetadataElements, "findNoteLogs");
    }

    private List<NoteLogElement> getNoteLogsFromOpenMetadataElement(List<OpenMetadataElement> openMetadataElements, String methodName) throws PropertyServerException {
        if (openMetadataElements != null) {
            ArrayList<NoteLogElement> results = new ArrayList<NoteLogElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                results.add(this.noteLogConverter.getNewBean(NoteLogElement.class, openMetadataElement, methodName));
            }
            return results;
        }
        return null;
    }

    private List<NoteLogElement> getNoteLogsFromRelatedMetadataElements(RelatedMetadataElementList relatedMetadataElements, String methodName) throws PropertyServerException {
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<NoteLogElement> results = new ArrayList<NoteLogElement>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                if (relatedMetadataElement == null) continue;
                results.add(this.noteLogConverter.getNewBean(NoteLogElement.class, relatedMetadataElement.getElement(), methodName));
            }
            return results;
        }
        return null;
    }

    public List<NoteLogElement> getNoteLogsByName(String userId, String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteLogsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getNoteLogsByName");
        this.invalidParameterHandler.validateName(name, "name", "getNoteLogsByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNoteLogsByName");
        List<String> propertyNames = Arrays.asList(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.NAME.name);
        List openMetadataElements = this.client.findMetadataElements(userId, OpenMetadataType.NOTE_LOG.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, name, PropertyComparisonOperator.EQ), null, null, null, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, effectiveTime, startFrom, pageSize);
        if (openMetadataElements != null) {
            return this.getNoteLogsFromOpenMetadataElement(openMetadataElements, "getNoteLogsByName");
        }
        return null;
    }

    public List<NoteLogElement> getNoteLogsForElement(String userId, String elementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteLogsForElement";
        RelatedMetadataElementList relatedMetadataElements = this.client.getRelatedMetadataElements(userId, elementGUID, 1, OpenMetadataType.ATTACHED_NOTE_LOG_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getNoteLogsFromRelatedMetadataElements(relatedMetadataElements, "getNoteLogsForElement");
    }

    public NoteLogElement getNoteLogByGUID(String userId, String noteLogGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteLogByGUID";
        OpenMetadataElement openMetadataElement = this.client.getMetadataElementByGUID(userId, noteLogGUID, false, false, null, effectiveTime);
        if (openMetadataElement != null) {
            return this.noteLogConverter.getNewBean(NoteLogElement.class, openMetadataElement, "getNoteLogByGUID");
        }
        return null;
    }

    public String createNote(String userId, String noteLogGUID, NoteProperties noteProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createNote";
        String guidParameterName = "noteLogGUID";
        this.invalidParameterHandler.validateGUID(noteLogGUID, "noteLogGUID", "createNote");
        ElementProperties elementProperties = this.getElementPropertiesForNote(noteProperties, "createNote");
        return this.client.createMetadataElementInStore(userId, OpenMetadataType.NOTE_ENTRY.typeName, ElementStatus.ACTIVE, null, noteLogGUID, false, noteProperties.getEffectiveFrom(), noteProperties.getEffectiveTo(), elementProperties, noteLogGUID, OpenMetadataType.ATTACHED_NOTE_LOG_ENTRY_RELATIONSHIP.typeName, null, true);
    }

    private ElementProperties getElementPropertiesForNote(NoteProperties properties, String methodName) throws InvalidParameterException {
        String propertiesParameterName = "properties";
        String commentQNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", methodName);
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.TEXT.name, properties.getText());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.COURTESY_TITLE.name, properties.getTitle());
        elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
        return elementProperties;
    }

    public void updateNote(String userId, String noteGUID, boolean isMergeUpdate, NoteProperties noteProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateNote";
        ElementProperties elementProperties = this.getElementPropertiesForNote(noteProperties, "updateNote");
        this.client.updateMetadataElementInStore(userId, noteGUID, !isMergeUpdate, false, false, elementProperties, effectiveTime);
    }

    public void removeNote(String userId, String noteGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.deleteMetadataElementInStore(userId, noteGUID, false, false, effectiveTime);
    }

    public List<NoteElement> findNotes(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findNotes";
        List openMetadataElements = this.client.findMetadataElementsWithString(userId, searchString, OpenMetadataType.NOTE_ENTRY.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getNotesFromOpenMetadataElement(openMetadataElements, "findNotes");
    }

    private List<NoteElement> getNotesFromOpenMetadataElement(List<OpenMetadataElement> openMetadataElements, String methodName) throws PropertyServerException {
        if (openMetadataElements != null) {
            ArrayList<NoteElement> results = new ArrayList<NoteElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                results.add(this.noteConverter.getNewBean(NoteElement.class, openMetadataElement, methodName));
            }
            return results;
        }
        return null;
    }

    private List<NoteElement> getNotesFromRelatedMetadataElements(RelatedMetadataElementList relatedMetadataElements, String methodName) throws PropertyServerException {
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            ArrayList<NoteElement> results = new ArrayList<NoteElement>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                if (relatedMetadataElement == null) continue;
                results.add(this.noteConverter.getNewBean(NoteElement.class, relatedMetadataElement.getElement(), methodName));
            }
            return results;
        }
        return null;
    }

    public List<NoteElement> getNotesForNoteLog(String userId, String noteLogGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNotesForNoteLog";
        RelatedMetadataElementList relatedMetadataElements = this.client.getRelatedMetadataElements(userId, noteLogGUID, 1, OpenMetadataType.ATTACHED_NOTE_LOG_ENTRY_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, effectiveTime, startFrom, pageSize);
        return this.getNotesFromRelatedMetadataElements(relatedMetadataElements, "getNotesForNoteLog");
    }

    public NoteElement getNoteByGUID(String userId, String noteGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteByGUID";
        OpenMetadataElement openMetadataElement = this.client.getMetadataElementByGUID(userId, noteGUID, false, false, null, effectiveTime);
        if (openMetadataElement != null) {
            return this.noteConverter.getNewBean(NoteElement.class, openMetadataElement, "getNoteByGUID");
        }
        return null;
    }
}

