/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.FeedbackProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.RatingProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.TagProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.CommentElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.CommentResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagUpdateRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteLogResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteLogsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NotesResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.RelatedElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.server.FeedbackManagerRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/feedback-manager"})
@Tag(name="API: Feedback Manager OMVS", description="Add comments, reviews, tags and notes to elements of interest.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/feedback-manager/overview/"))
public class FeedbackManagerResource {
    private final FeedbackManagerRESTServices restAPI = new FeedbackManagerRESTServices();

    @PostMapping(path={"/elements/{elementGUID}/comments/{commentGUID}/replies"})
    @Operation(summary="addCommentReply", description="Adds a reply to a comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentReply(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String commentGUID, @RequestParam boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.addCommentReply(serverName, elementGUID, commentGUID, isPublic, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments"})
    @Operation(summary="addCommentToElement", description="Creates a comment and attaches it to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentToElement(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.addCommentToElement(serverName, elementGUID, isPublic, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/likes"})
    @Operation(summary="addLikeToElement", description="Creates a <i>like</i> object and attaches it to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addLikeToElement(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.addLikeToElement(serverName, elementGUID, isPublic, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ratings"})
    @Operation(summary="addRatingToElement", description="Adds a star rating and optional review text to the element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addRatingToElement(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody RatingProperties requestBody) {
        return this.restAPI.addRatingToElement(serverName, elementGUID, isPublic, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/tags/{tagGUID}"})
    @Operation(summary="addTagToElement", description="Adds an informal tag (either private of public) to an element.", externalDocs=@ExternalDocumentation(description="Element Classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse addTagToElement(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody FeedbackProperties requestBody) {
        return this.restAPI.addTagToElement(serverName, elementGUID, tagGUID, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/tags"})
    @Operation(summary="createInformalTag", description="Creates a new informal tag and returns the unique identifier for it.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public GUIDResponse createInformalTag(@PathVariable String serverName, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody TagProperties requestBody) {
        return this.restAPI.createInformalTag(serverName, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/remove"})
    @Operation(summary="deleteTag", description="Removes an informal tag from the repository.  All the tagging relationships to this informal tag are lost.  A private tag can be deleted by its creator and all the references are lost; a public tag can be deleted by anyone, but only if it is not attached to any referenceable.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse deleteTag(@PathVariable String serverName, @PathVariable String tagGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteTag(serverName, tagGUID, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @GetMapping(path={"/elements/by-tag/{tagGUID}"})
    @Operation(summary="getElementsByTag", description="Return the list of unique identifiers for elements that are linked to a specific tag either directly, or via one of its schema elements.", externalDocs=@ExternalDocumentation(description="Element classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public RelatedElementsResponse getElementsByTag(@PathVariable String serverName, @PathVariable String tagGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker) {
        return this.restAPI.getElementsByTag(serverName, tagGUID, startFrom, pageSize, viewServiceURLMarker, accessServiceURLMarker);
    }

    @GetMapping(path={"/tags/{tagGUID}"})
    @Operation(summary="getTag", description="Return the informal tag for the supplied unique identifier (tagGUID).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagResponse getTag(@PathVariable String serverName, @PathVariable String tagGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker) {
        return this.restAPI.getTag(serverName, tagGUID, viewServiceURLMarker, accessServiceURLMarker);
    }

    @PostMapping(path={"/tags/by-name"})
    @Operation(summary="getTagsByName", description="Return the tags exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse getTagsByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getTagsByName(serverName, requestBody, startFrom, pageSize, viewServiceURLMarker, accessServiceURLMarker);
    }

    @PostMapping(path={"/tags/private/by-name"})
    @Operation(summary="getMyTagsByName", description="Return the list of the calling user's private informal tags exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse getMyTagsByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMyTagsByName(serverName, requestBody, startFrom, pageSize, viewServiceURLMarker, accessServiceURLMarker);
    }

    @PostMapping(path={"/comments/by-search-string"})
    @Operation(summary="findComment", description="Return the list of comments containing the supplied string. The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of an effective time to restrict the search to element that are/were effective at a particular time.", externalDocs=@ExternalDocumentation(description="Comment", url="https://egeria-project.org/concepts/comment/"))
    public CommentElementsResponse findComments(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findComments(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/tags/by-search-string"})
    @Operation(summary="findTags", description="Return the list of informal tags containing the supplied string in their name or description. The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of an effective time to restrict the search to element that are/were effective at a particular time.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findTags(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findTags(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/tags/private/by-search-string"})
    @Operation(summary="findMyTags", description="Return the list of the calling user's private tags containing the supplied string in either the name or description.  The search string is a regular expression (RegEx).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findMyTags(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findMyTags(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments/{commentGUID}/remove"})
    @Operation(summary="removeCommentFromElement", description="Removes a comment added to the element by this user.  This deletes the link to the comment, the comment itself and any comment replies attached to it.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeCommentFromElement(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String commentGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeCommentFromElement(serverName, elementGUID, commentGUID, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @GetMapping(path={"/comments/{commentGUID}"})
    public CommentResponse getComment(@PathVariable String serverName, @PathVariable String commentGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker) {
        return this.restAPI.getCommentByGUID(serverName, commentGUID, viewServiceURLMarker, accessServiceURLMarker);
    }

    @GetMapping(path={"/elements/{elementGUID}/comments"})
    public CommentElementsResponse getAttachedComments(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker) {
        return this.restAPI.getAttachedComments(serverName, elementGUID, startFrom, pageSize, viewServiceURLMarker, accessServiceURLMarker);
    }

    @PostMapping(path={"/elements/{elementGUID}/likes/remove"})
    @Operation(summary="removeLikeFromElement", description="Removes a <i>Like</i> added to the element by this user.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#element-feedback"))
    public VoidResponse removeLikeFromElement(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeLikeFromElement(serverName, elementGUID, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ratings/remove"})
    @Operation(summary="removeRatingFromElement", description="Removes of a star rating/review that was added to the element by this user.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeRatingFromElement(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeRatingFromElement(serverName, elementGUID, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/tags/{tagGUID}/remove"})
    @Operation(summary="removeTagFromElement", description="Removes a link between a tag and an element that was added by this user.", externalDocs=@ExternalDocumentation(description="Element classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse removeTagFromElement(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeTagFromElement(serverName, elementGUID, tagGUID, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/comments/{commentGUID}/update"})
    @Operation(summary="updateComment", description="Update an existing comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse updateComment(@PathVariable String serverName, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateComment(serverName, commentGUID, isMergeUpdate, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/parents/{parentGUID}/comments/{commentGUID}/update-visibility"})
    @Operation(summary="updateComment", description="Update an existing comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse updateCommentVisibility(@PathVariable String serverName, @PathVariable String parentGUID, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="true") boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.updateCommentVisibility(serverName, parentGUID, commentGUID, isPublic, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(value={"/comments/questions/{questionCommentGUID}/answers/{answerCommentGUID}"})
    public VoidResponse setupAcceptedAnswer(@PathVariable String serverName, @PathVariable String questionCommentGUID, @PathVariable String answerCommentGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupAcceptedAnswer(serverName, questionCommentGUID, answerCommentGUID, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(value={"/comments/questions/{questionCommentGUID}/answers/{answerCommentGUID}/remove"})
    public VoidResponse clearAcceptedAnswer(@PathVariable String serverName, @PathVariable String questionCommentGUID, @PathVariable String answerCommentGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.clearAcceptedAnswer(serverName, questionCommentGUID, answerCommentGUID, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/update"})
    @Operation(summary="updateTagDescription", description="Updates the description of an existing tag (either private or public).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse updateTagDescription(@PathVariable String serverName, @PathVariable String tagGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody InformalTagUpdateRequestBody requestBody) {
        return this.restAPI.updateTagDescription(serverName, tagGUID, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(value={"/note-logs/by-search-string"})
    public NoteLogsResponse findNoteLogs(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findNoteLogs(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(value={"/note-logs/by-name"})
    public NoteLogsResponse getNoteLogsByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getNoteLogsByName(serverName, startFrom, pageSize, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @GetMapping(value={"/elements/{elementGUID}/note-logs"})
    public NoteLogsResponse getNoteLogsForElement(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker) {
        return this.restAPI.getNoteLogsForElement(serverName, elementGUID, startFrom, pageSize, viewServiceURLMarker, accessServiceURLMarker);
    }

    @GetMapping(value={"/note-logs/{noteLogGUID}"})
    public NoteLogResponse getNoteLogByGUID(@PathVariable String serverName, @PathVariable String noteLogGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker) {
        return this.restAPI.getNoteLogByGUID(serverName, noteLogGUID, viewServiceURLMarker, accessServiceURLMarker);
    }

    @PostMapping(value={"/note-logs/notes/by-search-string"})
    public NotesResponse findNotes(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findNotes(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, viewServiceURLMarker, accessServiceURLMarker, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/notes/retrieve"})
    public NotesResponse getNotesForNoteLog(@PathVariable String serverName, @PathVariable String noteLogGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker) {
        return this.restAPI.getNotesForNoteLog(serverName, noteLogGUID, startFrom, pageSize, viewServiceURLMarker, accessServiceURLMarker);
    }

    @PostMapping(value={"/note-logs/notes/{noteGUID}"})
    public NoteResponse getNoteByGUID(@PathVariable String serverName, @PathVariable String noteGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker) {
        return this.restAPI.getNoteByGUID(serverName, noteGUID, viewServiceURLMarker, accessServiceURLMarker);
    }
}

