/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.NoteLogProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.NoteProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.RatingProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.TagProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.CommentElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.CommentResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagUpdateRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.LikeElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteLogResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteLogsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NotesResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.RatingElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.RelatedElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.server.FeedbackManagerRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/{urlMarker}"})
@Tag(name="API: Feedback Manager OMVS", description="Add comments, reviews, tags and notes to elements of interest.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/feedback-manager/overview/"))
public class FeedbackManagerResource {
    private final FeedbackManagerRESTServices restAPI = new FeedbackManagerRESTServices();

    @PostMapping(path={"/elements/{elementGUID}/comments/{commentGUID}/replies"})
    @Operation(summary="addCommentReply", description="Adds a reply to a comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentReply(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.addCommentReply(serverName, elementGUID, commentGUID, isPublic, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments"})
    @Operation(summary="addCommentToElement", description="Creates a comment and attaches it to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentToElement(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.addCommentToElement(serverName, elementGUID, isPublic, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/likes"})
    @Operation(summary="addLikeToElement", description="Creates a <i>like</i> object and attaches it to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addLikeToElement(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.addLikeToElement(serverName, elementGUID, isPublic, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ratings"})
    @Operation(summary="addRatingToElement", description="Adds, or updates, a star rating and optional review text to the element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addRatingToElement(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody RatingProperties requestBody) {
        return this.restAPI.addRatingToElement(serverName, elementGUID, isPublic, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/tags/{tagGUID}"})
    @Operation(summary="addTagToElement", description="Adds an informal tag (either private of public) to an element.", externalDocs=@ExternalDocumentation(description="Element Classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse addTagToElement(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestParam(required=false, defaultValue="false") boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.addTagToElement(serverName, elementGUID, tagGUID, isPublic, urlMarker, requestBody);
    }

    @PostMapping(path={"/tags"})
    @Operation(summary="createInformalTag", description="Creates a new informal tag and returns the unique identifier for it.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public GUIDResponse createInformalTag(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody TagProperties requestBody) {
        return this.restAPI.createInformalTag(serverName, urlMarker, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/remove"})
    @Operation(summary="deleteTag", description="Removes an informal tag from the repository.  All the tagging relationships to this informal tag are lost.  A private tag can be deleted by its creator and all the references are lost; a public tag can be deleted by anyone, but only if it is not attached to any referenceable.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse deleteTag(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String tagGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.deleteTag(serverName, tagGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/by-tag/{tagGUID}/retrieve"})
    @Operation(summary="getElementsByTag", description="Return the list of unique identifiers for elements that are linked to a specific tag either directly, or via one of its schema elements.", externalDocs=@ExternalDocumentation(description="Element classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public RelatedElementsResponse getElementsByTag(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String tagGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getElementsByTag(serverName, tagGUID, startFrom, pageSize, urlMarker, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/retrieve"})
    @Operation(summary="getTag", description="Return the informal tag for the supplied unique identifier (tagGUID).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagResponse getTag(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String tagGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getTag(serverName, tagGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/tags/by-name"})
    @Operation(summary="getTagsByName", description="Return the tags exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse getTagsByName(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getTagsByName(serverName, startFrom, pageSize, urlMarker, requestBody);
    }

    @PostMapping(path={"/comments/by-search-string"})
    @Operation(summary="findComment", description="Return the list of comments containing the supplied string. The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of an effective time to restrict the search to element that are/were effective at a particular time.", externalDocs=@ExternalDocumentation(description="Comment", url="https://egeria-project.org/concepts/comment/"))
    public CommentElementsResponse findComments(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findComments(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, urlMarker, requestBody);
    }

    @PostMapping(path={"/tags/by-search-string"})
    @Operation(summary="findTags", description="Return the list of informal tags containing the supplied string in their name or description. The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of an effective time to restrict the search to element that are/were effective at a particular time.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findTags(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findTags(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, urlMarker, requestBody);
    }

    @PostMapping(path={"/tags/private/by-search-string"})
    @Operation(summary="findMyTags", description="Return the list of the calling user's private tags containing the supplied string in either the name or description.  The search string is a regular expression (RegEx).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findMyTags(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findMyTags(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, urlMarker, requestBody);
    }

    @PostMapping(path={"/comments/{commentGUID}/remove"})
    @Operation(summary="removeCommentFromElement", description="Removes a comment added to the element by this user.  This deletes the link to the comment, the comment itself and any comment replies attached to it.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeCommentFromElement(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String commentGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.removeCommentFromElement(serverName, commentGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/comments/{commentGUID}/retrieve"})
    @Operation(summary="getComment", description="Return the requested comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public CommentResponse getComment(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String commentGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getCommentByGUID(serverName, commentGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ratings/retrieve"})
    @Operation(summary="getAttachedComments", description="Return the ratings attached to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public RatingElementsResponse getAttachedRatings(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getAttachedRatings(serverName, elementGUID, startFrom, pageSize, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/likes/retrieve"})
    @Operation(summary="getAttachedLikes", description="Return the likes attached to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public LikeElementsResponse getAttachedLikes(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getAttachedLikes(serverName, elementGUID, startFrom, pageSize, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments/retrieve"})
    @Operation(summary="getAttachedComments", description="Return the comments attached to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public CommentElementsResponse getAttachedComments(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getAttachedComments(serverName, elementGUID, startFrom, pageSize, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/tags/retrieve"})
    @Operation(summary="getAttachedTags", description="Return the informal tags attached to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public InformalTagsResponse getAttachedTags(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getAttachedTags(serverName, elementGUID, startFrom, pageSize, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/likes/remove"})
    @Operation(summary="removeLikeFromElement", description="Removes a <i>Like</i> added to the element by this user.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#element-feedback"))
    public VoidResponse removeLikeFromElement(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.removeLikeFromElement(serverName, elementGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ratings/remove"})
    @Operation(summary="removeRatingFromElement", description="Removes of a star rating/review that was added to the element by this user.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeRatingFromElement(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.removeRatingFromElement(serverName, elementGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/tags/{tagGUID}/remove"})
    @Operation(summary="removeTagFromElement", description="Removes a link between a tag and an element that was added by this user.", externalDocs=@ExternalDocumentation(description="Element classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse removeTagFromElement(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.removeTagFromElement(serverName, elementGUID, tagGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/comments/{commentGUID}/update"})
    @Operation(summary="updateComment", description="Update an existing comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse updateComment(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateComment(serverName, commentGUID, isMergeUpdate, urlMarker, requestBody);
    }

    @PostMapping(path={"/parents/{parentGUID}/comments/{commentGUID}/update-visibility"})
    @Operation(summary="updateCommentVisibility", description="Update an existing comment's visibility.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse updateCommentVisibility(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String parentGUID, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.updateCommentVisibility(serverName, parentGUID, commentGUID, isPublic, urlMarker, requestBody);
    }

    @PostMapping(value={"/comments/questions/{questionCommentGUID}/answers/{answerCommentGUID}"})
    @Operation(summary="setupAcceptedAnswer", description="Link a comment that contains the best answer to a question posed in another comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse setupAcceptedAnswer(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String questionCommentGUID, @PathVariable String answerCommentGUID, @RequestParam(required=false, defaultValue="false") boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.setupAcceptedAnswer(serverName, questionCommentGUID, answerCommentGUID, isPublic, urlMarker, requestBody);
    }

    @PostMapping(value={"/comments/questions/{questionCommentGUID}/answers/{answerCommentGUID}/remove"})
    @Operation(summary="clearAcceptedAnswer", description="Unlink a comment that contains an answer to a question posed in another comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse clearAcceptedAnswer(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String questionCommentGUID, @PathVariable String answerCommentGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearAcceptedAnswer(serverName, questionCommentGUID, answerCommentGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/update"})
    @Operation(summary="updateTagDescription", description="Updates the description of an existing tag (either private or public).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse updateTagDescription(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String tagGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody InformalTagUpdateRequestBody requestBody) {
        return this.restAPI.updateTagDescription(serverName, tagGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/note-logs"})
    @Operation(summary="createNoteLog", description="Creates a new noteLog and returns the unique identifier for it.", externalDocs=@ExternalDocumentation(description="Note Logs", url="https://egeria-project.org/concepts/note-log/"))
    public GUIDResponse createNoteLog(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean isPublic, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody NoteLogProperties requestBody) {
        return this.restAPI.createNoteLog(serverName, elementGUID, isPublic, urlMarker, requestBody);
    }

    @PostMapping(path={"/note-logs/{noteLogGUID}"})
    @Operation(summary="updateNoteLog", description="Update an existing note log.", externalDocs=@ExternalDocumentation(description="Note Logs", url="https://egeria-project.org/concepts/note-log/"))
    public VoidResponse updateNoteLog(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String noteLogGUID, @RequestParam boolean isMergeUpdate, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateNoteLog(serverName, noteLogGUID, isMergeUpdate, urlMarker, requestBody);
    }

    @PostMapping(path={"/note-logs/{noteLogGUID}/remove"})
    @Operation(summary="removeNoteLog", description="Removes a note log from the repository.", externalDocs=@ExternalDocumentation(description="Note Logs", url="https://egeria-project.org/concepts/note-log/"))
    public VoidResponse removeNoteLog(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String noteLogGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.deleteNoteLog(serverName, noteLogGUID, urlMarker, requestBody);
    }

    @PostMapping(value={"/note-logs/by-search-string"})
    @Operation(summary="findNoteLogs", description="Retrieve the list of note log metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public NoteLogsResponse findNoteLogs(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findNoteLogs(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, urlMarker, requestBody);
    }

    @PostMapping(value={"/note-logs/by-name"})
    @Operation(summary="getNoteLogsByName", description="Retrieve the list of note log metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public NoteLogsResponse getNoteLogsByName(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getNoteLogsByName(serverName, startFrom, pageSize, urlMarker, requestBody);
    }

    @PostMapping(value={"/elements/{elementGUID}/note-logs/retrieve"})
    @Operation(summary="getNoteLogsForElement", description="Retrieve the list of note log metadata elements attached to the element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public NoteLogsResponse getNoteLogsForElement(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNoteLogsForElement(serverName, elementGUID, startFrom, pageSize, urlMarker, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/retrieve"})
    @Operation(summary="getNoteLogByGUID", description="Retrieve the note log metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public NoteLogResponse getNoteLogByGUID(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String noteLogGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNoteLogByGUID(serverName, noteLogGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/note-logs/{noteLogGUID}/notes"})
    @Operation(summary="createNote", description="Creates a new note in the note log and returns the unique identifier for it.", externalDocs=@ExternalDocumentation(description="Note Logs", url="https://egeria-project.org/concepts/note-log/"))
    public GUIDResponse createNote(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String noteLogGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody NoteProperties requestBody) {
        return this.restAPI.createNote(serverName, noteLogGUID, urlMarker, requestBody);
    }

    @PostMapping(path={"/notes/{noteGUID}"})
    @Operation(summary="updateNote", description="Update an existing note.", externalDocs=@ExternalDocumentation(description="Note Logs", url="https://egeria-project.org/concepts/note-log/"))
    public VoidResponse updateNote(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String noteGUID, @RequestParam boolean isMergeUpdate, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateNote(serverName, noteGUID, isMergeUpdate, urlMarker, requestBody);
    }

    @PostMapping(path={"/notes/{noteGUID}/remove"})
    @Operation(summary="removeNote", description="Remove an existing note.", externalDocs=@ExternalDocumentation(description="Note Logs", url="https://egeria-project.org/concepts/note-log/"))
    public VoidResponse removeNote(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String noteGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.deleteNote(serverName, noteGUID, urlMarker, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/by-search-string"})
    @Operation(summary="findNotes", description="Retrieve the list of note metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public NotesResponse findNotes(@PathVariable String serverName, @PathVariable String urlMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findNotes(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, urlMarker, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/notes/retrieve"})
    @Operation(summary="getNotesForNoteLog", description="Retrieve the list of notes associated with a note log.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public NotesResponse getNotesForNoteLog(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String noteLogGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNotesForNoteLog(serverName, noteLogGUID, startFrom, pageSize, urlMarker, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/{noteGUID}/retrieve"})
    @Operation(summary="getNoteByGUID", description=" Retrieve the note metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public NoteResponse getNoteByGUID(@PathVariable String serverName, @PathVariable String urlMarker, @PathVariable String noteGUID, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="asset-manager") String accessServiceURLMarker, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNoteByGUID(serverName, noteGUID, urlMarker, requestBody);
    }
}

