/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.OMAGCommonErrorCode;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class InvalidParameterHandler {
    private int maxPagingSize = 500;

    public void setMaxPagingSize(int maxPagingSize) {
        this.maxPagingSize = maxPagingSize;
    }

    public int getMaxPagingSize() {
        return this.maxPagingSize;
    }

    public void validateOMAGServerPlatformURL(String omagServerPlatformURL, String serverName, String methodName) throws InvalidParameterException {
        if (omagServerPlatformURL == null) {
            String parameterName = "omagServerPlatformURL";
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.SERVER_URL_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "omagServerPlatformURL");
        }
        if (serverName == null) {
            String parameterName = "serverName";
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.SERVER_NAME_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "serverName");
        }
    }

    public void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (userId == null) {
            String parameterName = "userId";
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "userId");
        }
    }

    public void validateGUID(String guid, String guidParameter, String methodName) throws InvalidParameterException {
        if (guid == null) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guidParameter, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guidParameter);
        }
    }

    public void validateName(String name, String nameParameter, String methodName) throws InvalidParameterException {
        if (name == null) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(nameParameter, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), nameParameter);
        }
    }

    public void validateSearchString(String searchString, String searchParameter, String methodName) throws InvalidParameterException {
        if (searchString == null || searchString.isEmpty()) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_SEARCH_STRING;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(searchParameter, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), searchParameter);
        }
    }

    public void validateObject(Object object, String nameParameter, String methodName) throws InvalidParameterException {
        if (object == null) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_OBJECT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(nameParameter, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), nameParameter);
        }
    }

    public void validateEnum(Object enumValue, String parameterName, String methodName) throws InvalidParameterException {
        if (enumValue == null) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_ENUM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(parameterName, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    public void validateText(String text, String parameterName, String methodName) throws InvalidParameterException {
        if (text == null) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_TEXT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(parameterName, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "text");
        }
    }

    public void validatePaging(int startFrom, int pageSize, String methodName) throws InvalidParameterException {
        String startFromParameterName = "startFrom";
        String pageSizeParameterName = "pageSize";
        if (startFrom < 0) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NEGATIVE_START_FROM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(Integer.toString(startFrom), "startFrom", methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "startFrom");
        }
        if (pageSize < 0) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NEGATIVE_PAGE_SIZE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(Integer.toString(pageSize), "pageSize", methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "pageSize");
        }
        if (pageSize > this.maxPagingSize) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.MAX_PAGE_SIZE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(Integer.toString(pageSize), Integer.toString(this.maxPagingSize), methodName, Integer.toString(this.maxPagingSize));
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "pageSize");
        }
    }

    public void validateStringArray(List<String> stringArray, String parameterName, String methodName) throws InvalidParameterException {
        if (stringArray == null || stringArray.isEmpty()) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_ARRAY_PARAMETER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(parameterName, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    public void validateConnection(Connection connection, String parameterName, String methodName) throws InvalidParameterException {
        if (connection == null) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_CONNECTION_PARAMETER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(parameterName, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    public String validateTypeName(String typeName, String superTypeName, String serviceName, String methodName, OMRSRepositoryHelper repositoryHelper) throws InvalidParameterException {
        String parameterName = "typeName";
        TypeDef typeDef = repositoryHelper.getTypeDefByName(serviceName, typeName);
        if (typeDef == null) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.UNRECOGNIZED_TYPE_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(typeName, methodName, serviceName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "typeName");
        }
        if (!repositoryHelper.isTypeOf(serviceName, typeName, superTypeName)) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.BAD_SUB_TYPE_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(typeName, methodName, serviceName, superTypeName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "typeName");
        }
        return typeDef.getGUID();
    }

    public void validateAssetInSupportedZone(String assetGUID, String parameterName, List<String> assetZones, List<String> supportedZones, String serviceName, String methodName) throws InvalidParameterException {
        if (supportedZones == null || supportedZones.isEmpty()) {
            return;
        }
        if (assetZones == null || assetZones.isEmpty()) {
            return;
        }
        for (String assetZoneName : assetZones) {
            if (assetZoneName == null) continue;
            for (String supportedZoneName : supportedZones) {
                if (!assetZoneName.equals(supportedZoneName)) continue;
                return;
            }
        }
        OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NOT_IN_THE_ZONE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(assetGUID, serviceName);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
    }

    public void throwMethodNotSupported(String userId, String serviceName, String serverName, String methodName) throws InvalidParameterException {
        String parameterName = "methodName";
        OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.METHOD_NOT_IMPLEMENTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName, userId, serverName, serviceName);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "methodName");
    }

    public void throwUnknownElement(String userId, String guid, String type, String serviceName, String serverName, String methodName) throws InvalidParameterException {
        String parameterName = "guid";
        OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.UNKNOWN_ELEMENT;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guid, type, userId, methodName, serviceName, serverName);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "guid");
    }

    public void throwCannotDeleteElementInUse(String guid, String type, String serviceName, String methodName) throws InvalidParameterException {
        String parameterName = "guid";
        OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.CANNOT_DELETE_ELEMENT_IN_USE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName, serviceName, type, guid);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "guid");
    }
}

