/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OMAGCommonErrorCode {
    SERVER_URL_NOT_SPECIFIED(400, "OMAG-COMMON-400-001 ", "The OMAG Server Platform URL is null", "The system is unable to connect to the OMAG Server to fulfill the request.", "Create a new client and pass the correct URL for the server on the constructor."),
    SERVER_URL_MALFORMED(400, "OMAG-COMMON-400-002 ", "The OMAS Server URL {0} is not in a recognized format", "The system is unable to connect to the OMAG Server to fulfill.", "Create a new client and pass the correct URL for the server on the constructor."),
    SERVER_NAME_NOT_SPECIFIED(400, "OMAG-COMMON-400-003 ", "The OMAG Server name is null", "The system is unable to connect to the OMAG Server to fulfill the request.", "Create a new client and pass the correct URL for the server on the constructor."),
    NULL_USER_ID(400, "OMAG-COMMON-400-004 ", "The user identifier (user id) passed on the {0} operation is null", "The system is unable to process the request without a user id.", "Correct the code in the caller to provide the user id."),
    NULL_GUID(400, "OMAG-COMMON-400-005 ", "The unique identifier (guid) passed on the {0} parameter of the {1} operation is null", "The system is unable to process the request without a guid.", "Correct the code in the caller to provide the guid."),
    NULL_NAME(400, "OMAG-COMMON-400-006 ", "The name passed on the {0} parameter of the {1} operation is null", "The system is unable to process the request without a name.", "Correct the code in the caller to provide the name."),
    NULL_ARRAY_PARAMETER(400, "OMAG-COMMON-400-007 ", "The array value passed on the {0} parameter of the {1} operation is null or empty", "The system is unable to process the request without this value.", "Correct the code in the caller to provide the name."),
    NEGATIVE_START_FROM(400, "OMAG-COMMON-400-008 ", "The starting point for the results {0}, passed on the {1} parameter of the {2} operation, is negative", "The system is unable to process the request with this invalid value.  It should be zero for the start of the values, or a number greater than 0 to start partway down the list", "Correct the code in the caller to provide a non-negative value."),
    NEGATIVE_PAGE_SIZE(400, "OMAG-COMMON-400-009 ", "The page size {0} for the results, passed on the {1} parameter of the {2} operation, is negative", "The system is unable to process the request with this invalid value.  It should be zero to return all of the result, or greater than zero to set a maximum", "Correct the code in the caller to provide a non-negative value."),
    MAX_PAGE_SIZE(400, "OMAG-COMMON-400-010 ", "The number of records to return, {0}, passed on the {1} parameter of the {2} operation, is greater than the allowable maximum of {3}", "The system is unable to process the request with this page size value.", "Correct the code in the caller to provide a smaller page size ."),
    NULL_CONNECTION_PARAMETER(400, "OMAG-COMMON-400-011 ", "The connection value passed on the {0} parameter of the {1} operation is null", "The system is unable to process the request without this value.", "Correct the code in the caller to provide the name."),
    NULL_ENUM(400, "OMAG-COMMON-400-012 ", "The enumeration value passed on the {0} parameter of the {1} operation is null", "The system is unable to process the request without this enumeration value.", "Correct the code in the caller to provide the name."),
    NULL_TEXT(400, "OMAG-COMMON-400-013 ", "The text field value passed on the {0} parameter of the {1} operation is null", "The system is unable to process the request without this text field value.", "Correct the code in the caller to provide the name."),
    NULL_LOCAL_SERVER_NAME(400, "OMAG-COMMON-400-014 ", "OMAG server has been called with a null local server name", "The system is unable to configure the local server.", "The local server name is supplied by the caller to the OMAG server. This call needs to be corrected before the server can operate correctly."),
    NULL_OBJECT(400, "OMAG-COMMON-400-015 ", "The object passed on the {0} parameter of the {1} operation is null", "The system is unable to process the request without this object.", "Correct the code in the caller to provide the object."),
    UNEXPECTED_EXCEPTION(400, "OMAG-COMMON-400-016 ", "An unexpected {0} exception was caught by {1}; error message was {2}", "The system is unable to process the request.", "Review the error message and other diagnostics created at the same time."),
    NO_REQUEST_BODY(400, "OMAG-COMMON-400-017 ", "An request by user {0} to method {1} on server {2} had no request body", "The system is unable to process the request.", "Update the caller to provide the request body."),
    UNRECOGNIZED_TYPE_NAME(400, "OMAG-COMMON-400-018 ", "The type name {0} passed on method {1} of service {2} is not recognized", "The system is unable to process the request.", "Update the caller to provide a correct type name."),
    BAD_SUB_TYPE_NAME(400, "OMAG-COMMON-400-019 ", "The type name {0} passed on method {1} of service {2} is not a sub-type of {3}", "The system is unable to process the request.", "Update the caller to provide a correct type name."),
    NOT_IN_THE_ZONE(400, "OMAG-COMMON-400-020 ", "Asset {0} is not recognized by the {1} service", "The system is unable to process the request.", "Update the caller to provide a correct asset identifier."),
    UNKNOWN_ELEMENT(400, "OMAG-COMMON-400-021 ", "The identifier {0} of the {1} passed by {2} to method {3} of service {4} is not recognized by the {5} server", "The system is unable to process the request.", "Update the caller to provide a correct asset identifier."),
    NULL_SEARCH_STRING(400, "OMAG-COMMON-400-022 ", "The search string passed on the {0} parameter of the {1} operation is null", "The system is unable to process the request without a search string.", "Correct the code in the caller to provide the search string."),
    CANNOT_DELETE_ELEMENT_IN_USE(400, "OMAG-COMMON-400-023 ", "Method {0} of service {1} is unable to delete {2} identified by {3} because it is still in use.", "The system is unable to process the request.", "Ensure the element is no longer in use before retrying the operation."),
    INSTANCE_WRONG_TYPE_FOR_GUID(404, "OMAG-COMMON-404-001 ", "The {0} method has retrieved an instance for unique identifier (guid) {1} which is of type {2} rather than type {3}", "The request fails.", "Check that the unique identifier is correct and the property server(s) is/are running."),
    METHOD_NOT_IMPLEMENTED(500, "OMAG-COMMON-500-001 ", "Method {0} called by user {1} to OMAG Server {2} is not implemented in service {3}", "The user has issued a valid call to an open metadata REST API that is currently not yet implemented.", "Look to become a contributor or advocate for the ODPi Egeria community to help get this method implemented as soon as possible."),
    CLIENT_SIDE_REST_API_ERROR(503, "OMAG-COMMON-503-001 ", "A client-side exception was received from API call {0} to OMAG Server {1} at {2}.  The error message was {3}", "The server has issued a call to the open metadata access service REST API in a remote server and has received an exception from the local client libraries.", "Look for errors in the local server's console to understand and correct the source of the error.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private OMAGCommonErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        log.debug(String.format("<== OMAGCommonErrorCode.getMessage(%s)", Arrays.toString(params)));
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("==> OMAGCommonErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String toString() {
        return "OMAGCommonErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + '}';
    }

    static {
        log = LoggerFactory.getLogger(OMAGCommonErrorCode.class);
    }
}

