/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import org.apache.commons.lang3.time.StopWatch;

public class RESTCallToken {
    private static long nextCallId = 0L;
    private StopWatch watch;
    private long callId;
    private String serviceName;
    private String serverName;
    private String userId;
    private String methodName;

    private static synchronized long getNextCallId() {
        return nextCallId++;
    }

    RESTCallToken(String serviceName, String serverName, String userId, String methodName) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.methodName = methodName;
        this.watch = StopWatch.createStarted();
        this.callId = RESTCallToken.getNextCallId();
    }

    String getRESTCallStartText() {
        return this.callId + ":" + this.serviceName + ":" + this.serverName + ":" + this.methodName + " call invoked by " + this.userId;
    }

    String getRESTCallReturnText(String response) {
        return this.callId + ":" + this.serviceName + ":" + this.serverName + ":" + this.methodName + " call invoked by " + this.userId + " returned with response " + response + "; Duration: " + this.watch.getTime() / 1000L + "seconds";
    }
}

