/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc.rest;

import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientFactory;
import org.odpi.openmetadata.commonservices.ffdc.OMAGCommonErrorCode;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;

public class FFDCRESTClientBase {
    protected String serverName;
    protected String serverPlatformURLRoot;
    protected RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private RESTClientConnector clientConnector;

    protected FFDCRESTClientBase(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "RESTClient(no authentication)";
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Throwable error) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(serverName, error.getMessage());
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "RESTClient(no authentication)", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error, "serverPlatformURLRoot or serverName");
        }
    }

    protected FFDCRESTClientBase(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "RESTClient(userId and password)";
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot, userId, password);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Throwable error) {
            OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(serverName, error.getMessage());
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "RESTClient(userId and password)", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error, "serverPlatformURLRoot or serverName");
        }
    }

    protected <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Throwable error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, params);
        }
        catch (Throwable error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Throwable error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Throwable error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    private void logRESTCallException(String methodName, Throwable error) throws PropertyServerException {
        OMAGCommonErrorCode errorCode = OMAGCommonErrorCode.CLIENT_SIDE_REST_API_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName, this.serverName, this.serverPlatformURLRoot, error.getMessage());
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
    }
}

