/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.OMAGCommonErrorCode;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class InvalidParameterHandler {
    private int maxPagingSize = 500;

    public void setMaxPagingSize(int maxPagingSize) {
        this.maxPagingSize = maxPagingSize;
    }

    public int getMaxPagingSize() {
        return this.maxPagingSize;
    }

    public void validateOMAGServerPlatformURL(String omagServerPlatformURL, String methodName) throws InvalidParameterException {
        if (omagServerPlatformURL == null) {
            String parameterName = "omagServerPlatformURL";
            throw new InvalidParameterException(OMAGCommonErrorCode.SERVER_URL_NOT_SPECIFIED.getMessageDefinition(), this.getClass().getName(), methodName, "omagServerPlatformURL");
        }
    }

    public void validateOMAGServerPlatformURL(String omagServerPlatformURL, String serverName, String methodName) throws InvalidParameterException {
        this.validateOMAGServerPlatformURL(omagServerPlatformURL, methodName);
        if (serverName == null) {
            String parameterName = "serverName";
            throw new InvalidParameterException(OMAGCommonErrorCode.SERVER_NAME_NOT_SPECIFIED.getMessageDefinition(), this.getClass().getName(), methodName, "serverName");
        }
    }

    public void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (userId == null) {
            String parameterName = "userId";
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_USER_ID.getMessageDefinition(methodName), this.getClass().getName(), methodName, "userId");
        }
    }

    public void validateGUID(String guid, String guidParameter, String methodName) throws InvalidParameterException {
        if (guid == null) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_GUID.getMessageDefinition(guidParameter, methodName), this.getClass().getName(), methodName, guidParameter);
        }
    }

    public void validateName(String name, String nameParameter, String methodName) throws InvalidParameterException {
        if (name == null) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_NAME.getMessageDefinition(nameParameter, methodName), this.getClass().getName(), methodName, nameParameter);
        }
    }

    public void validateSearchString(String searchString, String searchParameter, String methodName) throws InvalidParameterException {
        if (searchString == null || searchString.isEmpty()) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_SEARCH_STRING.getMessageDefinition(searchParameter, methodName), this.getClass().getName(), methodName, searchParameter);
        }
    }

    public void validateObject(Object object, String nameParameter, String methodName) throws InvalidParameterException {
        if (object == null) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_OBJECT.getMessageDefinition(nameParameter, methodName), this.getClass().getName(), methodName, nameParameter);
        }
    }

    public void validateEnum(Object enumValue, String parameterName, String methodName) throws InvalidParameterException {
        if (enumValue == null) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_ENUM.getMessageDefinition(parameterName, methodName), this.getClass().getName(), methodName, parameterName);
        }
    }

    public void validateText(String text, String parameterName, String methodName) throws InvalidParameterException {
        if (text == null) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_TEXT.getMessageDefinition(parameterName, methodName), this.getClass().getName(), methodName, parameterName);
        }
    }

    public int validatePaging(int startFrom, int pageSize, String methodName) throws InvalidParameterException {
        String startFromParameterName = "startFrom";
        String pageSizeParameterName = "pageSize";
        if (startFrom < 0) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NEGATIVE_START_FROM.getMessageDefinition(Integer.toString(startFrom), "startFrom", methodName), this.getClass().getName(), methodName, "startFrom");
        }
        if (pageSize < 0) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NEGATIVE_PAGE_SIZE.getMessageDefinition(Integer.toString(pageSize), "pageSize", methodName), this.getClass().getName(), methodName, "pageSize");
        }
        if (pageSize > this.maxPagingSize) {
            throw new InvalidParameterException(OMAGCommonErrorCode.MAX_PAGE_SIZE.getMessageDefinition(Integer.toString(pageSize), Integer.toString(this.maxPagingSize), methodName, Integer.toString(this.maxPagingSize)), this.getClass().getName(), methodName, "pageSize");
        }
        if (pageSize == 0) {
            return this.maxPagingSize;
        }
        return pageSize;
    }

    public void validateStringArray(List<String> stringArray, String parameterName, String methodName) throws InvalidParameterException {
        if (stringArray == null || stringArray.isEmpty()) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_ARRAY_PARAMETER.getMessageDefinition(parameterName, methodName), this.getClass().getName(), methodName, parameterName);
        }
    }

    public void validateConnection(Connection connection, String parameterName, String methodName) throws InvalidParameterException {
        if (connection == null) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_CONNECTION_PARAMETER.getMessageDefinition(parameterName, methodName), this.getClass().getName(), methodName, parameterName);
        }
        if (connection.getConnectorType() == null) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_CONNECTOR_TYPE_PARAMETER.getMessageDefinition(parameterName, methodName), this.getClass().getName(), methodName, parameterName);
        }
    }

    public String validateTypeName(String typeName, String superTypeName, String serviceName, String methodName, OMRSRepositoryHelper repositoryHelper) throws InvalidParameterException {
        String parameterName = "typeName";
        TypeDef typeDef = repositoryHelper.getTypeDefByName(serviceName, typeName);
        if (typeDef == null) {
            throw new InvalidParameterException(OMAGCommonErrorCode.UNRECOGNIZED_TYPE_NAME.getMessageDefinition(typeName, methodName, serviceName), this.getClass().getName(), methodName, "typeName");
        }
        if (!repositoryHelper.isTypeOf(serviceName, typeName, superTypeName)) {
            throw new InvalidParameterException(OMAGCommonErrorCode.BAD_SUB_TYPE_NAME.getMessageDefinition(typeName, methodName, serviceName, superTypeName), this.getClass().getName(), methodName, "typeName");
        }
        return typeDef.getGUID();
    }

    public void handleWrongTypeForGUIDException(String guid, String methodName, String actualType, String expectedType) throws InvalidParameterException {
        throw new InvalidParameterException(OMAGCommonErrorCode.INSTANCE_WRONG_TYPE_FOR_GUID.getMessageDefinition(methodName, guid, actualType, expectedType), this.getClass().getName(), methodName, expectedType);
    }

    public void validateInstanceProvenanceForUpdate(String instanceGUID, String parameterName, ElementHeader instanceHeader, ElementOrigin expectedOrigin, String expectedMetadataCollectionGUID, String expectedMetadataCollectionName, String serviceName, String methodName) throws InvalidParameterException {
        if (instanceHeader != null) {
            if (instanceHeader.getType() != null) {
                ElementType instanceType = instanceHeader.getType();
                if (expectedOrigin == null || instanceType.getElementOrigin() == expectedOrigin) {
                    if (expectedMetadataCollectionGUID == null) {
                        return;
                    }
                    if (expectedMetadataCollectionGUID.equals(instanceType.getElementHomeMetadataCollectionId())) {
                        return;
                    }
                }
                String expectedOriginName = "null";
                String instanceOriginName = "null";
                if (expectedOrigin != null) {
                    expectedOriginName = expectedOrigin.getName();
                }
                if (instanceType.getElementOrigin() != null) {
                    instanceOriginName = instanceType.getElementOrigin().getName();
                }
                throw new InvalidParameterException(OMAGCommonErrorCode.WRONG_METADATA_COLLECTION_FOR_UPDATE.getMessageDefinition(methodName, serviceName, instanceGUID, instanceType.getElementTypeName(), expectedOriginName, expectedMetadataCollectionName, expectedMetadataCollectionGUID, instanceOriginName, instanceType.getElementHomeMetadataCollectionName(), instanceType.getElementHomeMetadataCollectionId()), this.getClass().getName(), methodName, parameterName);
            }
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_OBJECT.getMessageDefinition("instanceHeader.getType()", methodName), this.getClass().getName(), methodName, parameterName);
        }
        throw new InvalidParameterException(OMAGCommonErrorCode.NULL_OBJECT.getMessageDefinition("instanceHeader", methodName), this.getClass().getName(), methodName, parameterName);
    }

    public void validateAssetInSupportedZone(String assetGUID, String parameterName, List<String> assetZones, List<String> supportedZones, String serviceName, String methodName) throws InvalidParameterException {
        if (supportedZones == null || supportedZones.isEmpty()) {
            return;
        }
        if (assetZones == null || assetZones.isEmpty()) {
            return;
        }
        for (String assetZoneName : assetZones) {
            if (assetZoneName == null) continue;
            for (String supportedZoneName : supportedZones) {
                if (!assetZoneName.equals(supportedZoneName)) continue;
                return;
            }
        }
        throw new InvalidParameterException(OMAGCommonErrorCode.NOT_IN_THE_ZONE.getMessageDefinition(assetGUID, serviceName), this.getClass().getName(), methodName, parameterName);
    }

    public void throwMethodNotSupported(String userId, String serviceName, String serverName, String methodName) throws InvalidParameterException {
        String parameterName = "methodName";
        throw new InvalidParameterException(OMAGCommonErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition(methodName, userId, serverName, serviceName), this.getClass().getName(), methodName, "methodName");
    }

    public void throwUnknownElement(String userId, String guid, String type, String serviceName, String serverName, String methodName) throws InvalidParameterException {
        String parameterName = "guid";
        throw new InvalidParameterException(OMAGCommonErrorCode.UNKNOWN_ELEMENT.getMessageDefinition(guid, type, userId, methodName, serviceName, serverName), this.getClass().getName(), methodName, "guid");
    }

    public void throwCannotDeleteElementInUse(String guid, String type, String serviceName, String methodName) throws InvalidParameterException {
        String parameterName = "guid";
        throw new InvalidParameterException(OMAGCommonErrorCode.CANNOT_DELETE_ELEMENT_IN_USE.getMessageDefinition(methodName, serviceName, type, guid), this.getClass().getName(), methodName, "guid");
    }
}

