/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import org.apache.commons.lang3.time.StopWatch;

public class RESTCallToken {
    private static long nextCallId = 0L;
    static final String PLATFORM_NAME = "<*>";
    private StopWatch watch;
    private long callId;
    private String serviceName;
    private String serverName;
    private String userId;
    private String methodName;
    private String threadName;

    private static synchronized long getNextCallId() {
        return nextCallId++;
    }

    RESTCallToken(String serviceName, String serverName, String userId, String methodName) {
        this.serviceName = serviceName;
        this.userId = userId;
        this.methodName = methodName;
        this.threadName = Thread.currentThread().getName();
        this.watch = StopWatch.createStarted();
        this.callId = RESTCallToken.getNextCallId();
        this.serverName = serverName == null ? PLATFORM_NAME : serverName;
    }

    String getRESTCallStartText() {
        Thread.currentThread().setName("REST:" + this.serviceName + ":" + this.methodName);
        return this.callId + ":" + this.serviceName + ":" + this.serverName + ":" + this.methodName + " call invoked by " + this.userId;
    }

    String getRESTCallReturnText(String response) {
        Thread.currentThread().setName(this.threadName);
        return this.callId + ":" + this.serviceName + ":" + this.serverName + ":" + this.methodName + " call invoked by " + this.userId + " returned with response " + response + "; Duration: " + this.watch.getTime() / 1000L + "seconds";
    }
}

