/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import org.apache.commons.lang3.time.StopWatch;

public class RESTCallToken {
    private static volatile long nextCallId = 0L;
    static final String PLATFORM_NAME = "<*>";
    private final StopWatch watch;
    private final long callId;
    private final String serviceName;
    private final String serverName;
    private String userId;
    private final String methodName;

    private static synchronized long getNextCallId() {
        return nextCallId++;
    }

    RESTCallToken(String serviceName, String serverName, String userId, String methodName) {
        this.serviceName = serviceName;
        this.userId = userId;
        this.methodName = methodName;
        this.watch = StopWatch.createStarted();
        this.callId = RESTCallToken.getNextCallId();
        this.serverName = serverName == null ? PLATFORM_NAME : serverName;
    }

    RESTCallToken(String serviceName, String serverName, String methodName) {
        this.serviceName = serviceName;
        this.userId = this.userId;
        this.methodName = methodName;
        this.watch = StopWatch.createStarted();
        this.callId = RESTCallToken.getNextCallId();
        this.serverName = serverName == null ? PLATFORM_NAME : serverName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    String getRESTCallStartText() {
        return this.callId + ":" + this.serviceName + ":" + this.serverName + ":" + this.methodName + " call invoked by " + this.userId;
    }

    String getRESTCallReturnText(String response) {
        return this.callId + ":" + this.serviceName + ":" + this.serverName + ":" + this.methodName + " call invoked by " + this.userId + " returned with response " + response + "; Duration: " + this.watch.getTime() / 1000L + "seconds";
    }
}

