/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum OMAGCommonAuditCode implements AuditLogMessageSet
{
    UNEXPECTED_EXCEPTION("OMAG-COMMON-0001", AuditLogRecordSeverityLevel.EXCEPTION, "The Open Metadata Service has generated an unexpected {0} exception during method {1}.  The message was: {2}", "The request returns a PropertyServerException.", "This is probably a logic error. Review the stack trace to identify where the error occurred and work to resolve the cause."),
    CLIENT_SIDE_REST_API_ERROR("OMAG-COMMON-0002", AuditLogRecordSeverityLevel.ERROR, "A client-side exception was received from API call {0} to OMAG Server {1} at {2}.  The error message was {3}", "The server has issued a call to the open metadata access service REST API in a remote server and has received an exception from the local client libraries.", "Look for errors in the local server's console to understand and correct the source of the error.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private OMAGCommonAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "OMAGCommonAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "', messageDefinition=" + this.getMessageDefinition() + "}";
    }
}

