/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamPlayerRequestBody
extends ExternalSourceRequestBody {
    private boolean leadershipRole = false;
    private String position = null;

    public TeamPlayerRequestBody() {
    }

    public TeamPlayerRequestBody(TeamPlayerRequestBody template) {
        super(template);
        if (template != null) {
            this.leadershipRole = template.getIsLeadershipRole();
            this.position = template.getPosition();
        }
    }

    public boolean getIsLeadershipRole() {
        return this.leadershipRole;
    }

    public void setIsLeadershipRole(boolean leadershipRole) {
        this.leadershipRole = leadershipRole;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    @Override
    public String toString() {
        return "TeamPlayerRequestBody{leadershipRole=" + this.leadershipRole + ", position='" + this.position + "', isLeadershipRole=" + this.getIsLeadershipRole() + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TeamPlayerRequestBody that = (TeamPlayerRequestBody)objectToCompare;
        return this.leadershipRole == that.leadershipRole && Objects.equals(this.position, that.position);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.leadershipRole, this.position);
    }
}

