/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.surveyaction.surveycsv;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreConnector;
import org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfile.SurveyFileAnnotationType;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.NestedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.SchemaAttributes;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassification;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassifier;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ArchiveProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyOpenMetadataStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.FileMetric;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourcePhysicalStatusAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SchemaAnalysisAnnotation;

public class CSVSurveyService
extends SurveyActionServiceConnector {
    private static final String STRING_TYPE_NAME = "string";
    private static final String CHAR_TYPE_NAME = "char";
    private static final String DATE_TYPE_NAME = "date";
    private static final String INT_TYPE_NAME = "int";
    private static final String LONG_TYPE_NAME = "long";
    private static final String BOOLEAN_TYPE_NAME = "boolean";
    private static final String FLOAT_TYPE_NAME = "float";
    private static final String BOOLEAN_UC_TRUE = "TRUE";
    private static final String BOOLEAN_LC_TRUE = "true";
    private static final String BOOLEAN_UC_FALSE = "FALSE";
    private static final String BOOLEAN_LC_FALSE = "false";
    private static final String schemaType = "TabularSchemaType";
    private static final String schemaName = "CSV";
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private Connector connector = null;

    private String getDataFieldType(String existingType, String newFieldValue) {
        if (STRING_TYPE_NAME.equals(existingType)) {
            return STRING_TYPE_NAME;
        }
        if (newFieldValue == null) {
            return existingType;
        }
        if (BOOLEAN_LC_TRUE.equals(newFieldValue) || BOOLEAN_UC_TRUE.equals(newFieldValue) || BOOLEAN_LC_FALSE.equals(newFieldValue) || BOOLEAN_UC_FALSE.equals(newFieldValue)) {
            if (existingType == null || existingType.equals(BOOLEAN_TYPE_NAME)) {
                return BOOLEAN_TYPE_NAME;
            }
            return STRING_TYPE_NAME;
        }
        return STRING_TYPE_NAME;
    }

    private Map<String, Integer> getValueCount(Map<String, Integer> existingValueCount, String newFieldValue) {
        if (existingValueCount == null) {
            HashMap<String, Integer> newValueCount = new HashMap<String, Integer>();
            newValueCount.put(newFieldValue, 1);
            return newValueCount;
        }
        Integer countForValue = existingValueCount.get(newFieldValue);
        if (countForValue == null) {
            existingValueCount.put(newFieldValue, 1);
        } else {
            existingValueCount.put(newFieldValue, countForValue + 1);
        }
        return existingValueCount;
    }

    private List<String> getValueList(List<String> existingValueList, String newFieldValue) {
        if (existingValueList == null) {
            ArrayList<String> newValueList = new ArrayList<String>();
            newValueList.add(newFieldValue);
            return newValueList;
        }
        if (!existingValueList.contains(newFieldValue)) {
            existingValueList.add(newFieldValue);
        }
        return existingValueList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            int columnNumber;
            SchemaAttributes schemaAttributes;
            String schemaTypeGUID;
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            SurveyOpenMetadataStore openMetadataStore = this.surveyContext.getOpenMetadataStore();
            SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
            annotationStore.setAnalysisStep(AnalysisStep.CHECK_ASSET.getName());
            AssetUniverse assetUniverse = assetStore.getAssetProperties();
            if (assetUniverse == null) {
                super.throwNoAsset(assetStore.getAssetGUID(), this.surveyActionServiceName, "start");
                return;
            }
            if (!this.propertyHelper.isTypeOf((ElementControlHeader)assetUniverse, OpenMetadataType.CSV_FILE.typeName)) {
                super.throwWrongTypeOfAsset(assetUniverse.getGUID(), assetUniverse.getType().getTypeName(), OpenMetadataType.CSV_FILE.typeName, "start");
                return;
            }
            this.connector = assetStore.getConnectorToAsset();
            CSVFileStoreConnector assetConnector = (CSVFileStoreConnector)this.connector;
            long recordCount = assetConnector.getRecordCount();
            File file = assetConnector.getFile();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
            FileClassifier fileClassifier = this.surveyContext.getFileClassifier();
            FileClassification fileClassification = fileClassifier.classifyFile(file);
            ResourcePhysicalStatusAnnotation measurementAnnotation = new ResourcePhysicalStatusAnnotation();
            measurementAnnotation.setAnnotationType(SurveyFileAnnotationType.MEASUREMENTS.getName());
            measurementAnnotation.setSummary(SurveyFileAnnotationType.MEASUREMENTS.getSummary());
            measurementAnnotation.setExplanation(SurveyFileAnnotationType.MEASUREMENTS.getExplanation());
            measurementAnnotation.setCreateTime(assetConnector.getCreationDate());
            measurementAnnotation.setModifiedTime(assetConnector.getLastUpdateDate());
            measurementAnnotation.setLastAccessedTime(assetConnector.getLastAccessDate());
            measurementAnnotation.setSize(assetConnector.getFileLength());
            HashMap<String, String> dataSourceProperties = new HashMap<String, String>();
            dataSourceProperties.put(FileMetric.FILE_NAME.displayName, fileClassification.getFileName());
            dataSourceProperties.put(FileMetric.PATH_NAME.displayName, fileClassification.getPathName());
            dataSourceProperties.put(FileMetric.FILE_EXTENSION.displayName, fileClassification.getFileExtension());
            dataSourceProperties.put(FileMetric.FILE_TYPE.displayName, fileClassification.getFileType());
            dataSourceProperties.put(FileMetric.DEPLOYED_IMPLEMENTATION_TYPE.displayName, fileClassification.getDeployedImplementationType());
            dataSourceProperties.put(FileMetric.ENCODING.displayName, fileClassification.getEncoding());
            dataSourceProperties.put(FileMetric.ASSET_TYPE_NAME.displayName, fileClassification.getAssetTypeName());
            dataSourceProperties.put(FileMetric.CAN_READ.displayName, Boolean.toString(fileClassification.isCanRead()));
            dataSourceProperties.put(FileMetric.CAN_WRITE.displayName, Boolean.toString(fileClassification.isCanWrite()));
            dataSourceProperties.put(FileMetric.CAN_EXECUTE.displayName, Boolean.toString(fileClassification.isCanExecute()));
            dataSourceProperties.put(FileMetric.IS_SYM_LINK.displayName, Boolean.toString(fileClassification.isSymLink()));
            dataSourceProperties.put(FileMetric.IS_HIDDEN.displayName, Boolean.toString(fileClassification.isHidden()));
            dataSourceProperties.put(FileMetric.RECORD_COUNT.displayName, Long.toString(recordCount));
            measurementAnnotation.setResourceProperties(dataSourceProperties);
            annotationStore.addAnnotation((Annotation)measurementAnnotation, this.surveyContext.getAssetGUID());
            annotationStore.setAnalysisStep(AnalysisStep.SCHEMA_EXTRACTION.getName());
            SchemaType rootSchemaType = assetUniverse.getRootSchemaType();
            if (rootSchemaType == null) {
                schemaTypeGUID = this.createSchemaType(openMetadataStore, assetUniverse);
                schemaAttributes = null;
            } else {
                if (!(rootSchemaType instanceof NestedSchemaType)) {
                    assetStore.logAssetAuditMessage(this.surveyActionServiceName, "Invalid type of root schema: " + rootSchemaType.getClass().getName());
                    super.throwWrongTypeOfRootSchema(assetUniverse.getGUID(), rootSchemaType.getType().getTypeName(), schemaType, this.surveyActionServiceName, "start");
                    return;
                }
                NestedSchemaType nestedSchemaType = (NestedSchemaType)rootSchemaType;
                if (!this.propertyHelper.isTypeOf((ElementControlHeader)nestedSchemaType, schemaType)) {
                    assetStore.logAssetAuditMessage(this.surveyActionServiceName, "Invalid type of nested root schema: " + rootSchemaType.getClass().getName());
                    super.throwWrongTypeOfRootSchema(assetUniverse.getGUID(), nestedSchemaType.getType().getTypeName(), schemaType, this.surveyActionServiceName, "start");
                    return;
                }
                schemaTypeGUID = nestedSchemaType.getGUID();
                schemaAttributes = nestedSchemaType.getSchemaAttributes();
            }
            List columnNames = assetConnector.getColumnNames();
            SchemaAnalysisAnnotation schemaAnnotation = new SchemaAnalysisAnnotation();
            schemaAnnotation.setAnnotationType("DeriveSchemaFromData");
            schemaAnnotation.setSummary("Extract schema from column names and values.");
            schemaAnnotation.setSchemaName(schemaName);
            schemaAnnotation.setSchemaTypeName(schemaType);
            schemaAnnotation.setAnnotationStatus(AnnotationStatus.NEW_ANNOTATION);
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            if (columnNames != null) {
                additionalProperties.put("Column Count", Integer.toString(columnNames.size()));
                additionalProperties.put("Column Names", columnNames.toString());
            } else {
                additionalProperties.put("Column Count", "0");
                additionalProperties.put("Column Names", "[]");
            }
            schemaAnnotation.setAdditionalProperties(additionalProperties);
            annotationStore.addAnnotation((Annotation)schemaAnnotation, schemaTypeGUID);
            annotationStore.setAnalysisStep(AnalysisStep.PROFILE_DATA.getName());
            HashMap<Integer, DataField> dataFields = new HashMap<Integer, DataField>();
            if (columnNames == null) return;
            int position = 0;
            for (String columnName : columnNames) {
                if (columnName == null) continue;
                DataField dataField = new DataField();
                dataField.setDataFieldPosition(position);
                dataField.setDataFieldName(columnName);
                ResourceProfileAnnotation dataProfile = dataField.getDataProfileAnnotation();
                dataProfile.setAnnotationType("InspectDataValues");
                dataProfile.setSummary("Iterate through values to determine values present and how often they appear.");
                dataFields.put(position, dataField);
                ++position;
            }
            int recordNumber = 0;
            while ((long)recordNumber < recordCount) {
                List recordValues = assetConnector.readRecord(recordNumber);
                if (recordValues != null && !recordValues.isEmpty()) {
                    int columnPosition = 0;
                    int recordLength = 0;
                    for (String fieldValue : recordValues) {
                        DataField dataField = (DataField)dataFields.get(columnPosition);
                        ResourceProfileAnnotation dataProfile = dataField.getDataProfileAnnotation();
                        dataField.setDataFieldType(this.getDataFieldType(dataField.getDataFieldType(), fieldValue));
                        dataProfile.setValueCount(this.getValueCount(dataProfile.getValueCount(), fieldValue));
                        dataProfile.setValueList(this.getValueList(dataProfile.getValueList(), fieldValue));
                        recordLength += fieldValue.length();
                        ++columnPosition;
                    }
                }
                ++recordNumber;
            }
            if (schemaAttributes == null) {
                for (columnNumber = 0; columnNumber < columnNames.size(); ++columnNumber) {
                    String schemaAttributeGUID = this.addSchemaAttributeToSchemaType((OpenMetadataStore)openMetadataStore, assetUniverse, schemaTypeGUID, (DataField)dataFields.get(columnNumber));
                    annotationStore.addAnnotation((Annotation)((DataField)dataFields.get(columnNumber)).getDataProfileAnnotation(), schemaAttributeGUID);
                }
                return;
            }
            columnNumber = 0;
            while (true) {
                if (!schemaAttributes.hasNext()) break;
                SchemaAttribute schemaAttribute = schemaAttributes.next();
                boolean found = false;
                for (int i = columnNumber; i < columnNames.size(); ++i) {
                    DataField dataField = (DataField)dataFields.get(i);
                    if (!dataField.getDataFieldName().equals(schemaAttribute.getDisplayName())) continue;
                    dataField.setMatchingSchemaAttributeGUID(schemaAttribute.getGUID());
                    found = true;
                    break;
                }
                if (found) continue;
                ArchiveProperties archiveProperties = new ArchiveProperties();
                archiveProperties.setArchiveDate(new Date());
                archiveProperties.setArchiveProcess(this.surveyActionServiceName);
                openMetadataStore.archiveMetadataElementInStore(schemaAttribute.getGUID(), archiveProperties);
            }
            for (int i = 0; i < columnNames.size(); ++i) {
                DataField dataField = (DataField)dataFields.get(i);
                if (dataField.getMatchingSchemaAttributeGUID() == null) {
                    String schemaAttributeGUID = this.addSchemaAttributeToSchemaType((OpenMetadataStore)openMetadataStore, assetUniverse, schemaTypeGUID, dataField);
                    dataField.setMatchingSchemaAttributeGUID(schemaAttributeGUID);
                } else {
                    this.updateSchemaAttribute(openMetadataStore, dataField.getMatchingSchemaAttributeGUID(), dataField);
                }
                annotationStore.addAnnotation((Annotation)dataField.getDataProfileAnnotation(), dataField.getMatchingSchemaAttributeGUID());
            }
            return;
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }

    private String createSchemaType(SurveyOpenMetadataStore openMetadataStore, AssetUniverse assetUniverse) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, assetUniverse.getQualifiedName() + "_rootSchemaType");
        String schemaTypeGUID = openMetadataStore.createMetadataElementInStore(schemaType, ElementStatus.ACTIVE, elementProperties);
        if (schemaTypeGUID != null) {
            openMetadataStore.createRelatedElementsInStore("AssetSchemaType", assetUniverse.getGUID(), schemaTypeGUID, null, null, null);
        }
        return schemaTypeGUID;
    }

    private String addSchemaAttributeToSchemaType(OpenMetadataStore openMetadataStore, AssetUniverse assetUniverse, String schemaTypeGUID, DataField dataField) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, assetUniverse.getQualifiedName() + "_column_" + dataField.dataFieldPosition + "_" + dataField.dataFieldName);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, dataField.getDataFieldName());
        elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.POSITION.name, dataField.getDataFieldPosition());
        HashMap<String, ElementProperties> initialClassifications = new HashMap<String, ElementProperties>();
        ElementProperties classificationProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.SCHEMA_TYPE_NAME.name, "PrimitiveSchemaType");
        classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, OpenMetadataProperty.DATA_TYPE.name, dataField.getDataFieldType());
        initialClassifications.put("TypeEmbeddedAttribute", classificationProperties);
        return openMetadataStore.createMetadataElementInStore("TabularColumn", ElementStatus.ACTIVE, initialClassifications, assetUniverse.getGUID(), false, null, null, elementProperties, schemaTypeGUID, "AttributeForSchema", null, true);
    }

    private void updateSchemaAttribute(SurveyOpenMetadataStore openMetadataStore, String schemaAttributeGUID, DataField dataField) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.DISPLAY_NAME.name, dataField.getDataFieldName());
        elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.POSITION.name, dataField.getDataFieldPosition());
        openMetadataStore.updateMetadataElementInStore(schemaAttributeGUID, false, elementProperties);
        ElementProperties classificationProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.SCHEMA_TYPE_NAME.name, "PrimitiveSchemaType");
        classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, OpenMetadataProperty.DATA_TYPE.name, dataField.getDataFieldType());
        openMetadataStore.reclassifyMetadataElementInStore(schemaAttributeGUID, "TypeEmbeddedAttribute", false, classificationProperties);
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        if (this.connector != null) {
            this.connector.disconnect();
        }
        super.disconnect();
    }

    private static class DataField {
        private String dataFieldName = null;
        private String dataFieldType = null;
        private int dataFieldPosition = 0;
        private final ResourceProfileAnnotation resourceProfileAnnotation = new ResourceProfileAnnotation();
        private String matchingSchemaAttributeGUID = null;

        private DataField() {
        }

        public String getDataFieldName() {
            return this.dataFieldName;
        }

        public void setDataFieldName(String dataFieldName) {
            this.dataFieldName = dataFieldName;
        }

        public String getDataFieldType() {
            return this.dataFieldType;
        }

        public void setDataFieldType(String dataFieldType) {
            this.dataFieldType = dataFieldType;
        }

        public int getDataFieldPosition() {
            return this.dataFieldPosition;
        }

        public void setDataFieldPosition(int dataFieldPosition) {
            this.dataFieldPosition = dataFieldPosition;
        }

        public String getMatchingSchemaAttributeGUID() {
            return this.matchingSchemaAttributeGUID;
        }

        public void setMatchingSchemaAttributeGUID(String matchingSchemaAttributeGUID) {
            this.matchingSchemaAttributeGUID = matchingSchemaAttributeGUID;
        }

        public ResourceProfileAnnotation getDataProfileAnnotation() {
            return this.resourceProfileAnnotation;
        }
    }
}

