/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfile;

import java.io.File;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStore;
import org.odpi.openmetadata.adapters.connectors.surveyaction.extractors.FileStatsExtractor;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;

public class FileSurveyService
extends SurveyActionServiceConnector {
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private Connector connector = null;

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
            annotationStore.setAnalysisStep(AnalysisStep.CHECK_ASSET.getName());
            AssetUniverse assetUniverse = assetStore.getAssetProperties();
            if (assetUniverse == null) {
                super.throwNoAsset(assetStore.getAssetGUID(), this.surveyActionServiceName, "start");
                return;
            }
            if (!this.propertyHelper.isTypeOf((ElementControlHeader)assetUniverse, OpenMetadataType.DATA_FILE.typeName)) {
                super.throwWrongTypeOfAsset(assetUniverse.getGUID(), assetUniverse.getType().getTypeName(), OpenMetadataType.DATA_FILE.typeName, "start");
                return;
            }
            this.connector = assetStore.getConnectorToAsset();
            BasicFileStore assetConnector = (BasicFileStore)this.connector;
            File file = assetConnector.getFile();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
            FileStatsExtractor fileStatsExtractor = new FileStatsExtractor(file, this.surveyContext.getFileClassifier(), this);
            Annotation measurementAnnotation = fileStatsExtractor.getAnnotation();
            if (measurementAnnotation != null) {
                annotationStore.addAnnotation(measurementAnnotation, this.surveyContext.getAssetGUID());
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        if (this.connector != null) {
            this.connector.disconnect();
        }
        super.disconnect();
    }
}

