/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.FileMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum SurveyFileAnnotationType {
    MEASUREMENTS("Extract File Properties", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Extract properties from the file.", "Extract the properties that visible through the standard File interface and classify the file using reference data.", FileMetric.getMetrics());

    public final String name;
    public final String openMetadataTypeName;
    public final String summary;
    public final String explanation;
    public final List<SurveyMetric> metrics;

    private SurveyFileAnnotationType(String name, String openMetadataTypeName, String summary, String explanation, List<SurveyMetric> metrics) {
        this.name = name;
        this.openMetadataTypeName = openMetadataTypeName;
        this.summary = summary;
        this.explanation = explanation;
        this.metrics = metrics;
    }

    public static List<AnnotationTypeType> getAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        for (SurveyFileAnnotationType atlasAnnotationType : SurveyFileAnnotationType.values()) {
            annotationTypeTypes.add(atlasAnnotationType.getAnnotationTypeType());
        }
        return annotationTypeTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getAnalysisStep() {
        return AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName();
    }

    public String getOpenMetadataTypeName() {
        return this.openMetadataTypeName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public AnnotationTypeType getAnnotationTypeType() {
        AnnotationTypeType annotationTypeType = new AnnotationTypeType();
        annotationTypeType.setName(this.name);
        annotationTypeType.setOpenMetadataTypeName(this.openMetadataTypeName);
        annotationTypeType.setAnalysisStepName(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
        annotationTypeType.setSummary(this.summary);
        annotationTypeType.setExplanation(this.explanation);
        if (this.metrics != null) {
            HashMap<String, String> metricsMap = new HashMap<String, String>();
            for (SurveyMetric folderMetric : this.metrics) {
                metricsMap.put(folderMetric.getDisplayName(), folderMetric.getDescription());
            }
            annotationTypeType.setOtherPropertyValues(metricsMap);
        }
        return annotationTypeType;
    }

    public String toString() {
        return "AnnotationType{ name='" + this.name + "}";
    }
}

