/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfolder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.FileDirectoryMetric;

public enum SurveyFolderAnnotationType {
    MEASUREMENTS("Capture File Counts", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Count up the number of files and directories under the surveyed directory that have specific characteristics.", "Count the number of directories and files under the starting directory.", FileDirectoryMetric.getMetrics()),
    PROFILE_FILE_EXTENSIONS("Profile File Extensions", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Iterate through files under a directory (folder) and count the occurrences of each file extension.", "The file extension often provides a hint as to the type of file.", null),
    PROFILE_FILE_NAMES("Profile File Names to External Log", OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.typeName, "Iterate through files under a directory (folder) and count the occurrences of each file name.", "Some file names indicate a file of special type/use.  This profile information is likely to be large so it is logged to a CSV File.", null),
    PROFILE_FILE_TYPES("Profile File Types", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Iterate through files under a directory (folder) and count the occurrences of each file type.", "The file type is a category of file that describes its use.  The file types are defined as reference data in Egeria.", null),
    PROFILE_ASSET_TYPES("Profile Asset Types", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Iterate through files under a directory (folder) and count each potential asset type if they were to be catalogued in open metadata.", "The asset type is an open metadata type.  This annotation identifies the numbers of each type of asset that will be created if the files were catalogued in the open metadata ecosystem.", null),
    PROFILE_DEP_IMPL_TYPES("Profile Deployed Implementation Types", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Iterate through files under a directory (folder) and count each potential deployed implementation type if they were to be catalogued in open metadata.", "The deployed implementation type reflects the technology employed within this resource.  The deployed implementation type is defined as reference data in Egeria.", null),
    MISSING_REF_DATA("Missing File Reference Data", OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName, "List of files that could not be classified using the file reference data.", "The survey service uses reference data to classify the purpose of files based on their file name.  This annotation captures all of the file names that could not be matched to the reference data. If any of these reveal files that are important to your organization then the reference data should be enhanced to include these files.", null),
    INACCESSIBLE_FILES("Inaccessible files", OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName, "List of files that the survey service was unable to retrieve the basic attributes for.", "The survey service retrieves the basic attributes of a file as part of its profiling effort.  A file I/O error uses reference data to classify the purpose of files based on their file name.  This annotation captures all of the file names that could not be matched to the reference data. If any of these reveal files that are important to your organization then the reference data should be enhanced to include these files.", null);

    public final String name;
    public final String openMetadataTypeName;
    public final String summary;
    public final String explanation;
    public final List<FileDirectoryMetric> metrics;

    private SurveyFolderAnnotationType(String name, String openMetadataTypeName, String summary, String explanation, List<FileDirectoryMetric> metrics) {
        this.name = name;
        this.openMetadataTypeName = openMetadataTypeName;
        this.summary = summary;
        this.explanation = explanation;
        this.metrics = metrics;
    }

    public static List<AnnotationTypeType> getAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        for (SurveyFolderAnnotationType atlasAnnotationType : SurveyFolderAnnotationType.values()) {
            annotationTypeTypes.add(atlasAnnotationType.getAnnotationTypeType());
        }
        return annotationTypeTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getAnalysisStep() {
        return AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName();
    }

    public String getOpenMetadataTypeName() {
        return this.openMetadataTypeName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public AnnotationTypeType getAnnotationTypeType() {
        AnnotationTypeType annotationTypeType = new AnnotationTypeType();
        annotationTypeType.setName(this.name);
        annotationTypeType.setOpenMetadataTypeName(this.openMetadataTypeName);
        annotationTypeType.setAnalysisStepName(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
        annotationTypeType.setSummary(this.summary);
        annotationTypeType.setExplanation(this.explanation);
        if (this.metrics != null) {
            HashMap<String, String> metricsMap = new HashMap<String, String>();
            for (FileDirectoryMetric fileDirectoryMetric : this.metrics) {
                metricsMap.put(fileDirectoryMetric.getDisplayName(), fileDirectoryMetric.getDescription());
            }
            annotationTypeType.setOtherPropertyValues(metricsMap);
        }
        return annotationTypeType;
    }

    public String toString() {
        return "AnnotationType{ name='" + this.name + "}";
    }
}

