/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.surveyaction.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum SurveyServiceAuditCode implements AuditLogMessageSet
{
    UNEXPECTED_EXCEPTION("SURVEY-ACTION-SERVICE-0001", AuditLogRecordSeverityLevel.EXCEPTION, "The survey action service {0} received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to process the current request.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    CREATING_LOG_FILE("SURVEY-ACTION-SERVICE-0002", AuditLogRecordSeverityLevel.INFO, "The survey action service {0} is creating log file {1} which is catalogued as CSVFile asset {2}", "This message tells the survey team that a particular survey log file is being created.", "No specific action is required.  The results are added to the log file and the asset for this log file is catalogued as a CSV file."),
    REUSING_LOG_FILE("SURVEY-ACTION-SERVICE-0003", AuditLogRecordSeverityLevel.INFO, "The survey action service {0} is overriding log file {1}", "This message warns the survey team that a particular survey log file is being reused.", "No specific action is required.  The new results are appended to the existing results."),
    SURVEYING_FOLDER("SURVEY-ACTION-SERVICE-0004", AuditLogRecordSeverityLevel.INFO, "The survey action service {0} is surveying the {1} folder (directory) with an analysis level of {2}", "This message shows that the starting folder to survey.", "No specific action is required.  This message is marking the start of the survey process."),
    PROGRESS_REPORT("SURVEY-ACTION-SERVICE-0005", AuditLogRecordSeverityLevel.INFO, "The survey action service {0} is has surveyed {1} files and folders (directories)", "This message shows that the progress of the survey.", "No specific action is required.  This message is marking the progress of the survey process."),
    FILE_IO_ERROR("SURVEY-ACTION-SERVICE-0006", AuditLogRecordSeverityLevel.ERROR, "The survey action service {0} received an unexpected IO exception {1} when it attempted to access the attributes of file {2}; the error message was: {3}", "The file is skipped and will not appear in the totals for this folder.  However a separate request for action annotation with a log file of all of the inaccessible files is created.", "If this file is of interest and you want it to be included in the survey report, use the details from the error message to determine the cause of the access error; retry the survey once it is resolved.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private SurveyServiceAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "SurveyServiceAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

