/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.surveyaction.surveycsv;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreConnector;
import org.odpi.openmetadata.adapters.connectors.surveyaction.extractors.FileStatsExtractor;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.NestedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.SchemaAttributes;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ArchiveProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyOpenMetadataStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyFileAnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SchemaAnalysisAnnotation;

public class CSVSurveyService
extends SurveyActionServiceConnector {
    private static final String STRING_TYPE_NAME = "string";
    private static final String CHAR_TYPE_NAME = "char";
    private static final String DATE_TYPE_NAME = "date";
    private static final String INT_TYPE_NAME = "int";
    private static final String LONG_TYPE_NAME = "long";
    private static final String BOOLEAN_TYPE_NAME = "boolean";
    private static final String FLOAT_TYPE_NAME = "float";
    private static final String BOOLEAN_UC_TRUE = "TRUE";
    private static final String BOOLEAN_LC_TRUE = "true";
    private static final String BOOLEAN_UC_FALSE = "FALSE";
    private static final String BOOLEAN_LC_FALSE = "false";
    private static final String schemaType = "TabularSchemaType";
    private static final String schemaName = "CSV";
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private Connector connector = null;

    private String getDataFieldType(String existingType, String newFieldValue) {
        if (STRING_TYPE_NAME.equals(existingType)) {
            return STRING_TYPE_NAME;
        }
        if (newFieldValue == null) {
            return existingType;
        }
        if (BOOLEAN_LC_TRUE.equals(newFieldValue) || BOOLEAN_UC_TRUE.equals(newFieldValue) || BOOLEAN_LC_FALSE.equals(newFieldValue) || BOOLEAN_UC_FALSE.equals(newFieldValue)) {
            if (existingType == null || existingType.equals(BOOLEAN_TYPE_NAME)) {
                return BOOLEAN_TYPE_NAME;
            }
            return STRING_TYPE_NAME;
        }
        return STRING_TYPE_NAME;
    }

    private Map<String, Integer> getValueCount(Map<String, Integer> existingValueCount, String newFieldValue) {
        if (existingValueCount == null) {
            HashMap<String, Integer> newValueCount = new HashMap<String, Integer>();
            newValueCount.put(newFieldValue, 1);
            return newValueCount;
        }
        Integer countForValue = existingValueCount.get(newFieldValue);
        if (countForValue == null) {
            existingValueCount.put(newFieldValue, 1);
        } else {
            existingValueCount.put(newFieldValue, countForValue + 1);
        }
        return existingValueCount;
    }

    private List<String> getValueList(List<String> existingValueList, String newFieldValue) {
        if (existingValueList == null) {
            ArrayList<String> newValueList = new ArrayList<String>();
            newValueList.add(newFieldValue);
            return newValueList;
        }
        if (!existingValueList.contains(newFieldValue)) {
            existingValueList.add(newFieldValue);
        }
        return existingValueList;
    }

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            SchemaAttributes schemaAttributes;
            String schemaTypeGUID;
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            SurveyOpenMetadataStore openMetadataStore = this.surveyContext.getOpenMetadataStore();
            SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
            this.connector = super.performCheckAssetAnalysisStep(CSVFileStoreConnector.class, OpenMetadataType.CSV_FILE.typeName);
            AssetUniverse assetUniverse = assetStore.getAssetProperties();
            CSVFileStoreConnector assetConnector = (CSVFileStoreConnector)this.connector;
            long recordCount = assetConnector.getRecordCount();
            File file = assetConnector.getFile();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
            FileStatsExtractor fileStatsExtractor = new FileStatsExtractor(file, this.surveyContext.getFileClassifier(), this);
            Annotation measurementAnnotation = fileStatsExtractor.getAnnotation();
            if (measurementAnnotation != null) {
                annotationStore.addAnnotation(measurementAnnotation, this.surveyContext.getAssetGUID());
            }
            annotationStore.setAnalysisStep(AnalysisStep.SCHEMA_EXTRACTION.getName());
            NestedSchemaType nestedSchemaType = super.getNestedSchemaType(assetUniverse, schemaType);
            if (nestedSchemaType == null) {
                schemaTypeGUID = this.createSchemaType(openMetadataStore, assetUniverse);
                schemaAttributes = null;
            } else {
                schemaTypeGUID = nestedSchemaType.getGUID();
                schemaAttributes = nestedSchemaType.getSchemaAttributes();
            }
            List columnNames = assetConnector.getColumnNames();
            SchemaAnalysisAnnotation schemaAnnotation = new SchemaAnalysisAnnotation();
            schemaAnnotation.setAnnotationType(SurveyFileAnnotationType.DERIVE_SCHEMA_FROM_DATA.getName());
            schemaAnnotation.setSummary(SurveyFileAnnotationType.DERIVE_SCHEMA_FROM_DATA.getSummary());
            schemaAnnotation.setExplanation(SurveyFileAnnotationType.DERIVE_SCHEMA_FROM_DATA.getExplanation());
            schemaAnnotation.setAnalysisStep(SurveyFileAnnotationType.DERIVE_SCHEMA_FROM_DATA.getAnalysisStep());
            schemaAnnotation.setSchemaName(schemaName);
            schemaAnnotation.setSchemaTypeName(schemaType);
            schemaAnnotation.setAnnotationStatus(AnnotationStatus.NEW_ANNOTATION);
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            if (columnNames != null) {
                additionalProperties.put("Column Count", Integer.toString(columnNames.size()));
                additionalProperties.put("Column Names", columnNames.toString());
            } else {
                additionalProperties.put("Column Count", "0");
                additionalProperties.put("Column Names", "[]");
            }
            schemaAnnotation.setAdditionalProperties(additionalProperties);
            annotationStore.addAnnotation((Annotation)schemaAnnotation, schemaTypeGUID);
            annotationStore.setAnalysisStep(AnalysisStep.PROFILE_DATA.getName());
            HashMap<Integer, DataField> dataFields = new HashMap<Integer, DataField>();
            if (columnNames != null) {
                int position = 0;
                for (String columnName : columnNames) {
                    if (columnName == null) continue;
                    DataField dataField = new DataField();
                    dataField.setDataFieldPosition(position);
                    dataField.setDataFieldName(columnName);
                    ResourceProfileAnnotation dataProfile = dataField.getDataProfileAnnotation();
                    dataProfile.setAnnotationType("InspectDataValues");
                    dataProfile.setSummary("Iterate through values to determine values present and how often they appear.");
                    dataFields.put(position, dataField);
                    ++position;
                }
                for (long recordNumber = 0L; recordNumber < recordCount; ++recordNumber) {
                    List recordValues = assetConnector.readRecord(recordNumber);
                    if (recordValues == null || recordValues.isEmpty()) continue;
                    int columnPosition = 0;
                    int recordLength = 0;
                    for (String fieldValue : recordValues) {
                        DataField dataField = (DataField)dataFields.get(columnPosition);
                        ResourceProfileAnnotation dataProfile = dataField.getDataProfileAnnotation();
                        dataField.setDataFieldType(this.getDataFieldType(dataField.getDataFieldType(), fieldValue));
                        dataProfile.setValueCount(this.getValueCount(dataProfile.getValueCount(), fieldValue));
                        dataProfile.setValueList(this.getValueList(dataProfile.getValueList(), fieldValue));
                        recordLength += fieldValue.length();
                        ++columnPosition;
                    }
                }
                if (schemaAttributes == null) {
                    for (int columnNumber = 0; columnNumber < columnNames.size(); ++columnNumber) {
                        String schemaAttributeGUID = this.addSchemaAttributeToSchemaType((OpenMetadataStore)openMetadataStore, assetUniverse, schemaTypeGUID, (DataField)dataFields.get(columnNumber));
                        annotationStore.addAnnotation((Annotation)((DataField)dataFields.get(columnNumber)).getDataProfileAnnotation(), schemaAttributeGUID);
                    }
                } else {
                    int columnNumber = 0;
                    while (schemaAttributes.hasNext()) {
                        SchemaAttribute schemaAttribute = schemaAttributes.next();
                        boolean found = false;
                        for (int i = columnNumber; i < columnNames.size(); ++i) {
                            DataField dataField = (DataField)dataFields.get(i);
                            if (!dataField.getDataFieldName().equals(schemaAttribute.getDisplayName())) continue;
                            dataField.setMatchingSchemaAttributeGUID(schemaAttribute.getGUID());
                            found = true;
                            break;
                        }
                        if (found) continue;
                        ArchiveProperties archiveProperties = new ArchiveProperties();
                        archiveProperties.setArchiveDate(new Date());
                        archiveProperties.setArchiveProcess(this.surveyActionServiceName);
                        openMetadataStore.archiveMetadataElementInStore(schemaAttribute.getGUID(), archiveProperties);
                    }
                    for (int i = 0; i < columnNames.size(); ++i) {
                        DataField dataField = (DataField)dataFields.get(i);
                        if (dataField.getMatchingSchemaAttributeGUID() == null) {
                            String schemaAttributeGUID = this.addSchemaAttributeToSchemaType((OpenMetadataStore)openMetadataStore, assetUniverse, schemaTypeGUID, dataField);
                            dataField.setMatchingSchemaAttributeGUID(schemaAttributeGUID);
                        } else {
                            this.updateSchemaAttribute(openMetadataStore, dataField.getMatchingSchemaAttributeGUID(), dataField);
                        }
                        annotationStore.addAnnotation((Annotation)dataField.getDataProfileAnnotation(), dataField.getMatchingSchemaAttributeGUID());
                    }
                }
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }

    private String createSchemaType(SurveyOpenMetadataStore openMetadataStore, AssetUniverse assetUniverse) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, assetUniverse.getQualifiedName() + "_rootSchemaType");
        String schemaTypeGUID = openMetadataStore.createMetadataElementInStore(schemaType, ElementStatus.ACTIVE, elementProperties);
        if (schemaTypeGUID != null) {
            openMetadataStore.createRelatedElementsInStore("AssetSchemaType", assetUniverse.getGUID(), schemaTypeGUID, null, null, null);
        }
        return schemaTypeGUID;
    }

    private String addSchemaAttributeToSchemaType(OpenMetadataStore openMetadataStore, AssetUniverse assetUniverse, String schemaTypeGUID, DataField dataField) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, assetUniverse.getQualifiedName() + "_column_" + dataField.dataFieldPosition + "_" + dataField.dataFieldName);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, dataField.getDataFieldName());
        elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.POSITION.name, dataField.getDataFieldPosition());
        HashMap<String, ElementProperties> initialClassifications = new HashMap<String, ElementProperties>();
        ElementProperties classificationProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.SCHEMA_TYPE_NAME.name, "PrimitiveSchemaType");
        classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, OpenMetadataProperty.DATA_TYPE.name, dataField.getDataFieldType());
        initialClassifications.put("TypeEmbeddedAttribute", classificationProperties);
        return openMetadataStore.createMetadataElementInStore("TabularColumn", ElementStatus.ACTIVE, initialClassifications, assetUniverse.getGUID(), false, null, null, elementProperties, schemaTypeGUID, "AttributeForSchema", null, true);
    }

    private void updateSchemaAttribute(SurveyOpenMetadataStore openMetadataStore, String schemaAttributeGUID, DataField dataField) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.DISPLAY_NAME.name, dataField.getDataFieldName());
        elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.POSITION.name, dataField.getDataFieldPosition());
        openMetadataStore.updateMetadataElementInStore(schemaAttributeGUID, false, elementProperties);
        ElementProperties classificationProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.SCHEMA_TYPE_NAME.name, "PrimitiveSchemaType");
        classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, OpenMetadataProperty.DATA_TYPE.name, dataField.getDataFieldType());
        openMetadataStore.reclassifyMetadataElementInStore(schemaAttributeGUID, "TypeEmbeddedAttribute", false, classificationProperties);
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.connector != null) {
            this.connector.disconnect();
        }
        super.disconnect();
    }

    private static class DataField {
        private String dataFieldName = null;
        private String dataFieldType = null;
        private int dataFieldPosition = 0;
        private final ResourceProfileAnnotation resourceProfileAnnotation = new ResourceProfileAnnotation();
        private String matchingSchemaAttributeGUID = null;

        private DataField() {
        }

        public String getDataFieldName() {
            return this.dataFieldName;
        }

        public void setDataFieldName(String dataFieldName) {
            this.dataFieldName = dataFieldName;
        }

        public String getDataFieldType() {
            return this.dataFieldType;
        }

        public void setDataFieldType(String dataFieldType) {
            this.dataFieldType = dataFieldType;
        }

        public int getDataFieldPosition() {
            return this.dataFieldPosition;
        }

        public void setDataFieldPosition(int dataFieldPosition) {
            this.dataFieldPosition = dataFieldPosition;
        }

        public String getMatchingSchemaAttributeGUID() {
            return this.matchingSchemaAttributeGUID;
        }

        public void setMatchingSchemaAttributeGUID(String matchingSchemaAttributeGUID) {
            this.matchingSchemaAttributeGUID = matchingSchemaAttributeGUID;
        }

        public ResourceProfileAnnotation getDataProfileAnnotation() {
            return this.resourceProfileAnnotation;
        }
    }
}

