/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfile;

import java.io.File;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStore;
import org.odpi.openmetadata.adapters.connectors.surveyaction.extractors.FileStatsExtractor;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;

public class FileSurveyService
extends SurveyActionServiceConnector {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            this.connector = this.performCheckAssetAnalysisStep(BasicFileStore.class, OpenMetadataType.DATA_FILE.typeName);
            BasicFileStore assetConnector = (BasicFileStore)this.connector;
            File file = assetConnector.getFile();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
            FileStatsExtractor fileStatsExtractor = new FileStatsExtractor(file, this.surveyContext.getFileClassifier(), this);
            Annotation measurementAnnotation = fileStatsExtractor.getAnnotation();
            if (measurementAnnotation != null) {
                annotationStore.addAnnotation(measurementAnnotation, this.surveyContext.getAssetGUID());
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.connector != null) {
            this.connector.disconnect();
        }
        super.disconnect();
    }
}

