/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfolder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFolderConnector;
import org.odpi.openmetadata.adapters.connectors.surveyaction.controls.FolderRequestParameter;
import org.odpi.openmetadata.adapters.connectors.surveyaction.extractors.FileStatsExtractor;
import org.odpi.openmetadata.adapters.connectors.surveyaction.ffdc.SurveyServiceAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassification;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassifier;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyFolderAnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.FileDirectoryMeasurement;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.FileDirectoryMetric;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.RequestForActionAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileLogAnnotation;

public class FolderSurveyService
extends SurveyActionServiceConnector {
    private void updateValueCount(Map<String, Integer> existingValueCount, String newFieldValue) {
        Integer countForValue = existingValueCount.get(newFieldValue);
        if (countForValue == null) {
            existingValueCount.put(newFieldValue, 1);
        } else {
            existingValueCount.put(newFieldValue, countForValue + 1);
        }
    }

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            AnnotationStore annotationStore = this.getSurveyContext().getAnnotationStore();
            SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
            AssetUniverse assetUniverse = assetStore.getAssetProperties();
            this.performCheckAssetAnalysisStep(OpenMetadataType.FILE_FOLDER.typeName);
            boolean deepFolderAnalysis = false;
            boolean deepFileAnalysis = false;
            String analysisLevel = "TOP_LEVEL_ONLY";
            if (this.surveyContext.getRequestParameters() != null && this.surveyContext.getRequestParameters().get(FolderRequestParameter.ANALYSIS_LEVEL.getName()) != null) {
                analysisLevel = (String)this.surveyContext.getRequestParameters().get(FolderRequestParameter.ANALYSIS_LEVEL.getName());
                if ("ALL_FOLDERS".equals(analysisLevel)) {
                    deepFolderAnalysis = true;
                } else if ("TOP_LEVEL_AND_FILES".equals(analysisLevel)) {
                    deepFileAnalysis = true;
                } else if ("ALL_FOLDERS_AND_FILES".equals(analysisLevel)) {
                    deepFolderAnalysis = true;
                    deepFileAnalysis = true;
                } else {
                    analysisLevel = "TOP_LEVEL_ONLY";
                }
            }
            this.connector = assetStore.getConnectorToAsset();
            BasicFolderConnector assetConnector = (BasicFolderConnector)this.connector;
            File rootFolder = assetConnector.getFile();
            if (!rootFolder.isDirectory()) {
                this.throwWrongTypeOfResource(assetUniverse.getGUID(), assetUniverse.getType().getTypeName(), rootFolder.getName(), "file", "directory (folder)", this.surveyActionServiceName, "start");
            }
            if (!rootFolder.exists()) {
                this.throwMissingResource(assetUniverse.getGUID(), assetUniverse.getType().getTypeName(), rootFolder.getName(), "start");
            }
            this.auditLog.logMessage("start", SurveyServiceAuditCode.SURVEYING_FOLDER.getMessageDefinition(this.surveyActionServiceName, rootFolder.getCanonicalPath(), analysisLevel));
            annotationStore.setAnalysisStep(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
            LogFileProgress logFileProgress = new LogFileProgress(this.auditLog, this.surveyActionServiceName);
            FolderProfile folderProfile = this.profileFolder(rootFolder, logFileProgress, deepFolderAnalysis, deepFileAnalysis);
            List<Annotation> annotations = folderProfile.getAnnotations(annotationStore.getSurveyReportGUID());
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    if (!AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName().equals(annotation.getAnalysisStep())) continue;
                    annotationStore.addAnnotation(annotation, null);
                }
                annotationStore.setAnalysisStep(AnalysisStep.PRODUCE_ACTIONS.getName());
                for (Annotation annotation : annotations) {
                    if (!AnalysisStep.PRODUCE_ACTIONS.getName().equals(annotation.getAnalysisStep())) continue;
                    annotationStore.addAnnotation(annotation, null);
                }
                annotationStore.setAnalysisStep(AnalysisStep.PRODUCE_INVENTORY.getName());
                for (Annotation annotation : annotations) {
                    if (!AnalysisStep.PRODUCE_INVENTORY.getName().equals(annotation.getAnalysisStep())) continue;
                    annotationStore.addAnnotation(annotation, null);
                }
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }

    private FolderProfile profileFolder(File fileFolder, LogFileProgress logFileProgress, boolean deepFolderAnalysis, boolean deepFileAnalysis) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        FolderProfile folderProfile = new FolderProfile(this.auditLog, fileFolder.getPath(), this, this.surveyActionServiceName, this.surveyContext.getAssetStore());
        if (fileFolder.listFiles() != null) {
            for (File nestedFile : Objects.requireNonNull(fileFolder.listFiles())) {
                if (nestedFile.isDirectory()) {
                    ++folderProfile.folderCount;
                    logFileProgress.logFilesProcessed();
                    if (FileUtils.isSymlink((File)nestedFile)) continue;
                    FolderProfile nestedFolderProfile = this.profileFolder(nestedFile, logFileProgress, deepFolderAnalysis, deepFileAnalysis);
                    if (deepFolderAnalysis) {
                        folderProfile.saveAnnotation(nestedFolderProfile.getFolderAnnotation());
                    }
                    folderProfile.addNestedProfile(nestedFolderProfile);
                    continue;
                }
                if (!nestedFile.isFile()) continue;
                try {
                    FileClassifier fileClassifier = this.surveyContext.getFileClassifier();
                    FileClassification fileClassification = fileClassifier.classifyFile(nestedFile);
                    if (deepFileAnalysis) {
                        FileStatsExtractor fileStatsExtractor = new FileStatsExtractor(nestedFile, fileClassifier, this);
                        folderProfile.saveAnnotation(fileStatsExtractor.getAnnotation());
                    }
                    ++folderProfile.fileCount;
                    logFileProgress.logFilesProcessed();
                    folderProfile.totalSize += (double)fileClassification.getFileSize();
                    if (fileClassification.getFileType() == null || fileClassification.getAssetTypeName() == null || fileClassification.getDeployedImplementationType() == null) {
                        folderProfile.missingReferenceData.add(fileClassification);
                    }
                    if (folderProfile.lastFileCreationTime == null || fileClassification.getCreationTime() != null && folderProfile.lastFileCreationTime.before(fileClassification.getCreationTime())) {
                        folderProfile.lastFileCreationTime = fileClassification.getCreationTime();
                    }
                    if (folderProfile.lastFileModificationTime == null || fileClassification.getLastModifiedTime() != null && folderProfile.lastFileModificationTime.before(fileClassification.getLastModifiedTime())) {
                        folderProfile.lastFileModificationTime = fileClassification.getLastModifiedTime();
                    }
                    if (folderProfile.lastFileAccessTime == null || fileClassification.getLastAccessedTime() != null && folderProfile.lastFileAccessTime.before(fileClassification.getLastAccessedTime())) {
                        folderProfile.lastFileAccessTime = fileClassification.getLastAccessedTime();
                    }
                    this.updateValueCount(folderProfile.fileExtensionCounts, fileClassification.getFileExtension());
                    this.updateValueCount(folderProfile.fileNameCounts, fileClassification.getFileName());
                    this.updateValueCount(folderProfile.fileTypeCounts, fileClassification.getFileType());
                    this.updateValueCount(folderProfile.deployedImplementationTypeCounts, fileClassification.getDeployedImplementationType());
                    this.updateValueCount(folderProfile.assetTypeCounts, fileClassification.getAssetTypeName());
                    if (fileClassification.isCanRead()) {
                        ++folderProfile.canReadCount;
                    }
                    if (fileClassification.isCanWrite()) {
                        ++folderProfile.canWriteCount;
                    }
                    if (fileClassification.isCanExecute()) {
                        ++folderProfile.canExecuteCount;
                    }
                    if (fileClassification.isSymLink()) {
                        ++folderProfile.isSymLink;
                    }
                    if (!fileClassification.isHidden()) continue;
                    ++folderProfile.isHidden;
                }
                catch (IOException invalidFile) {
                    String methodName = "Profile Folder";
                    this.auditLog.logException("Profile Folder", SurveyServiceAuditCode.FILE_IO_ERROR.getMessageDefinition("Profile Folder", nestedFile.getPath(), invalidFile.getMessage()), (Throwable)invalidFile);
                    folderProfile.saveInaccessibleFile(nestedFile.getPath(), invalidFile.getClass().getName(), invalidFile.getMessage());
                }
            }
        }
        return folderProfile;
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.connector != null) {
            this.connector.disconnect();
        }
        super.disconnect();
    }

    static class LogFileProgress {
        private long fileLogPointer = 0L;
        private long fileCount = 0L;
        private final AuditLog auditLog;
        private final String surveyActionServiceName;

        public LogFileProgress(AuditLog auditLog, String surveyActionServiceName) {
            this.auditLog = auditLog;
            this.surveyActionServiceName = surveyActionServiceName;
        }

        public void logFilesProcessed() {
            String methodName = "logFilesProcessed";
            long fileLogLimit = 5000L;
            ++this.fileCount;
            ++this.fileLogPointer;
            if (this.fileLogPointer == 5000L) {
                this.fileLogPointer = 0L;
                this.auditLog.logMessage("logFilesProcessed", SurveyServiceAuditCode.PROGRESS_REPORT.getMessageDefinition(this.surveyActionServiceName, Long.toString(this.fileCount)));
            }
        }
    }

    private class FolderProfile {
        private final AuditLog auditLog;
        private final String pathName;
        private final SurveyActionServiceConnector surveyActionServiceConnector;
        private final String surveyActionServiceName;
        private final SurveyAssetStore surveyAssetStore;
        private long fileCount = 0L;
        private long folderCount = 0L;
        private long canReadCount = 0L;
        private long canWriteCount = 0L;
        private long canExecuteCount = 0L;
        private long isSymLink = 0L;
        private long isHidden = 0L;
        private double totalSize = 0.0;
        private Date lastFileCreationTime = null;
        private Date lastFileModificationTime = null;
        private Date lastFileAccessTime = null;
        private final Map<String, Integer> fileExtensionCounts = new HashMap<String, Integer>();
        private final Map<String, Integer> fileTypeCounts = new HashMap<String, Integer>();
        private final Map<String, Integer> fileNameCounts = new HashMap<String, Integer>();
        private final Map<String, Integer> assetTypeCounts = new HashMap<String, Integer>();
        private final Map<String, Integer> deployedImplementationTypeCounts = new HashMap<String, Integer>();
        private final List<FileClassification> missingReferenceData = new ArrayList<FileClassification>();
        private final List<InaccessibleFile> inaccessibleFiles = new ArrayList<InaccessibleFile>();
        private final List<Annotation> savedAnnotations = new ArrayList<Annotation>();

        public FolderProfile(AuditLog auditLog, String pathName, SurveyActionServiceConnector surveyActionServiceConnector, String surveyActionServiceName, SurveyAssetStore surveyAssetStore) {
            this.auditLog = auditLog;
            this.pathName = pathName;
            this.surveyActionServiceConnector = surveyActionServiceConnector;
            this.surveyActionServiceName = surveyActionServiceName;
            this.surveyAssetStore = surveyAssetStore;
        }

        public void saveInaccessibleFile(String fileName, String exceptionClassName, String exceptionMessage) {
            InaccessibleFile inaccessibleFile = new InaccessibleFile();
            inaccessibleFile.fileName = fileName;
            inaccessibleFile.exceptionClassName = exceptionClassName;
            inaccessibleFile.exceptionMessage = exceptionMessage;
            this.inaccessibleFiles.add(inaccessibleFile);
        }

        public void saveAnnotation(Annotation annotation) {
            this.savedAnnotations.add(annotation);
        }

        public Annotation getFolderAnnotation() throws PropertyServerException {
            ResourceMeasureAnnotation resourceMeasureAnnotation = new ResourceMeasureAnnotation();
            FolderSurveyService.this.setUpAnnotation((Annotation)resourceMeasureAnnotation, (AnnotationType)SurveyFolderAnnotationType.MEASUREMENTS);
            HashMap<String, String> fileCountProperties = new HashMap<String, String>();
            fileCountProperties.put(FileDirectoryMetric.FILE_COUNT.getDisplayName(), Long.toString(this.fileCount));
            fileCountProperties.put(FileDirectoryMetric.TOTAL_FILE_SIZE.getDisplayName(), Double.toString(this.totalSize));
            fileCountProperties.put(FileDirectoryMetric.SUB_DIRECTORY_COUNT.getDisplayName(), Long.toString(this.folderCount));
            fileCountProperties.put(FileDirectoryMetric.READABLE_FILE_COUNT.getDisplayName(), Long.toString(this.canReadCount));
            fileCountProperties.put(FileDirectoryMetric.WRITEABLE_FILE_COUNT.getDisplayName(), Long.toString(this.canWriteCount));
            fileCountProperties.put(FileDirectoryMetric.EXECUTABLE_FILE_COUNT.getDisplayName(), Long.toString(this.canExecuteCount));
            fileCountProperties.put(FileDirectoryMetric.SYM_LINK_COUNT.getDisplayName(), Long.toString(this.isSymLink));
            fileCountProperties.put(FileDirectoryMetric.HIDDEN_FILE_COUNT.getDisplayName(), Long.toString(this.isHidden));
            fileCountProperties.put(FileDirectoryMetric.FILE_NAME_COUNT.getDisplayName(), Integer.toString(this.fileNameCounts.size()));
            fileCountProperties.put(FileDirectoryMetric.FILE_EXTENSION_COUNT.getDisplayName(), Integer.toString(this.fileExtensionCounts.size()));
            fileCountProperties.put(FileDirectoryMetric.FILE_TYPE_COUNT.getDisplayName(), Integer.toString(this.fileTypeCounts.size()));
            fileCountProperties.put(FileDirectoryMetric.ASSET_TYPE_COUNT.getDisplayName(), Integer.toString(this.assetTypeCounts.size()));
            fileCountProperties.put(FileDirectoryMetric.DEPLOYED_IMPL_TYPE_COUNT.getDisplayName(), Integer.toString(this.deployedImplementationTypeCounts.size()));
            fileCountProperties.put(FileDirectoryMetric.UNCLASSIFIED_FILE_COUNT.getDisplayName(), Integer.toString(this.missingReferenceData.size()));
            fileCountProperties.put(FileDirectoryMetric.INACCESSIBLE_FILE_COUNT.getDisplayName(), Integer.toString(this.inaccessibleFiles.size()));
            if (this.lastFileCreationTime != null) {
                fileCountProperties.put(FileDirectoryMetric.LAST_FILE_CREATION_TIME.getDisplayName(), this.lastFileCreationTime.toString());
            }
            if (this.lastFileModificationTime != null) {
                fileCountProperties.put(FileDirectoryMetric.LAST_FILE_MODIFIED_TIME.getDisplayName(), this.lastFileModificationTime.toString());
            }
            if (this.lastFileAccessTime != null) {
                fileCountProperties.put(FileDirectoryMetric.LAST_FILE_ACCESSED_TIME.getDisplayName(), this.lastFileAccessTime.toString());
            }
            resourceMeasureAnnotation.setResourceProperties(fileCountProperties);
            FileDirectoryMeasurement fileDirectoryMeasurement = new FileDirectoryMeasurement();
            fileDirectoryMeasurement.setDirectoryName(this.pathName);
            fileDirectoryMeasurement.setFileCount(this.fileCount);
            fileDirectoryMeasurement.setTotalFileSize(this.totalSize);
            fileDirectoryMeasurement.setSubDirectoryCount(this.folderCount);
            fileDirectoryMeasurement.setReadableFileCount(this.canReadCount);
            fileDirectoryMeasurement.setWriteableFileCount(this.canWriteCount);
            fileDirectoryMeasurement.setExecutableFileCount(this.canExecuteCount);
            fileDirectoryMeasurement.setSymLinkFileCount(this.isSymLink);
            fileDirectoryMeasurement.setHiddenFileCount(this.isHidden);
            fileDirectoryMeasurement.setFileNameCount((long)this.fileNameCounts.size());
            fileDirectoryMeasurement.setFileExtensionCount((long)this.fileExtensionCounts.size());
            fileDirectoryMeasurement.setFileTypeCount((long)this.fileTypeCounts.size());
            fileDirectoryMeasurement.setAssetTypeCount((long)this.assetTypeCounts.size());
            fileDirectoryMeasurement.setDeployedImplementationTypeCount((long)this.deployedImplementationTypeCounts.size());
            fileDirectoryMeasurement.setUnclassifiedFileCount((long)this.missingReferenceData.size());
            fileDirectoryMeasurement.setInaccessibleFileCount((long)this.inaccessibleFiles.size());
            fileDirectoryMeasurement.setLastFileCreationTime(this.lastFileCreationTime);
            fileDirectoryMeasurement.setLastFileModificationTime(this.lastFileModificationTime);
            fileDirectoryMeasurement.setLastFileAccessedTime(this.lastFileAccessTime);
            resourceMeasureAnnotation.setJsonProperties(this.surveyActionServiceConnector.getJSONProperties((Object)fileDirectoryMeasurement));
            return resourceMeasureAnnotation;
        }

        public void addNestedProfile(FolderProfile nestedFolderProfile) {
            this.fileCount += nestedFolderProfile.fileCount;
            this.folderCount += nestedFolderProfile.folderCount;
            this.canReadCount += nestedFolderProfile.canReadCount;
            this.canWriteCount += nestedFolderProfile.canWriteCount;
            this.canExecuteCount += nestedFolderProfile.canExecuteCount;
            this.isSymLink += nestedFolderProfile.isSymLink;
            this.isHidden += nestedFolderProfile.isHidden;
            this.totalSize += nestedFolderProfile.totalSize;
            if (this.lastFileCreationTime == null || nestedFolderProfile.lastFileCreationTime != null && this.lastFileCreationTime.before(nestedFolderProfile.lastFileCreationTime)) {
                this.lastFileCreationTime = nestedFolderProfile.lastFileCreationTime;
            }
            if (this.lastFileModificationTime == null || nestedFolderProfile.lastFileModificationTime != null && this.lastFileModificationTime.before(nestedFolderProfile.lastFileModificationTime)) {
                this.lastFileModificationTime = nestedFolderProfile.lastFileModificationTime;
            }
            if (this.lastFileAccessTime == null || nestedFolderProfile.lastFileAccessTime != null && this.lastFileAccessTime.before(nestedFolderProfile.lastFileAccessTime)) {
                this.lastFileAccessTime = nestedFolderProfile.lastFileAccessTime;
            }
            this.fileExtensionCounts.putAll(nestedFolderProfile.fileExtensionCounts);
            this.fileTypeCounts.putAll(nestedFolderProfile.fileTypeCounts);
            this.fileNameCounts.putAll(nestedFolderProfile.fileNameCounts);
            this.assetTypeCounts.putAll(nestedFolderProfile.assetTypeCounts);
            this.deployedImplementationTypeCounts.putAll(nestedFolderProfile.deployedImplementationTypeCounts);
            this.missingReferenceData.addAll(nestedFolderProfile.missingReferenceData);
            this.inaccessibleFiles.addAll(nestedFolderProfile.inaccessibleFiles);
            this.savedAnnotations.addAll(nestedFolderProfile.savedAnnotations);
        }

        public List<Annotation> getAnnotations(String surveyReportGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, IOException, ConnectorCheckedException {
            ArrayList<String> requestForActionTargetGUIDs;
            RequestForActionAnnotation requestForActionAnnotation;
            ResourceProfileAnnotation dataProfile = new ResourceProfileAnnotation();
            FolderSurveyService.this.setUpAnnotation((Annotation)dataProfile, (AnnotationType)SurveyFolderAnnotationType.PROFILE_FILE_EXTENSIONS);
            dataProfile.setValueCount(this.fileExtensionCounts);
            this.savedAnnotations.add((Annotation)dataProfile);
            ResourceProfileLogAnnotation dataProfileLog = FolderSurveyService.this.writeNameCountInventory((AnnotationType)SurveyFolderAnnotationType.PROFILE_FILE_NAMES, "fileNameCounts", this.fileNameCounts, surveyReportGUID);
            this.savedAnnotations.add((Annotation)dataProfileLog);
            if (!this.missingReferenceData.isEmpty()) {
                requestForActionAnnotation = new RequestForActionAnnotation();
                FolderSurveyService.this.setUpAnnotation((Annotation)requestForActionAnnotation, (AnnotationType)SurveyFolderAnnotationType.MISSING_REF_DATA);
                requestForActionTargetGUIDs = new ArrayList<String>();
                requestForActionTargetGUIDs.add(this.setUpMissingRefDateExternalLogFile(surveyReportGUID, this.missingReferenceData));
                requestForActionAnnotation.setActionTargetGUIDs(requestForActionTargetGUIDs);
                this.savedAnnotations.add((Annotation)requestForActionAnnotation);
            }
            if (!this.inaccessibleFiles.isEmpty()) {
                requestForActionAnnotation = new RequestForActionAnnotation();
                FolderSurveyService.this.setUpAnnotation((Annotation)requestForActionAnnotation, (AnnotationType)SurveyFolderAnnotationType.INACCESSIBLE_FILES);
                requestForActionTargetGUIDs = new ArrayList();
                requestForActionTargetGUIDs.add(this.setUpInaccessibleFilesExternalLogFile(surveyReportGUID, this.inaccessibleFiles));
                requestForActionAnnotation.setActionTargetGUIDs(requestForActionTargetGUIDs);
                this.savedAnnotations.add((Annotation)requestForActionAnnotation);
            }
            dataProfile = new ResourceProfileAnnotation();
            FolderSurveyService.this.setUpAnnotation((Annotation)dataProfile, (AnnotationType)SurveyFolderAnnotationType.PROFILE_FILE_TYPES);
            dataProfile.setValueCount(this.fileTypeCounts);
            this.savedAnnotations.add((Annotation)dataProfile);
            dataProfile = new ResourceProfileAnnotation();
            FolderSurveyService.this.setUpAnnotation((Annotation)dataProfile, (AnnotationType)SurveyFolderAnnotationType.PROFILE_ASSET_TYPES);
            dataProfile.setValueCount(this.assetTypeCounts);
            this.savedAnnotations.add((Annotation)dataProfile);
            dataProfile = new ResourceProfileAnnotation();
            FolderSurveyService.this.setUpAnnotation((Annotation)dataProfile, (AnnotationType)SurveyFolderAnnotationType.PROFILE_DEP_IMPL_TYPES);
            dataProfile.setValueCount(this.deployedImplementationTypeCounts);
            this.savedAnnotations.add((Annotation)dataProfile);
            this.savedAnnotations.add(this.getFolderAnnotation());
            return this.savedAnnotations;
        }

        private String setUpMissingRefDateExternalLogFile(String surveyReportGUID, List<FileClassification> missingReferenceData) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
            String methodName = "setUpExternalLogFile";
            String logFileName = "surveys/report-" + surveyReportGUID + "-missingReferenceData.csv";
            File logFile = new File(logFileName);
            boolean newLogFile = false;
            try {
                FileUtils.sizeOf((File)logFile);
            }
            catch (IllegalArgumentException notFound) {
                newLogFile = true;
                FileUtils.writeStringToFile((File)logFile, (String)"FileName,FileExtension,PathName,FileType,AssetTypeName,DeployedImplementationType,Encoding\n", (String)null, (boolean)false);
            }
            String assetGUID = this.surveyAssetStore.addCSVFileToCatalog("Missing reference data for survey report " + surveyReportGUID, "Shows the files that could not be correctly classified from the reference data.", logFile.getCanonicalPath(), null, Character.valueOf(','), Character.valueOf('\"'));
            if (newLogFile) {
                this.auditLog.logMessage("setUpExternalLogFile", SurveyServiceAuditCode.CREATING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName, assetGUID));
            } else {
                this.auditLog.logMessage("setUpExternalLogFile", SurveyServiceAuditCode.REUSING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName));
            }
            for (FileClassification fileClassification : missingReferenceData) {
                String stringBuilder = fileClassification.getFileName() + "," + fileClassification.getFileExtension() + "," + fileClassification.getPathName() + "," + fileClassification.getFileType() + "," + fileClassification.getAssetTypeName() + "," + fileClassification.getDeployedImplementationType() + "," + fileClassification.getEncoding() + "\n";
                FileUtils.writeStringToFile((File)logFile, (String)stringBuilder, (String)null, (boolean)true);
            }
            return assetGUID;
        }

        private String setUpInaccessibleFilesExternalLogFile(String surveyReportGUID, List<InaccessibleFile> inaccessibleFiles) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
            String methodName = "setUpInaccessibleFilesExternalLogFile";
            String logFileName = "surveys/report-" + surveyReportGUID + "-inaccessibleFiles.csv";
            File logFile = new File(logFileName);
            boolean newLogFile = false;
            try {
                FileUtils.sizeOf((File)logFile);
            }
            catch (IllegalArgumentException notFound) {
                newLogFile = true;
                FileUtils.writeStringToFile((File)logFile, (String)"FileName,Exception,Message\n", (String)null, (boolean)false);
            }
            String assetGUID = this.surveyAssetStore.addCSVFileToCatalog("Inaccessible files detected by " + surveyReportGUID, "Shows the files that could not be accessed.", logFile.getCanonicalPath(), null, Character.valueOf(','), Character.valueOf('\"'));
            if (newLogFile) {
                this.auditLog.logMessage("setUpInaccessibleFilesExternalLogFile", SurveyServiceAuditCode.CREATING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName, assetGUID));
            } else {
                this.auditLog.logMessage("setUpInaccessibleFilesExternalLogFile", SurveyServiceAuditCode.REUSING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName));
            }
            for (InaccessibleFile inaccessibleFile : inaccessibleFiles) {
                String stringBuilder = inaccessibleFile.fileName + "," + inaccessibleFile.exceptionClassName + "," + inaccessibleFile.exceptionMessage + "\n";
                FileUtils.writeStringToFile((File)logFile, (String)stringBuilder, (String)null, (boolean)true);
            }
            return assetGUID;
        }
    }

    static class InaccessibleFile {
        String fileName;
        String exceptionClassName;
        String exceptionMessage;

        InaccessibleFile() {
        }
    }
}

