/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.Date;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitorIntegrationConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFolderMonitorIntegrationConnector
extends BasicFilesMonitorIntegrationConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(DataFolderMonitorIntegrationConnector.class);
    private File dataFolderFile = null;

    @Override
    FileAlterationListenerAdaptor getListener() {
        return new FileCataloguingListener(this);
    }

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.dataFolderFile = super.getRootDirectoryFile();
        this.updateDataFolder(this.dataFolderFile, new Date(this.dataFolderFile.lastModified()), "start");
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        this.dataFolderFile = super.getRootDirectoryFile();
        this.updateDataFolder(null, new Date(this.dataFolderFile.lastModified()), "refresh");
    }

    private void updateDataFolder(File fileChanged, Date modifiedTime, String methodName) {
        block7: {
            String directoryName = null;
            String fileFolderQualifiedName = null;
            try {
                File folderFile = super.getRootDirectoryFile();
                FileFolderElement folderElement = super.getFolderElement();
                if (folderElement == null || folderFile == null) {
                    return;
                }
                directoryName = folderFile.getName();
                fileFolderQualifiedName = folderElement.getFileFolderProperties().getQualifiedName();
                Date lastRecordedChange = folderElement.getFileFolderProperties().getModifiedTime();
                if (lastRecordedChange == null || lastRecordedChange.before(new Date(folderFile.lastModified()))) {
                    FileFolderProperties properties = new FileFolderProperties();
                    properties.setModifiedTime(modifiedTime);
                    this.getContext().updateDataFolderInCatalog(folderElement.getElementHeader().getGUID(), true, properties);
                    if (this.auditLog != null) {
                        if (fileChanged == null) {
                            this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FOLDER_UPDATED.getMessageDefinition(this.connectorName, fileFolderQualifiedName, modifiedTime.toString()));
                        } else {
                            this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FOLDER_UPDATED_FOR_FILE.getMessageDefinition(this.connectorName, fileFolderQualifiedName, modifiedTime.toString(), fileChanged.getAbsolutePath()));
                        }
                    }
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block7;
                this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_FOLDER_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, fileFolderQualifiedName, directoryName, error.getMessage()), (Throwable)error);
            }
        }
    }

    class FileCataloguingListener
    extends FileAlterationListenerAdaptor {
        private DataFolderMonitorIntegrationConnector connector;

        FileCataloguingListener(DataFolderMonitorIntegrationConnector connector) {
            this.connector = connector;
        }

        public void onFileCreate(File file) {
            String methodName = "onFileCreate";
            log.debug("File created: " + file.getName());
            this.connector.updateDataFolder(file, new Date(), "onFileCreate");
        }

        public void onFileDelete(File file) {
            String methodName = "onFileDelete";
            log.debug("File deleted: " + file.getName());
            this.connector.updateDataFolder(file, new Date(), "onFileDelete");
        }

        public void onFileChange(File file) {
            String methodName = "onFileChange";
            log.debug("File changed: " + file.getName());
            this.connector.updateDataFolder(file, new Date(), "onFileChange");
        }

        public void onDirectoryCreate(File directory) {
            String methodName = "onDirectoryCreate";
            log.debug("Folder created: " + directory.getName());
            DataFolderMonitorIntegrationConnector.this.initiateDirectoryMonitoring(directory, "onDirectoryCreate");
        }

        public void onDirectoryDelete(File directory) {
            String methodName = "onDirectoryDelete";
            log.debug("Folder deleted: " + directory.getName());
            DataFolderMonitorIntegrationConnector.this.stopDirectoryMonitoring(directory.getName(), "onDirectoryDelete");
        }
    }
}

