/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.exception.ConfigException;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.exception.FileException;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.integrationservices.files.connector.FilesIntegratorConnector;

public abstract class BasicFilesMonitorIntegrationConnectorBase
extends FilesIntegratorConnector {
    String templateQualifiedName = null;
    boolean allowCatalogDelete = false;
    private String fileDirectoryName = null;
    private FileFolderElement dataFolderElement = null;
    private File dataFolderFile = null;
    private Map<String, FileAlterationMonitor> monitors = new HashMap<String, FileAlterationMonitor>();
    private static int POLL_INTERVAL = 500;

    public void start() throws ConnectorCheckedException {
        Map configurationProperties;
        super.start();
        String methodName = "start";
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.fileDirectoryName = endpoint.getAddress();
        }
        if ((configurationProperties = this.connectionProperties.getConfigurationProperties()) != null) {
            if (configurationProperties.containsKey("allowCatalogDelete")) {
                this.allowCatalogDelete = true;
            }
            this.templateQualifiedName = configurationProperties.get("templateQualifiedName").toString();
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("start", BasicFilesIntegrationConnectorsAuditCode.CONNECTOR_CONFIGURATION.getMessageDefinition(this.connectorName, this.fileDirectoryName, Boolean.toString(this.allowCatalogDelete), this.templateQualifiedName));
        }
        this.initiateDirectoryMonitoring(this.getRootDirectoryFile(), "start");
    }

    synchronized File getRootDirectoryFile() throws ConfigException {
        if (this.dataFolderFile != null) {
            return this.dataFolderFile;
        }
        try {
            File fileStore;
            if (this.fileDirectoryName == null) {
                this.throwConfigException(BasicFilesIntegrationConnectorsErrorCode.FILES_LOCATION_NOT_SPECIFIED, null, null);
            }
            if (!(fileStore = new File(this.fileDirectoryName)).exists()) {
                this.throwConfigException(BasicFilesIntegrationConnectorsErrorCode.FILES_LOCATION_NOT_FOUND, this.fileDirectoryName, null);
            }
            if (!fileStore.isDirectory()) {
                this.throwConfigException(BasicFilesIntegrationConnectorsErrorCode.FILES_LOCATION_NOT_DIRECTORY, this.fileDirectoryName, null);
            }
            if (!fileStore.canRead()) {
                this.throwConfigException(BasicFilesIntegrationConnectorsErrorCode.FILES_LOCATION_NOT_READABLE, this.fileDirectoryName, null);
            }
            this.dataFolderFile = fileStore;
            return fileStore;
        }
        catch (ConfigException error) {
            throw error;
        }
        catch (SecurityException error) {
            this.throwConfigException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_SECURITY_EXCEPTION, this.fileDirectoryName, error);
        }
        catch (Throwable error) {
            this.throwConfigException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_IO_EXCEPTION, this.fileDirectoryName, error);
        }
        return null;
    }

    synchronized FileFolderElement getFolderElement() throws ConnectorCheckedException {
        String methodName = "getFolderElement";
        if (this.dataFolderElement != null) {
            return this.dataFolderElement;
        }
        File dataFolderFile = this.getRootDirectoryFile();
        try {
            FileFolderElement folderElement = this.getContext().getFolderByPathName(dataFolderFile.getAbsolutePath());
            if (folderElement == null) {
                return null;
            }
            if (folderElement.getElementHeader() == null || folderElement.getElementHeader().getGUID() == null || folderElement.getFileFolderProperties() == null) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getFolderElement", BasicFilesIntegrationConnectorsAuditCode.BAD_FOLDER_ELEMENT.getMessageDefinition(this.connectorName, this.fileDirectoryName, folderElement.toString()));
                }
            } else {
                this.dataFolderElement = folderElement;
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("getFolderElement", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_RETRIEVING_FOLDER.getMessageDefinition(error.getClass().getName(), this.connectorName, "getFolderElement", this.fileDirectoryName, dataFolderFile.getAbsolutePath(), error.getMessage()));
            }
            throw new FileException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXC_RETRIEVING_FOLDER.getMessageDefinition(error.getClass().getName(), this.connectorName, "getFolderElement", this.fileDirectoryName, dataFolderFile.getAbsolutePath(), error.getMessage()), error.getClass().getName(), "getFolderElement", error, this.fileDirectoryName);
        }
        return this.dataFolderElement;
    }

    private void throwConfigException(BasicFilesIntegrationConnectorsErrorCode errorCode, String fileLocationName, Throwable caughtException) throws ConfigException {
        String methodName = "getRootDirectoryFile";
        ExceptionMessageDefinition messageDefinition = fileLocationName == null ? errorCode.getMessageDefinition(this.connectionBean.toString()) : errorCode.getMessageDefinition(fileLocationName);
        ConfigException error = caughtException == null ? new ConfigException(messageDefinition, ((Object)((Object)this)).getClass().getName(), "getRootDirectoryFile", fileLocationName) : new ConfigException(messageDefinition, ((Object)((Object)this)).getClass().getName(), "getRootDirectoryFile", caughtException, fileLocationName);
        if (this.auditLog != null) {
            this.auditLog.logException("getRootDirectoryFile", BasicFilesIntegrationConnectorsAuditCode.BAD_CONFIGURATION.getMessageDefinition(this.connectorName, ConfigException.class.getName(), this.fileDirectoryName, "getRootDirectoryFile", error.getMessage()), (Throwable)((Object)error));
        }
        throw error;
    }

    synchronized void initiateDirectoryMonitoring(File directory, String methodName) {
        block3: {
            FileAlterationObserver observer = new FileAlterationObserver(this.fileDirectoryName);
            FileAlterationMonitor monitor = new FileAlterationMonitor((long)POLL_INTERVAL);
            FileAlterationListenerAdaptor listener = this.getListener();
            observer.addListener((FileAlterationListener)listener);
            monitor.addObserver(observer);
            this.monitors.put(directory.getName(), monitor);
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DIRECTORY_MONITORING_STARTING.getMessageDefinition(this.connectorName, directory.getAbsolutePath()));
            }
            try {
                monitor.start();
            }
            catch (Exception error) {
                if (this.auditLog == null) break block3;
                this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_MONITOR_START.getMessageDefinition(error.getClass().getName(), this.connectorName, directory.getAbsolutePath(), error.getMessage()), (Throwable)error);
            }
        }
    }

    abstract FileAlterationListenerAdaptor getListener();

    synchronized void stopDirectoryMonitoring(String fileName, String methodName) {
        block4: {
            FileAlterationMonitor monitor = this.monitors.get(fileName);
            if (monitor != null) {
                this.monitors.remove(fileName, monitor);
                if (this.auditLog != null) {
                    this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DIRECTORY_MONITORING_STOPPING.getMessageDefinition(this.connectorName, fileName));
                }
                try {
                    monitor.stop((long)(POLL_INTERVAL * 2));
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block4;
                    this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_MONITOR_STOP.getMessageDefinition(error.getClass().getName(), this.connectorName, fileName, error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        for (String fileName : this.monitors.keySet()) {
            this.stopDirectoryMonitoring(fileName, "disconnect");
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", BasicFilesIntegrationConnectorsAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName));
        }
        super.disconnect();
    }
}

