/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ArchiveProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitorIntegrationConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.exception.FileException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFilesMonitorIntegrationConnector
extends BasicFilesMonitorIntegrationConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(DataFilesMonitorIntegrationConnector.class);
    private String templateGUID = null;

    @Override
    FileAlterationListenerAdaptor getListener() {
        return new FileCataloguingListener(this);
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        File directory = this.getRootDirectoryFile();
        if (directory != null) {
            File[] filesArray = directory.listFiles();
            if (filesArray != null) {
                for (File file : filesArray) {
                    if (file == null) continue;
                    this.catalogFile(file, "refresh");
                }
            }
            try {
                FileFolderElement folder = super.getFolderElement();
                if (folder != null) {
                    int startFrom = 0;
                    int pageSize = 100;
                    List cataloguedFiles = this.getContext().getFolderFiles(folder.getElementHeader().getGUID(), startFrom, pageSize);
                    while (cataloguedFiles != null && !cataloguedFiles.isEmpty()) {
                        for (DataFileElement dataFile : cataloguedFiles) {
                            if (dataFile == null) continue;
                            if (dataFile.getElementHeader() != null && dataFile.getElementHeader().getGUID() != null && dataFile.getDataFileProperties() != null && dataFile.getDataFileProperties().getQualifiedName() != null) {
                                File file = new File(dataFile.getDataFileProperties().getQualifiedName());
                                if (file.exists()) continue;
                                this.archiveFileInCatalog(file, dataFile, "refresh");
                                continue;
                            }
                            if (this.auditLog == null) continue;
                            this.auditLog.logMessage("refresh", BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, dataFile.toString()));
                        }
                        cataloguedFiles = this.getContext().getFolderFiles(folder.getElementHeader().getGUID(), startFrom += cataloguedFiles.size(), pageSize);
                    }
                }
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("refresh", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, directory.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
                throw new FileException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, directory.getAbsolutePath(), error.getMessage()), error.getClass().getName(), "refresh", error, directory.getAbsolutePath());
            }
        }
    }

    private void catalogFile(File file, String methodName) {
        block16: {
            if (this.isActive()) {
                try {
                    DataFileElement cataloguedElement = this.getContext().getFileByPathName(file.getAbsolutePath());
                    if (cataloguedElement == null) {
                        if (this.templateQualifiedName == null) {
                            String fileExtension = FilenameUtils.getExtension((String)file.getAbsolutePath());
                            DataFileProperties properties = new DataFileProperties();
                            properties.setTypeName(this.getAssetTypeName(fileExtension));
                            properties.setQualifiedName(file.getAbsolutePath());
                            properties.setDisplayName(file.getName());
                            properties.setModifiedTime(new Date(file.lastModified()));
                            List guids = this.getContext().addDataFileToCatalog(properties, null);
                            if (guids != null && !guids.isEmpty() && this.auditLog != null) {
                                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_CREATED.getMessageDefinition(this.connectorName, properties.getQualifiedName(), (String)guids.get(guids.size() - 1)));
                            }
                        } else {
                            if (this.templateGUID == null) {
                                DataFileElement templateElement = this.getContext().getFileByPathName(this.templateQualifiedName);
                                if (templateElement != null) {
                                    if (templateElement.getElementHeader() != null && templateElement.getElementHeader().getGUID() != null) {
                                        this.templateGUID = templateElement.getElementHeader().getGUID();
                                    } else if (this.auditLog != null) {
                                        this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, templateElement.toString()));
                                    }
                                } else if (this.auditLog != null) {
                                    this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.MISSING_TEMPLATE.getMessageDefinition(this.connectorName, this.templateQualifiedName));
                                }
                            }
                            if (this.templateGUID != null) {
                                TemplateProperties properties = new TemplateProperties();
                                properties.setQualifiedName(file.getAbsolutePath());
                                properties.setDisplayName(file.getName());
                                properties.setNetworkAddress(file.getAbsolutePath());
                                List guids = this.getContext().addDataFileToCatalogFromTemplate(this.templateGUID, properties);
                                if (guids != null && !guids.isEmpty() && this.auditLog != null) {
                                    this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_CREATED_FROM_TEMPLATE.getMessageDefinition(this.connectorName, properties.getQualifiedName(), (String)guids.get(guids.size() - 1), this.templateQualifiedName, this.templateGUID));
                                }
                            }
                        }
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block16;
                    this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, file.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    private String getAssetTypeName(String fileExtension) {
        String assetTypeName = "DataFile";
        if (fileExtension != null) {
            switch (fileExtension) {
                case "csv": {
                    assetTypeName = "CSVFile";
                    break;
                }
                case "json": {
                    assetTypeName = "JSONFile";
                    break;
                }
                case "avro": {
                    assetTypeName = "AvroFileName";
                    break;
                }
                case "pdf": 
                case "doc": 
                case "docx": 
                case "ppt": 
                case "pptx": 
                case "xls": 
                case "xlsx": 
                case "md": {
                    assetTypeName = "Document";
                    break;
                }
                case "jpg": 
                case "jpeg": 
                case "png": 
                case "gif": 
                case "mp3": 
                case "mp4": {
                    assetTypeName = "MediaFile";
                }
            }
        }
        return assetTypeName;
    }

    private void archiveFileInCatalog(File file, DataFileElement retrievedElement, String methodName) {
        block12: {
            if (this.isActive()) {
                try {
                    DataFileElement cataloguedElement = retrievedElement;
                    if (cataloguedElement == null) {
                        cataloguedElement = this.getContext().getFileByPathName(file.getAbsolutePath());
                    }
                    if (cataloguedElement == null) {
                        return;
                    }
                    if (cataloguedElement.getElementHeader() != null && cataloguedElement.getElementHeader().getGUID() != null && cataloguedElement.getDataFileProperties() != null && cataloguedElement.getDataFileProperties().getQualifiedName() != null) {
                        if (this.allowCatalogDelete) {
                            this.getContext().deleteDataFileFromCatalog(cataloguedElement.getElementHeader().getGUID(), cataloguedElement.getDataFileProperties().getQualifiedName());
                            if (this.auditLog != null) {
                                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_DELETED.getMessageDefinition(this.connectorName, cataloguedElement.getDataFileProperties().getQualifiedName(), cataloguedElement.getElementHeader().getGUID()));
                            }
                        } else {
                            ArchiveProperties archiveProperties = new ArchiveProperties();
                            archiveProperties.setArchiveDate(new Date());
                            archiveProperties.setArchiveProcess(this.connectorName);
                            this.getContext().archiveDataFileInCatalog(cataloguedElement.getElementHeader().getGUID(), archiveProperties);
                            if (this.auditLog != null) {
                                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_ARCHIVED.getMessageDefinition(this.connectorName, cataloguedElement.getDataFileProperties().getQualifiedName(), cataloguedElement.getElementHeader().getGUID()));
                            }
                        }
                    } else if (this.auditLog != null) {
                        this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, cataloguedElement.toString()));
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block12;
                    this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, file.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    private void updateFileInCatalog(File file) {
        block9: {
            if (this.isActive()) {
                String methodName = "updateFileInCatalog";
                try {
                    DataFileElement dataFileInCatalog = this.getContext().getFileByPathName(file.getAbsolutePath());
                    if (dataFileInCatalog != null) {
                        if (dataFileInCatalog.getElementHeader() != null && dataFileInCatalog.getElementHeader().getGUID() != null && dataFileInCatalog.getDataFileProperties() != null && dataFileInCatalog.getDataFileProperties().getQualifiedName() != null) {
                            DataFileProperties properties = new DataFileProperties();
                            properties.setModifiedTime(new Date(file.lastModified()));
                            this.getContext().updateDataFileInCatalog(dataFileInCatalog.getElementHeader().getGUID(), true, properties);
                            if (this.auditLog != null) {
                                this.auditLog.logMessage("updateFileInCatalog", BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_UPDATED.getMessageDefinition(this.connectorName, dataFileInCatalog.getDataFileProperties().getQualifiedName(), dataFileInCatalog.getElementHeader().getGUID()));
                            }
                        } else if (this.auditLog != null) {
                            this.auditLog.logMessage("updateFileInCatalog", BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, dataFileInCatalog.toString()));
                        }
                    } else {
                        this.catalogFile(file, "updateFileInCatalog");
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block9;
                    this.auditLog.logException("updateFileInCatalog", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, file.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    class FileCataloguingListener
    extends FileAlterationListenerAdaptor {
        private DataFilesMonitorIntegrationConnector connector;

        FileCataloguingListener(DataFilesMonitorIntegrationConnector connector) {
            this.connector = connector;
        }

        public void onFileCreate(File file) {
            String methodName = "onFileCreate";
            log.debug("File created: " + file.getName());
            this.connector.catalogFile(file, "onFileCreate");
        }

        public void onFileDelete(File file) {
            String methodName = "onFileDelete";
            log.debug("File deleted: " + file.getName());
            this.connector.archiveFileInCatalog(file, null, "onFileDelete");
        }

        public void onFileChange(File file) {
            log.debug("File changed: " + file.getName());
            this.connector.updateFileInCatalog(file);
        }

        public void onDirectoryCreate(File directory) {
            String methodName = "onDirectoryCreate";
            log.debug("Folder created: " + directory.getName());
            DataFilesMonitorIntegrationConnector.this.initiateDirectoryMonitoring(directory, "onDirectoryCreate");
        }

        public void onDirectoryDelete(File directory) {
            String methodName = "onDirectoryDelete";
            log.debug("Folder deleted: " + directory.getName());
            DataFilesMonitorIntegrationConnector.this.stopDirectoryMonitoring(directory.getName(), "onDirectoryDelete");
        }
    }
}

