/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.exception;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;

public class FileException
extends ConnectorCheckedException {
    private final String fileName;

    public FileException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, String fileName) {
        super(messageDefinition, className, actionDescription);
        this.fileName = fileName;
    }

    public FileException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, String fileName, Map<String, Object> relatedProperties) {
        super(messageDefinition, className, actionDescription, relatedProperties);
        this.fileName = fileName;
    }

    public FileException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Exception caughtError, String fileName) {
        super(messageDefinition, className, actionDescription, (Throwable)caughtError);
        this.fileName = fileName;
    }

    public FileException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Exception caughtError, String fileName, Map<String, Object> relatedProperties) {
        super(messageDefinition, className, actionDescription, (Throwable)caughtError, relatedProperties);
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return "FileException{fileName='" + this.fileName + "', reportedHTTPCode=" + this.getReportedHTTPCode() + ", reportingClassName='" + this.getReportingClassName() + "', reportingActionDescription='" + this.getReportingActionDescription() + "', errorMessage='" + this.getReportedErrorMessage() + "', reportedErrorMessageId='" + this.getReportedErrorMessageId() + "', reportedErrorMessageParameters=" + Arrays.toString(this.getReportedErrorMessageParameters()) + ", reportedSystemAction='" + this.getReportedSystemAction() + "', reportedUserAction='" + this.getReportedUserAction() + "', reportedCaughtException=" + this.getReportedCaughtException() + ", relatedProperties=" + this.getRelatedProperties() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof FileException)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        FileException that = (FileException)((Object)objectToCompare);
        return Objects.equals(this.getFileName(), that.getFileName());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFileName());
    }
}

