/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ArchiveProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFolderProvider;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitorIntegrationConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.exception.FileException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassification;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassifier;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFilesMonitorIntegrationConnector
extends BasicFilesMonitorIntegrationConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(DataFilesMonitorIntegrationConnector.class);
    private String templateGUID = null;

    @Override
    FileFolderElement getFolderElement(File dataFolderFile) throws ConnectorCheckedException {
        return super.getFolderElement(dataFolderFile, DeployedImplementationType.FILE_FOLDER.getAssociatedTypeName(), DeployedImplementationType.FILE_FOLDER.getDeployedImplementationType(), BasicFolderProvider.class.getName());
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        List<BasicFilesMonitorIntegrationConnectorBase.DirectoryToMonitor> directoriesToMonitor = super.getDirectoriesToMonitor();
        for (BasicFilesMonitorIntegrationConnectorBase.DirectoryToMonitor directoryToMonitor : directoriesToMonitor) {
            this.catalogDirectory(directoryToMonitor.directoryFile, "refresh");
            try {
                FileFolderElement folder = this.getFolderElement(directoryToMonitor.directoryFile);
                if (folder == null) continue;
                int startFrom = 0;
                int pageSize = 100;
                List cataloguedFiles = this.getContext().getFolderFiles(folder.getElementHeader().getGUID(), startFrom, pageSize);
                while (cataloguedFiles != null && !cataloguedFiles.isEmpty()) {
                    for (DataFileElement dataFile : cataloguedFiles) {
                        if (dataFile == null) continue;
                        if (dataFile.getElementHeader() != null && dataFile.getElementHeader().getGUID() != null && dataFile.getDataFileProperties() != null && dataFile.getDataFileProperties().getPathName() != null) {
                            File file = new File(dataFile.getDataFileProperties().getPathName());
                            if (file.exists()) continue;
                            this.archiveFileInCatalog(file, dataFile, "refresh");
                            continue;
                        }
                        if (this.auditLog == null) continue;
                        this.auditLog.logMessage("refresh", BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, dataFile.toString()));
                    }
                    cataloguedFiles = this.getContext().getFolderFiles(folder.getElementHeader().getGUID(), startFrom += pageSize, pageSize);
                }
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("refresh", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, directoryToMonitor.directoryFile.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
                throw new FileException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, directoryToMonitor.directoryFile.getAbsolutePath(), error.getMessage()), error.getClass().getName(), "refresh", error, directoryToMonitor.directoryFile.getAbsolutePath());
            }
        }
    }

    public void onFileCreate(File file) {
        String methodName = "onFileCreate";
        log.debug("File created: " + file.getName());
        this.catalogFile(file, "onFileCreate");
    }

    public void onFileDelete(File file) {
        String methodName = "onFileDelete";
        log.debug("File deleted: " + file.getName());
        this.archiveFileInCatalog(file, null, "onFileDelete");
    }

    public void onFileChange(File file) {
        log.debug("File changed: " + file.getName());
        this.updateFileInCatalog(file);
    }

    public void onDirectoryCreate(File directory) {
    }

    public void onDirectoryChange(File directory) {
    }

    public void onDirectoryDelete(File directory) {
    }

    private void catalogDirectory(File directory, String methodName) {
        String localMethodName = "catalogDirectory";
        File[] filesArray = directory.listFiles();
        if (filesArray != null) {
            for (File file : filesArray) {
                if (!super.isActive()) break;
                if (file == null) continue;
                if (file.isDirectory()) {
                    this.catalogDirectory(file, "catalogDirectory");
                    continue;
                }
                this.catalogFile(file, methodName);
            }
        }
    }

    private void catalogFile(File file, String methodName) {
        block18: {
            if (this.isActive()) {
                try {
                    DataFileElement cataloguedElement = this.getContext().getFileByPathName(file.getAbsolutePath());
                    if (cataloguedElement == null) {
                        if (this.fileTemplateQualifiedName == null) {
                            FileClassifier fileClassifier = this.getContext().getFileClassifier();
                            FileClassification fileClassification = fileClassifier.classifyFile(file);
                            if (!this.catalogClassifiedFiles || fileClassification.getFileType() != null || fileClassification.getAssetTypeName() != null || fileClassification.getDeployedImplementationType() != null) {
                                DataFileProperties properties = new DataFileProperties();
                                properties.setTypeName(fileClassification.getAssetTypeName());
                                properties.setDeployedImplementationType(fileClassification.getDeployedImplementationType());
                                properties.setPathName(fileClassification.getPathName());
                                properties.setName(fileClassification.getFileName());
                                properties.setFileType(fileClassification.getFileType());
                                properties.setModifiedTime(new Date(file.lastModified()));
                                List guids = this.getContext().addDataFileToCatalog(properties, null);
                                if (guids != null && !guids.isEmpty() && this.auditLog != null) {
                                    this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_CREATED.getMessageDefinition(this.connectorName, properties.getPathName(), (String)guids.get(guids.size() - 1)));
                                }
                            }
                        } else {
                            if (this.templateGUID == null) {
                                DataFileElement templateElement = this.getContext().getFileByPathName(this.fileTemplateQualifiedName);
                                if (templateElement != null) {
                                    if (templateElement.getElementHeader() != null && templateElement.getElementHeader().getGUID() != null) {
                                        this.templateGUID = templateElement.getElementHeader().getGUID();
                                    } else if (this.auditLog != null) {
                                        this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, templateElement.toString()));
                                    }
                                } else if (this.auditLog != null) {
                                    this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.MISSING_TEMPLATE.getMessageDefinition(this.connectorName, this.fileTemplateQualifiedName));
                                }
                            }
                            if (this.templateGUID != null) {
                                TemplateProperties properties = new TemplateProperties();
                                properties.setPathName(file.getAbsolutePath());
                                properties.setDisplayName(file.getName());
                                properties.setNetworkAddress(file.getAbsolutePath());
                                List guids = this.getContext().addDataFileToCatalogFromTemplate(this.templateGUID, properties);
                                if (guids != null && !guids.isEmpty() && this.auditLog != null) {
                                    this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_CREATED_FROM_TEMPLATE.getMessageDefinition(this.connectorName, properties.getPathName(), (String)guids.get(guids.size() - 1), this.fileTemplateQualifiedName, this.templateGUID));
                                }
                            }
                        }
                    } else {
                        this.updateFileInCatalog(file);
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block18;
                    this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, file.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    private void archiveFileInCatalog(File file, DataFileElement retrievedElement, String methodName) {
        block12: {
            if (this.isActive()) {
                try {
                    DataFileElement cataloguedElement = retrievedElement;
                    if (cataloguedElement == null) {
                        cataloguedElement = this.getContext().getFileByPathName(file.getAbsolutePath());
                    }
                    if (cataloguedElement == null) {
                        return;
                    }
                    if (cataloguedElement.getElementHeader() != null && cataloguedElement.getElementHeader().getGUID() != null && cataloguedElement.getDataFileProperties() != null && cataloguedElement.getDataFileProperties().getPathName() != null) {
                        if (this.allowCatalogDelete) {
                            this.getContext().deleteDataFileFromCatalog(cataloguedElement.getElementHeader().getGUID(), cataloguedElement.getDataFileProperties().getPathName());
                            if (this.auditLog != null) {
                                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_DELETED.getMessageDefinition(this.connectorName, cataloguedElement.getDataFileProperties().getPathName(), cataloguedElement.getElementHeader().getGUID()));
                            }
                        } else {
                            ArchiveProperties archiveProperties = new ArchiveProperties();
                            archiveProperties.setArchiveDate(new Date());
                            archiveProperties.setArchiveProcess(this.connectorName);
                            this.getContext().archiveDataFileInCatalog(cataloguedElement.getElementHeader().getGUID(), archiveProperties);
                            if (this.auditLog != null) {
                                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_ARCHIVED.getMessageDefinition(this.connectorName, cataloguedElement.getDataFileProperties().getPathName(), cataloguedElement.getElementHeader().getGUID()));
                            }
                        }
                    } else if (this.auditLog != null) {
                        this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, cataloguedElement.toString()));
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block12;
                    this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, file.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    private void updateFileInCatalog(File file) {
        block8: {
            if (this.isActive()) {
                String methodName = "updateFileInCatalog";
                try {
                    DataFileElement dataFileInCatalog = this.getContext().getFileByPathName(file.getAbsolutePath());
                    if (dataFileInCatalog != null) {
                        if (dataFileInCatalog.getElementHeader() != null && dataFileInCatalog.getElementHeader().getGUID() != null && dataFileInCatalog.getDataFileProperties() != null && dataFileInCatalog.getDataFileProperties().getPathName() != null) {
                            DataFileProperties properties = new DataFileProperties();
                            properties.setModifiedTime(new Date(file.lastModified()));
                            this.getContext().updateDataFileInCatalog(dataFileInCatalog.getElementHeader().getGUID(), true, properties);
                            if (this.auditLog != null) {
                                this.auditLog.logMessage("updateFileInCatalog", BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_UPDATED.getMessageDefinition(this.connectorName, dataFileInCatalog.getDataFileProperties().getPathName(), dataFileInCatalog.getElementHeader().getGUID()));
                            }
                        } else if (this.auditLog != null) {
                            this.auditLog.logMessage("updateFileInCatalog", BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, dataFileInCatalog.toString()));
                        }
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block8;
                    this.auditLog.logException("updateFileInCatalog", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, file.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }
}

