/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;
import org.odpi.openmetadata.adapters.connectors.datastore.datafolder.DataFolderProvider;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitorIntegrationConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFolderMonitorIntegrationConnector
extends BasicFilesMonitorIntegrationConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(DataFolderMonitorIntegrationConnector.class);
    private ConnectorCheckedException savedException = null;

    @Override
    FileFolderElement getFolderElement(File dataFolderFile) throws ConnectorCheckedException {
        return super.getFolderElement(dataFolderFile, DeployedImplementationType.DATA_FOLDER.getAssociatedTypeName(), DeployedImplementationType.DATA_FOLDER.getDeployedImplementationType(), DataFolderProvider.class.getName());
    }

    public void refresh() throws ConnectorCheckedException {
        if (this.savedException != null) {
            throw this.savedException;
        }
    }

    private void updateDataFolder(File fileChanged, Date modifiedTime, String methodName) throws ConnectorCheckedException {
        List<BasicFilesMonitorIntegrationConnectorBase.DirectoryToMonitor> directoriesToMonitor = super.getDirectoriesToMonitor();
        for (BasicFilesMonitorIntegrationConnectorBase.DirectoryToMonitor directoryToMonitor : directoriesToMonitor) {
            if (!super.isActive()) break;
            try {
                Date lastRecordedChange;
                if (!fileChanged.getAbsolutePath().startsWith(directoryToMonitor.directoryFile.getAbsolutePath())) continue;
                if (directoryToMonitor.dataFolderElement == null) {
                    directoryToMonitor.dataFolderElement = this.getFolderElement(directoryToMonitor.directoryFile);
                }
                if (directoryToMonitor.dataFolderElement == null || (lastRecordedChange = directoryToMonitor.dataFolderElement.getFileFolderProperties().getModifiedTime()) != null && !lastRecordedChange.before(new Date(directoryToMonitor.directoryFile.lastModified()))) continue;
                FileFolderProperties properties = new FileFolderProperties();
                properties.setModifiedTime(modifiedTime);
                this.getContext().updateDataFolderInCatalog(directoryToMonitor.dataFolderElement.getElementHeader().getGUID(), true, properties);
                if (this.auditLog == null) continue;
                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FOLDER_UPDATED_FOR_FILE.getMessageDefinition(this.connectorName, directoryToMonitor.directoryFile.getAbsolutePath(), modifiedTime.toString(), fileChanged.getAbsolutePath()));
            }
            catch (Exception error) {
                if (this.auditLog == null) continue;
                String folderGUID = null;
                if (directoryToMonitor.dataFolderElement != null) {
                    folderGUID = directoryToMonitor.dataFolderElement.getElementHeader().getGUID();
                }
                this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_FOLDER_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, folderGUID, directoryToMonitor.directoryFile.getAbsolutePath(), error.getMessage()), (Throwable)error);
            }
        }
    }

    public void onFileCreate(File file) {
        String methodName = "onFileCreate";
        log.debug("File created: " + file.getName());
        try {
            this.updateDataFolder(file, new Date(), "onFileCreate");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), file.getAbsolutePath(), "onFileCreate", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "onFileCreate", (Throwable)error);
        }
    }

    public void onFileDelete(File file) {
        String methodName = "onFileDelete";
        log.debug("File deleted: " + file.getName());
        try {
            this.updateDataFolder(file, new Date(), "onFileDelete");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), file.getAbsolutePath(), "onFileDelete", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "onFileDelete", (Throwable)error);
        }
    }

    public void onFileChange(File file) {
        String methodName = "onFileChange";
        log.debug("File changed: " + file.getName());
        try {
            this.updateDataFolder(file, new Date(), "onFileChange");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), file.getAbsolutePath(), "onFileChange", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "onFileChange", (Throwable)error);
        }
    }

    public void onDirectoryCreate(File directory) {
        String methodName = "onDirectoryCreate";
        log.debug("Folder created: " + directory.getName());
        try {
            this.updateDataFolder(directory, new Date(), "onDirectoryCreate");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), directory.getAbsolutePath(), "onDirectoryCreate", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "onDirectoryCreate", (Throwable)error);
        }
    }

    public void onDirectoryDelete(File directory) {
        String methodName = "onDirectoryDelete";
        log.debug("Folder deleted: " + directory.getName());
        try {
            this.updateDataFolder(directory, new Date(), "onDirectoryDelete");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), directory.getAbsolutePath(), "onDirectoryDelete", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "onDirectoryDelete", (Throwable)error);
        }
    }

    public void onDirectoryChange(File directory) {
        String methodName = "onDirectoryChange";
        log.debug("Folder changed: " + directory.getName());
        try {
            this.updateDataFolder(directory, new Date(), "onDirectoryChange");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), directory.getAbsolutePath(), "onDirectoryChange", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "onDirectoryChange", (Throwable)error);
        }
    }
}

