/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.PlaceholderPropertyType;

public enum FilesPlaceholderProperty {
    FOLDER_NAME("folderName", "The name of the leaf directory, without its enclosing directories.", "string", "myFolder"),
    DATA_SET_NAME("dataSetName", "The display name of the data set.", "string", "myDataSet"),
    FORMULA("formula", "The formula used to populate the data set.", "string", null),
    FORMULA_TYPE("formulaType", "The language/format used in the data set's formula.", "string", null),
    FILE_SYSTEM_NAME("fileSystemName", "The unique name for the file system that this file/directory belongs.  It may be a machine name or a URL to a remote file store.", "string", "/a/b/c/myFile.txt"),
    PATH_NAME("pathName", "The full pathname of the file including the directory names, file name and optional file extension, if applicable.", "string", "/a/b/c/myFile.txt"),
    FILE_NAME("fileName", "The short name of the file with its extension but without the directory names.", "string", "myFile.txt"),
    FILE_TYPE("fileType", "The logical file type of the file.", "string", "Text File"),
    FILE_EXTENSION("fileExtension", "The postfix identifier in the file name that indicates the format of the file.", "string", "txt"),
    FILE_ENCODING("fileEncoding", "The encoding scheme used on the file.", "string", "JSON"),
    DEPLOYED_IMPLEMENTATION_TYPE("deployedImplementationType", "The deployed implementation type for the file.", "string", "Build File"),
    DESCRIPTION("description", "The description of the resource to help a consumer understand its content and purpose.", "string", "This file contains a moth-worth of patient data for the Teddy Bear Drop Foot clinical trial."),
    PROGRAMMING_LANGUAGE("programmingLanguage", "The programming language used to encode the file.", "string", "Java"),
    EMBEDDED_METADATA("embeddedMetadata", "Descriptive metadata values embedded within the file.", "map<string, string>", null);

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private FilesPlaceholderProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return "{{" + this.name + "}}";
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<PlaceholderPropertyType> getDataFilesPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(PATH_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_TYPE.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_EXTENSION.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_ENCODING.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getMediaFilesPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(PATH_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_TYPE.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_EXTENSION.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_ENCODING.getPlaceholderType());
        placeholderPropertyTypes.add(EMBEDDED_METADATA.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getFolderPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(PATH_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FOLDER_NAME.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getDataSetPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DEPLOYED_IMPLEMENTATION_TYPE.getPlaceholderType());
        placeholderPropertyTypes.add(DATA_SET_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FORMULA.getPlaceholderType());
        placeholderPropertyTypes.add(FORMULA_TYPE.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getSoftwareFilesPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DEPLOYED_IMPLEMENTATION_TYPE.getPlaceholderType());
        placeholderPropertyTypes.add(PATH_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_TYPE.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_EXTENSION.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_ENCODING.getPlaceholderType());
        placeholderPropertyTypes.add(PROGRAMMING_LANGUAGE.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public PlaceholderPropertyType getPlaceholderType() {
        PlaceholderPropertyType placeholderPropertyType = new PlaceholderPropertyType();
        placeholderPropertyType.setName(this.name);
        placeholderPropertyType.setDescription(this.description);
        placeholderPropertyType.setDataType(this.dataType);
        placeholderPropertyType.setExample(this.example);
        placeholderPropertyType.setRequired(true);
        return placeholderPropertyType;
    }

    public String toString() {
        return "PlaceholderProperty{ name=" + this.name + "}";
    }
}

