/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DirectoryToMonitor;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.exception.ConfigException;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.exception.FileException;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileDirectoryListenerInterface;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DeleteMethod;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileFolderElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ArchiveProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.filesandfolders.FileFolderProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.files.connector.FilesIntegratorConnector;

public abstract class BasicFilesMonitorIntegrationConnectorBase
extends FilesIntegratorConnector {
    private final List<DirectoryToMonitor> directoriesToMonitor = new ArrayList<DirectoryToMonitor>();

    public void start() throws ConnectorCheckedException {
        super.start();
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.monitorEndpoint(this.connectionProperties.getConfigurationProperties());
        }
    }

    private void monitorEndpoint(Map<String, Object> configurationProperties) throws ConnectorCheckedException {
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null && endpoint.getAddress() != null) {
            String endpointNetworkAddress = endpoint.getAddress();
            for (DirectoryToMonitor directoryToMonitor : this.directoriesToMonitor) {
                if (!endpointNetworkAddress.equals(directoryToMonitor.directoryName)) continue;
                return;
            }
            DirectoryToMonitor directoryToMonitor = this.checkDirectoryToMonitor(OpenMetadataType.ENDPOINT.typeName + ":" + OpenMetadataProperty.NETWORK_ADDRESS.name, endpoint.getAddress(), null, null, null, configurationProperties);
            this.directoriesToMonitor.add(directoryToMonitor);
        }
    }

    protected abstract DirectoryToMonitor createDirectoryToMonitor(String var1, String var2, String var3, DeleteMethod var4, Map<String, String> var5, Map<String, Object> var6) throws ConnectorCheckedException;

    private DirectoryToMonitor checkDirectoryToMonitor(String sourceName, String pathName, String catalogTargetGUID, DeleteMethod deleteMethod, Map<String, String> templates, Map<String, Object> configurationProperties) throws ConnectorCheckedException {
        DirectoryToMonitor directoryToMonitor;
        block5: {
            String methodName = "checkDirectoryToMonitor";
            directoryToMonitor = this.createDirectoryToMonitor(sourceName, pathName, catalogTargetGUID, deleteMethod, templates, configurationProperties);
            try {
                FileUtils.sizeOf((File)directoryToMonitor.directoryFile);
                if (!directoryToMonitor.directoryFile.isDirectory()) {
                    this.throwConfigException(BasicFilesIntegrationConnectorsErrorCode.FILES_LOCATION_NOT_DIRECTORY, directoryToMonitor.sourceName, directoryToMonitor.directoryName, null);
                }
                if (!directoryToMonitor.directoryFile.canRead()) {
                    this.throwConfigException(BasicFilesIntegrationConnectorsErrorCode.FILES_LOCATION_NOT_READABLE, directoryToMonitor.sourceName, directoryToMonitor.directoryName, null);
                }
            }
            catch (IllegalArgumentException notFound) {
                if (!directoryToMonitor.waitForDirectory) {
                    this.throwConfigException(BasicFilesIntegrationConnectorsErrorCode.FILES_LOCATION_NOT_DIRECTORY, directoryToMonitor.sourceName, directoryToMonitor.directoryName, null);
                }
                if (this.auditLog == null) break block5;
                this.auditLog.logMessage("checkDirectoryToMonitor", BasicFilesIntegrationConnectorsAuditCode.FILES_LOCATION_NOT_FOUND.getMessageDefinition(pathName, this.connectorName, sourceName));
            }
        }
        return directoryToMonitor;
    }

    synchronized List<DirectoryToMonitor> getDirectoriesToMonitor() throws ConnectorCheckedException {
        String methodName = "getDirectoriesToMonitor";
        try {
            ArrayList<String> activeCatalogTargets = new ArrayList<String>();
            int startFrom = 0;
            int maxPageSize = this.integrationContext.getMaxPageSize();
            List catalogTargets = this.getContext().getCatalogTargets(startFrom, maxPageSize);
            while (catalogTargets != null) {
                for (CatalogTarget catalogTarget : catalogTargets) {
                    this.addCatalogTarget(catalogTarget);
                    activeCatalogTargets.add(catalogTarget.getRelationshipGUID());
                }
                catalogTargets = this.getContext().getCatalogTargets(startFrom += maxPageSize, maxPageSize);
            }
            for (DirectoryToMonitor directoryToMonitor : this.directoriesToMonitor) {
                if (directoryToMonitor.catalogTargetGUID != null && !activeCatalogTargets.contains(directoryToMonitor.catalogTargetGUID)) {
                    this.directoriesToMonitor.remove(directoryToMonitor);
                    continue;
                }
                if (directoryToMonitor.dataFolderElement == null) {
                    directoryToMonitor.dataFolderElement = this.getFolderElement(directoryToMonitor.directoryFile);
                }
                if (directoryToMonitor.isListening) continue;
                this.getContext().registerDirectoryTreeListener((FileDirectoryListenerInterface)directoryToMonitor, directoryToMonitor.directoryFile, null);
                directoryToMonitor.isListening = true;
            }
            return new ArrayList<DirectoryToMonitor>(this.directoriesToMonitor);
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("getDirectoriesToMonitor", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_RETRIEVING_CATALOG_TARGETS.getMessageDefinition(error.getClass().getName(), this.connectorName, "getDirectoriesToMonitor", this.connectorName, error.getMessage()));
            }
            throw new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXC_RETRIEVING_CATALOG_TARGETS.getMessageDefinition(error.getClass().getName(), this.connectorName, "getDirectoriesToMonitor", this.connectorName, error.getMessage()), error.getClass().getName(), "getDirectoriesToMonitor", (Throwable)error);
        }
    }

    void addCatalogTarget(CatalogTarget catalogTarget) throws ConnectorCheckedException {
        FileFolderElement fileFolderElement;
        for (DirectoryToMonitor directoryToMonitor : this.directoriesToMonitor) {
            if (!catalogTarget.getRelationshipGUID().equals(directoryToMonitor.catalogTargetGUID)) continue;
            return;
        }
        if (this.getContext().isTypeOf((ElementHeader)catalogTarget.getCatalogTargetElement(), OpenMetadataType.FILE_FOLDER.typeName) && (fileFolderElement = this.getFolderElement(catalogTarget.getCatalogTargetElement().getGUID())) != null && fileFolderElement.getFileFolderProperties() != null && fileFolderElement.getFileFolderProperties().getPathName() != null) {
            File pathFile = new File(fileFolderElement.getFileFolderProperties().getPathName());
            for (DirectoryToMonitor directoryToMonitor : this.directoriesToMonitor) {
                if (!directoryToMonitor.directoryFile.getAbsolutePath().equals(pathFile.getAbsolutePath())) continue;
                directoryToMonitor.catalogTargetGUID = catalogTarget.getRelationshipGUID();
                return;
            }
            try {
                DirectoryToMonitor directoryToMonitor = this.checkDirectoryToMonitor("CatalogTarget:" + catalogTarget.getRelationshipGUID(), fileFolderElement.getFileFolderProperties().getPathName(), catalogTarget.getRelationshipGUID(), catalogTarget.getDeleteMethod(), catalogTarget.getTemplateProperties(), catalogTarget.getConfigurationProperties());
                this.directoriesToMonitor.add(directoryToMonitor);
            }
            catch (ConnectorCheckedException connectorCheckedException) {
                // empty catch block
            }
        }
    }

    abstract FileFolderElement getFolderElement(File var1) throws ConnectorCheckedException;

    FileFolderElement getFolderElement(File dataFolderFile, String assetTypeName, String deployedImplementationType, String connectorProviderName) throws ConnectorCheckedException {
        block7: {
            String methodName = "getFolderElementByPathName";
            if (dataFolderFile.exists()) {
                try {
                    FileFolderElement folderElement = this.getContext().getFolderByPathName(dataFolderFile.getAbsolutePath());
                    if (folderElement == null) {
                        FileFolderProperties properties = new FileFolderProperties();
                        properties.setTypeName(assetTypeName);
                        properties.setPathName(dataFolderFile.getAbsolutePath());
                        properties.setName(dataFolderFile.getName());
                        properties.setDeployedImplementationType(deployedImplementationType);
                        this.getContext().addDataFolderToCatalog(properties, connectorProviderName);
                        folderElement = this.getContext().getFolderByPathName(dataFolderFile.getAbsolutePath());
                    }
                    if (folderElement.getElementHeader() == null || folderElement.getElementHeader().getGUID() == null || folderElement.getFileFolderProperties() == null) {
                        if (this.auditLog != null) {
                            this.auditLog.logMessage("getFolderElementByPathName", BasicFilesIntegrationConnectorsAuditCode.BAD_FOLDER_ELEMENT.getMessageDefinition(this.connectorName, dataFolderFile.getAbsolutePath(), folderElement.toString()));
                        }
                        break block7;
                    }
                    return folderElement;
                }
                catch (Exception error) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getFolderElementByPathName", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_RETRIEVING_FOLDER_BY_PATH_NAME.getMessageDefinition(error.getClass().getName(), this.connectorName, "getFolderElementByPathName", dataFolderFile.getName(), dataFolderFile.getAbsolutePath(), error.getMessage()));
                    }
                    throw new FileException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXC_RETRIEVING_FOLDER_BY_PATH_NAME.getMessageDefinition(error.getClass().getName(), this.connectorName, "getFolderElementByPathName", dataFolderFile.getName(), dataFolderFile.getAbsolutePath(), error.getMessage()), error.getClass().getName(), "getFolderElementByPathName", error, dataFolderFile.getAbsolutePath());
                }
            }
        }
        return null;
    }

    synchronized FileFolderElement getFolderElement(String folderElementGUID) throws ConnectorCheckedException {
        block6: {
            String methodName = "getFolderElementByGUID";
            try {
                FileFolderElement folderElement = this.getContext().getFolderByGUID(folderElementGUID);
                if (folderElement == null) {
                    return null;
                }
                if (folderElement.getElementHeader() == null || folderElement.getElementHeader().getGUID() == null || folderElement.getFileFolderProperties() == null) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getFolderElementByGUID", BasicFilesIntegrationConnectorsAuditCode.BAD_FOLDER_ELEMENT.getMessageDefinition(this.connectorName, folderElementGUID, folderElement.toString()));
                    }
                    break block6;
                }
                return folderElement;
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getFolderElementByGUID", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_RETRIEVING_FOLDER_BY_GUID.getMessageDefinition(error.getClass().getName(), this.connectorName, "getFolderElementByGUID", folderElementGUID, error.getMessage()));
                }
                throw new FileException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXC_RETRIEVING_FOLDER_BY_GUID.getMessageDefinition(error.getClass().getName(), this.connectorName, "getFolderElementByGUID", folderElementGUID, error.getMessage()), error.getClass().getName(), "getFolderElementByGUID", error, null);
            }
        }
        return null;
    }

    public void archiveFileInCatalog(File file, DataFileElement retrievedElement, boolean allowCatalogDelete, String methodName) {
        block12: {
            if (this.isActive()) {
                try {
                    DataFileElement cataloguedElement = retrievedElement;
                    if (cataloguedElement == null) {
                        cataloguedElement = this.getContext().getFileByPathName(file.getAbsolutePath());
                    }
                    if (cataloguedElement == null) {
                        return;
                    }
                    if (cataloguedElement.getElementHeader() != null && cataloguedElement.getElementHeader().getGUID() != null && cataloguedElement.getProperties() != null && cataloguedElement.getProperties().getPathName() != null) {
                        if (allowCatalogDelete) {
                            this.getContext().deleteDataFileFromCatalog(cataloguedElement.getElementHeader().getGUID(), cataloguedElement.getProperties().getPathName());
                            if (this.auditLog != null) {
                                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_DELETED.getMessageDefinition(this.connectorName, cataloguedElement.getProperties().getPathName(), cataloguedElement.getElementHeader().getGUID()));
                            }
                        } else {
                            ArchiveProperties archiveProperties = new ArchiveProperties();
                            archiveProperties.setArchiveDate(new Date());
                            archiveProperties.setArchiveProcess(this.connectorName);
                            this.getContext().archiveDataFileInCatalog(cataloguedElement.getElementHeader().getGUID(), archiveProperties);
                            if (this.auditLog != null) {
                                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_ARCHIVED.getMessageDefinition(this.connectorName, cataloguedElement.getProperties().getPathName(), cataloguedElement.getElementHeader().getGUID()));
                            }
                        }
                    } else if (this.auditLog != null) {
                        this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, cataloguedElement.toString()));
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block12;
                    this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, file.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    private void throwConfigException(BasicFilesIntegrationConnectorsErrorCode errorCode, String fileLocationSource, String fileLocationName, Exception caughtException) throws ConfigException {
        String methodName = "throwConfigException";
        ExceptionMessageDefinition messageDefinition = fileLocationName == null ? errorCode.getMessageDefinition(this.connectionBean.toString()) : errorCode.getMessageDefinition(fileLocationName);
        ConfigException error = caughtException == null ? new ConfigException(messageDefinition, ((Object)((Object)this)).getClass().getName(), "throwConfigException", fileLocationSource, fileLocationName) : new ConfigException(messageDefinition, ((Object)((Object)this)).getClass().getName(), "throwConfigException", caughtException, fileLocationSource, fileLocationName);
        if (this.auditLog != null) {
            this.auditLog.logException("throwConfigException", BasicFilesIntegrationConnectorsAuditCode.BAD_CONFIGURATION.getMessageDefinition(this.connectorName, ConfigException.class.getName(), fileLocationName, fileLocationSource, "throwConfigException", error.getMessage()), (Throwable)((Object)error));
        }
        throw error;
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", BasicFilesIntegrationConnectorsAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName));
        }
        super.disconnect();
    }
}

