/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitorIntegrationConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DirectoryToMonitor;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DeleteMethod;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileFolderElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.filesandfolders.FileFolderProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFolderMonitorForTarget
extends DirectoryToMonitor {
    private static final Logger log = LoggerFactory.getLogger(DataFolderMonitorForTarget.class);
    private ConnectorCheckedException savedException = null;

    public DataFolderMonitorForTarget(String connectorName, String sourceName, String pathName, String catalogTargetGUID, DeleteMethod deleteMethod, Map<String, String> templates, Map<String, Object> configurationProperties, BasicFilesMonitorIntegrationConnectorBase integrationConnector, FileFolderElement dataFolderElement, AuditLog auditLog) {
        super(connectorName, sourceName, pathName, catalogTargetGUID, deleteMethod, templates, configurationProperties, integrationConnector, dataFolderElement, auditLog);
    }

    private void updateDataFolder(File fileChanged, Date modifiedTime, String methodName) throws ConnectorCheckedException {
        List<DirectoryToMonitor> directoriesToMonitor = this.integrationConnector.getDirectoriesToMonitor();
        for (DirectoryToMonitor directoryToMonitor : directoriesToMonitor) {
            if (!this.integrationConnector.isActive()) break;
            try {
                Date lastRecordedChange;
                if (!fileChanged.getAbsolutePath().startsWith(directoryToMonitor.directoryFile.getAbsolutePath())) continue;
                if (directoryToMonitor.dataFolderElement == null) {
                    directoryToMonitor.dataFolderElement = this.integrationConnector.getFolderElement(directoryToMonitor.directoryFile);
                }
                if (directoryToMonitor.dataFolderElement == null || (lastRecordedChange = directoryToMonitor.dataFolderElement.getFileFolderProperties().getModifiedTime()) != null && !lastRecordedChange.before(new Date(directoryToMonitor.directoryFile.lastModified()))) continue;
                FileFolderProperties properties = new FileFolderProperties();
                properties.setModifiedTime(modifiedTime);
                this.integrationConnector.getContext().updateDataFolderInCatalog(directoryToMonitor.metadataSourceGUID, directoryToMonitor.metadataSourceName, directoryToMonitor.dataFolderElement.getElementHeader().getGUID(), true, properties);
                if (this.auditLog == null) continue;
                this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FOLDER_UPDATED_FOR_FILE.getMessageDefinition(this.sourceName, directoryToMonitor.directoryFile.getAbsolutePath(), modifiedTime.toString(), fileChanged.getAbsolutePath()));
            }
            catch (Exception error) {
                if (this.auditLog == null) continue;
                String folderGUID = null;
                if (directoryToMonitor.dataFolderElement != null) {
                    folderGUID = directoryToMonitor.dataFolderElement.getElementHeader().getGUID();
                }
                this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_FOLDER_UPDATE.getMessageDefinition(error.getClass().getName(), this.sourceName, folderGUID, directoryToMonitor.directoryFile.getAbsolutePath(), error.getMessage()), (Throwable)error);
            }
        }
    }

    @Override
    public void refresh() throws ConnectorCheckedException {
        if (this.savedException != null) {
            throw this.savedException;
        }
    }

    public void onFileCreate(File file) {
        String methodName = "onFileCreate";
        log.debug("File created: " + file.getName());
        try {
            this.updateDataFolder(file, new Date(), "onFileCreate");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), file.getAbsolutePath(), "onFileCreate", error.getMessage()), this.getClass().getName(), "onFileCreate", (Throwable)error);
        }
    }

    public void onFileDelete(File file) {
        String methodName = "onFileDelete";
        log.debug("File deleted: " + file.getName());
        try {
            this.updateDataFolder(file, new Date(), "onFileDelete");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), file.getAbsolutePath(), "onFileDelete", error.getMessage()), this.getClass().getName(), "onFileDelete", (Throwable)error);
        }
    }

    public void onFileChange(File file) {
        String methodName = "onFileChange";
        log.debug("File changed: " + file.getName());
        try {
            this.updateDataFolder(file, new Date(), "onFileChange");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), file.getAbsolutePath(), "onFileChange", error.getMessage()), this.getClass().getName(), "onFileChange", (Throwable)error);
        }
    }

    public void onDirectoryCreate(File directory) {
        String methodName = "onDirectoryCreate";
        log.debug("Folder created: " + directory.getName());
        try {
            this.updateDataFolder(directory, new Date(), "onDirectoryCreate");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), directory.getAbsolutePath(), "onDirectoryCreate", error.getMessage()), this.getClass().getName(), "onDirectoryCreate", (Throwable)error);
        }
    }

    public void onDirectoryDelete(File directory) {
        String methodName = "onDirectoryDelete";
        log.debug("Folder deleted: " + directory.getName());
        try {
            this.updateDataFolder(directory, new Date(), "onDirectoryDelete");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), directory.getAbsolutePath(), "onDirectoryDelete", error.getMessage()), this.getClass().getName(), "onDirectoryDelete", (Throwable)error);
        }
    }

    public void onDirectoryChange(File directory) {
        String methodName = "onDirectoryChange";
        log.debug("Folder changed: " + directory.getName());
        try {
            this.updateDataFolder(directory, new Date(), "onDirectoryChange");
        }
        catch (ConnectorCheckedException error) {
            this.savedException = error;
        }
        catch (Exception error) {
            this.savedException = new ConnectorCheckedException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), directory.getAbsolutePath(), "onDirectoryChange", error.getMessage()), this.getClass().getName(), "onDirectoryChange", (Throwable)error);
        }
    }
}

