/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitorIntegrationConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitoringConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileDirectoryListenerInterface;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DeleteMethod;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileFolderElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public abstract class DirectoryToMonitor
implements FileDirectoryListenerInterface {
    protected final PropertyHelper propertyHelper = new PropertyHelper();
    protected final AuditLog auditLog;
    protected final BasicFilesMonitorIntegrationConnectorBase integrationConnector;
    protected final String connectorName;
    protected String sourceName = null;
    protected String directoryName = null;
    protected FileFolderElement dataFolderElement = null;
    protected File directoryFile = null;
    protected boolean isListening = false;
    protected String catalogTargetGUID = null;
    protected String fileTemplateQualifiedName = null;
    protected String fileTemplateGUID = null;
    protected String directoryTemplateQualifiedName = null;
    protected String directoryTemplateGUID = null;
    protected String toDoTemplateQualifiedName = null;
    protected String toDoTemplateGUID = null;
    protected String incidentReportTemplateQualifiedName = null;
    protected String incidentReportTemplateGUID = null;
    protected String newFileProcessName = null;
    protected boolean allowCatalogDelete = false;
    protected boolean waitForDirectory = false;
    protected boolean catalogClassifiedFiles = true;
    protected final Map<String, Object> configurationProperties;
    protected String metadataSourceGUID = null;
    protected String metadataSourceName = null;

    public DirectoryToMonitor(String connectorName, String sourceName, String pathName, String catalogTargetGUID, DeleteMethod deleteMethod, Map<String, String> templates, Map<String, Object> configurationProperties, BasicFilesMonitorIntegrationConnectorBase integrationConnector, FileFolderElement dataFolderElement, AuditLog auditLog) {
        String methodName = "DirectoryToMonitor";
        this.connectorName = connectorName;
        this.sourceName = sourceName;
        this.directoryName = pathName.startsWith("file:///") ? pathName.substring(7) : pathName;
        this.directoryFile = new File(this.directoryName);
        this.dataFolderElement = dataFolderElement;
        if (dataFolderElement != null) {
            this.metadataSourceGUID = dataFolderElement.getElementHeader().getOrigin().getHomeMetadataCollectionId();
            this.metadataSourceName = dataFolderElement.getElementHeader().getOrigin().getHomeMetadataCollectionName();
        }
        this.catalogTargetGUID = catalogTargetGUID;
        this.integrationConnector = integrationConnector;
        this.auditLog = auditLog;
        this.configurationProperties = configurationProperties;
        if (configurationProperties != null) {
            if (configurationProperties.get(BasicFilesMonitoringConfigurationProperty.NEW_FILE_PROCESS_NAME.getName()) != null) {
                this.newFileProcessName = configurationProperties.get(BasicFilesMonitoringConfigurationProperty.NEW_FILE_PROCESS_NAME.getName()).toString();
            }
            if (configurationProperties.containsKey("allowCatalogDelete")) {
                this.allowCatalogDelete = true;
            }
            if (configurationProperties.containsKey("catalogAllFiles")) {
                this.catalogClassifiedFiles = false;
            }
            if (configurationProperties.containsKey("waitForDirectory")) {
                this.waitForDirectory = true;
            }
            if (configurationProperties.get("fileTemplateQualifiedName") != null) {
                this.fileTemplateQualifiedName = configurationProperties.get("fileTemplateQualifiedName").toString();
            }
            if (configurationProperties.get("directoryTemplateQualifiedName") != null) {
                this.directoryTemplateQualifiedName = configurationProperties.get("directoryTemplateQualifiedName").toString();
            }
            if (configurationProperties.get("toDoTemplateQualifiedName") != null) {
                this.directoryTemplateQualifiedName = configurationProperties.get("toDoTemplateQualifiedName").toString();
            }
            if (configurationProperties.get("incidentReportTemplateQualifiedName") != null) {
                this.directoryTemplateQualifiedName = configurationProperties.get("incidentReportTemplateQualifiedName").toString();
            }
        }
        if (templates != null) {
            if (templates.get(OpenMetadataType.DATA_FILE.typeName) != null) {
                this.fileTemplateQualifiedName = templates.get(OpenMetadataType.DATA_FILE.typeName);
            }
            if (templates.get(OpenMetadataType.FILE_FOLDER.typeName) != null) {
                this.directoryTemplateQualifiedName = templates.get(OpenMetadataType.FILE_FOLDER.typeName);
            }
            if (templates.get(OpenMetadataType.DATA_FOLDER.typeName) != null) {
                this.directoryTemplateQualifiedName = templates.get(OpenMetadataType.DATA_FOLDER.typeName);
            }
            if (templates.get(OpenMetadataType.TO_DO.typeName) != null) {
                this.toDoTemplateQualifiedName = templates.get(OpenMetadataType.TO_DO.typeName);
            }
            if (templates.get(OpenMetadataType.INCIDENT_REPORT.typeName) != null) {
                this.incidentReportTemplateQualifiedName = templates.get(OpenMetadataType.DATA_FILE.typeName);
            }
        }
        if (deleteMethod != null) {
            this.allowCatalogDelete = deleteMethod.equals((Object)DeleteMethod.SOFT_DELETE);
        }
        auditLog.logMessage("DirectoryToMonitor", BasicFilesIntegrationConnectorsAuditCode.CONNECTOR_CONFIGURATION.getMessageDefinition(connectorName, this.directoryName, Boolean.toString(this.allowCatalogDelete), Boolean.toString(this.waitForDirectory), this.fileTemplateQualifiedName, this.directoryTemplateQualifiedName, this.toDoTemplateQualifiedName, this.incidentReportTemplateQualifiedName));
    }

    public abstract void refresh() throws ConnectorCheckedException;
}

