/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitorIntegrationConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DataFilesMonitorForTarget;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.FileBasedOpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.FileBasedOpenMetadataArchiveStoreProvider;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DeleteMethod;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileFolderElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.filesandfolders.DataFileProperties;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.FileExtension;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMArchiveFilesMonitorForTarget
extends DataFilesMonitorForTarget {
    private static final Logger log = LoggerFactory.getLogger(OMArchiveFilesMonitorForTarget.class);
    private final ConnectorBroker connectorBroker;

    public OMArchiveFilesMonitorForTarget(String connectorName, String sourceName, String pathName, String catalogTargetGUID, DeleteMethod deleteMethod, Map<String, String> templates, Map<String, Object> configurationProperties, BasicFilesMonitorIntegrationConnectorBase integrationConnector, FileFolderElement dataFolderElement, AuditLog auditLog) {
        super(connectorName, sourceName, pathName, catalogTargetGUID, deleteMethod, templates, configurationProperties, integrationConnector, dataFolderElement, auditLog);
        this.connectorBroker = new ConnectorBroker(this.auditLog);
    }

    @Override
    protected String addDataFileToCatalog(DataFileProperties properties) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addDataFileToCatalog";
        if (FileExtension.OM_ARCHIVE_FILE.getFileExtension().equals(properties.getFileExtension())) {
            ElementProperties replacementProperties = this.updateReplacementProperties(properties.getPathName(), null);
            String propertyValue = this.propertyHelper.getStringProperty(this.connectorName, OpenMetadataProperty.NAME.name, replacementProperties, "addDataFileToCatalog");
            if (propertyValue != null) {
                properties.setName(propertyValue);
            }
            if ((propertyValue = this.propertyHelper.getStringProperty(this.connectorName, OpenMetadataProperty.DESCRIPTION.name, replacementProperties, "addDataFileToCatalog")) != null) {
                properties.setResourceDescription(propertyValue);
            }
            Map additionalProperties = properties.getAdditionalProperties();
            Map propertyMap = this.propertyHelper.getStringMapFromProperty(this.connectorName, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, replacementProperties, "addDataFileToCatalog");
            if (additionalProperties == null) {
                properties.setAdditionalProperties(propertyMap);
            } else if (propertyMap != null) {
                additionalProperties.putAll(propertyMap);
                properties.setAdditionalProperties(additionalProperties);
            }
            return super.addDataFileToCatalog(properties);
        }
        log.debug("ignoring file " + properties);
        return null;
    }

    @Override
    protected String addDataFileViaTemplate(String assetTypeName, String fileTemplateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (FileExtension.OM_ARCHIVE_FILE.getFileExtension().equals(placeholderProperties.get(PlaceholderProperty.FILE_EXTENSION.getName()))) {
            return super.addDataFileViaTemplate(assetTypeName, fileTemplateGUID, this.updateReplacementProperties(placeholderProperties.get(PlaceholderProperty.FILE_PATH_NAME.getName()), replacementProperties), placeholderProperties);
        }
        log.debug("ignoring file " + placeholderProperties);
        return null;
    }

    private ElementProperties updateReplacementProperties(String pathName, ElementProperties replacementProperties) throws ConnectorCheckedException {
        String methodName = "updateReplacementProperties";
        ElementProperties archiveElementProperties = replacementProperties;
        try {
            OpenMetadataArchiveProperties properties;
            FileBasedOpenMetadataArchiveStoreProvider provider = new FileBasedOpenMetadataArchiveStoreProvider();
            Connection connection = new Connection();
            connection.setConnectorType(provider.getConnectorType());
            Endpoint endpoint = new Endpoint();
            endpoint.setAddress(pathName);
            connection.setEndpoint(endpoint);
            FileBasedOpenMetadataArchiveStoreConnector connector = (FileBasedOpenMetadataArchiveStoreConnector)this.connectorBroker.getConnector(connection);
            OpenMetadataArchive openMetadataArchive = connector.getArchiveContents();
            if (openMetadataArchive != null && (properties = openMetadataArchive.getArchiveProperties()) != null) {
                archiveElementProperties = this.propertyHelper.addStringProperty(archiveElementProperties, OpenMetadataProperty.NAME.name, properties.getArchiveName());
                archiveElementProperties = this.propertyHelper.addStringProperty(archiveElementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getArchiveDescription());
                HashMap<String, String> additionalProperties = new HashMap<String, String>();
                additionalProperties.put("archiveGUID", properties.getArchiveGUID());
                additionalProperties.put("archiveVersion", properties.getArchiveVersion());
                if (properties.getArchiveType() != null) {
                    additionalProperties.put("archiveType", properties.getArchiveType().getName());
                } else {
                    additionalProperties.put("archiveType", null);
                }
                additionalProperties.put("originatorName", properties.getOriginatorName());
                additionalProperties.put("originatorOrganization", properties.getOriginatorOrganization());
                additionalProperties.put("originatorLicense", properties.getOriginatorLicense());
                if (properties.getDependsOnArchives() != null) {
                    additionalProperties.put("dependsOnArchives", properties.getDependsOnArchives().toString());
                } else {
                    additionalProperties.put("dependsOnArchives", "[]");
                }
                if (properties.getCreationDate() != null) {
                    additionalProperties.put("creationDate", properties.getCreationDate().toString());
                } else {
                    additionalProperties.put("creationDate", null);
                }
                archiveElementProperties = this.propertyHelper.addStringMapProperty(archiveElementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties);
            }
        }
        catch (ClassCastException | ConnectionCheckedException | RepositoryErrorException error) {
            this.auditLog.logMessage("updateReplacementProperties", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "updateReplacementProperties", error.getMessage()));
        }
        return archiveElementProperties;
    }
}

