/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitorIntegrationConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DataFilesMonitorIntegrationConnector;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DirectoryToMonitor;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassification;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassifier;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.integration.context.StewardshipAction;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DeleteMethod;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileFolderElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.filesandfolders.DataFileProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFilesMonitorForTarget
extends DirectoryToMonitor {
    private static final Logger log = LoggerFactory.getLogger(DataFilesMonitorIntegrationConnector.class);

    public DataFilesMonitorForTarget(String connectorName, String sourceName, String pathName, String catalogTargetGUID, DeleteMethod deleteMethod, Map<String, String> templates, Map<String, Object> configurationProperties, BasicFilesMonitorIntegrationConnectorBase integrationConnector, FileFolderElement dataFolderElement, AuditLog auditLog) {
        super(connectorName, sourceName, pathName, catalogTargetGUID, deleteMethod, templates, configurationProperties, integrationConnector, dataFolderElement, auditLog);
    }

    @Override
    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        this.catalogDirectory(this.directoryFile, "refresh");
    }

    public void onFileCreate(File file) {
        String methodName = "onFileCreate";
        log.debug("File created: " + file.getName());
        this.catalogFile(file, "onFileCreate");
    }

    public void onFileDelete(File file) {
        String methodName = "onFileDelete";
        log.debug("File deleted: " + file.getName());
        this.integrationConnector.archiveFileInCatalog(file, null, this.allowCatalogDelete, "onFileDelete");
    }

    public void onFileChange(File file) {
        log.debug("File changed: " + file.getName());
        this.updateFileInCatalog(file);
    }

    public void onDirectoryCreate(File directory) {
    }

    public void onDirectoryChange(File directory) {
    }

    public void onDirectoryDelete(File directory) {
    }

    private void catalogDirectory(File directory, String methodName) {
        String localMethodName = "catalogDirectory";
        File[] filesArray = directory.listFiles();
        if (filesArray != null) {
            for (File file : filesArray) {
                if (!this.integrationConnector.isActive()) break;
                if (file == null) continue;
                if (file.isDirectory()) {
                    this.catalogDirectory(file, "catalogDirectory");
                    continue;
                }
                this.catalogFile(file, methodName);
            }
        }
    }

    private void catalogFile(File file, String methodName) {
        block23: {
            if (this.integrationConnector.isActive()) {
                try {
                    FileClassifier fileClassifier = this.integrationConnector.getContext().getFileClassifier();
                    FileClassification fileClassification = fileClassifier.classifyFile(file);
                    DataFileElement cataloguedElement = this.integrationConnector.getContext().getFileByPathName(file.getAbsolutePath());
                    if (cataloguedElement == null) {
                        if (this.fileTemplateQualifiedName == null) {
                            if (!this.catalogClassifiedFiles || fileClassification.getFileType() != null || fileClassification.getAssetTypeName() != null || fileClassification.getDeployedImplementationType() != null) {
                                DataFileProperties properties = new DataFileProperties();
                                properties.setTypeName(fileClassification.getAssetTypeName());
                                properties.setDeployedImplementationType(fileClassification.getDeployedImplementationType());
                                properties.setPathName(fileClassification.getPathName());
                                properties.setName(fileClassification.getFileName());
                                properties.setFileName(fileClassification.getFileName());
                                properties.setFileType(fileClassification.getFileType());
                                properties.setFileExtension(fileClassification.getFileExtension());
                                properties.setModifiedTime(fileClassification.getLastModifiedTime());
                                properties.setCreateTime(fileClassification.getCreationTime());
                                properties.setEncodingType(fileClassification.getEncoding());
                                HashMap<String, String> additionalProperties = new HashMap<String, String>();
                                additionalProperties.put("canRead", Boolean.toString(fileClassification.isCanRead()));
                                additionalProperties.put("canWrite", Boolean.toString(fileClassification.isCanWrite()));
                                additionalProperties.put("canExecute", Boolean.toString(fileClassification.isCanExecute()));
                                additionalProperties.put("isSymLink", Boolean.toString(fileClassification.isSymLink()));
                                additionalProperties.put("isHidden", Boolean.toString(fileClassification.isHidden()));
                                properties.setAdditionalProperties(additionalProperties);
                                String guid = this.addDataFileToCatalog(properties);
                                if (guid != null) {
                                    this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_CREATED.getMessageDefinition(this.connectorName, properties.getPathName(), guid));
                                }
                            }
                        } else {
                            OpenMetadataAccess openMetadataAccess = this.integrationConnector.getContext().getIntegrationGovernanceContext().getOpenMetadataAccess();
                            if (this.fileTemplateGUID == null) {
                                OpenMetadataElement templateElement = openMetadataAccess.getMetadataElementByUniqueName(this.fileTemplateQualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name);
                                if (templateElement != null) {
                                    this.fileTemplateGUID = templateElement.getElementGUID();
                                } else {
                                    this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.MISSING_TEMPLATE.getMessageDefinition(this.connectorName, this.fileTemplateQualifiedName));
                                }
                            }
                            if (this.fileTemplateGUID != null) {
                                HashMap<String, String> placeholderProperties = new HashMap<String, String>();
                                placeholderProperties.put(PlaceholderProperty.FILE_PATH_NAME.getName(), fileClassification.getPathName());
                                placeholderProperties.put(PlaceholderProperty.FILE_TYPE.getName(), fileClassification.getFileType());
                                placeholderProperties.put(PlaceholderProperty.FILE_EXTENSION.getName(), fileClassification.getFileExtension());
                                placeholderProperties.put(PlaceholderProperty.FILE_NAME.getName(), fileClassification.getFileName());
                                if (fileClassification.getCreationTime() != null) {
                                    placeholderProperties.put(PlaceholderProperty.CREATION_DATE.getName(), fileClassification.getCreationTime().toString());
                                    placeholderProperties.put(PlaceholderProperty.RECEIVED_DATE.getName(), fileClassification.getCreationTime().toString());
                                } else {
                                    placeholderProperties.put(PlaceholderProperty.CREATION_DATE.getName(), "");
                                    placeholderProperties.put(PlaceholderProperty.RECEIVED_DATE.getName(), "");
                                }
                                if (fileClassification.getLastModifiedTime() != null) {
                                    placeholderProperties.put(PlaceholderProperty.LAST_UPDATE_DATE.getName(), fileClassification.getLastModifiedTime().toString());
                                } else {
                                    placeholderProperties.put(PlaceholderProperty.LAST_UPDATE_DATE.getName(), "");
                                }
                                if (fileClassification.getLastAccessedTime() != null) {
                                    placeholderProperties.put(PlaceholderProperty.LAST_ACCESSED_DATE.getName(), fileClassification.getLastAccessedTime().toString());
                                } else {
                                    placeholderProperties.put(PlaceholderProperty.LAST_ACCESSED_DATE.getName(), "");
                                }
                                String newFileGUID = this.addDataFileViaTemplate(fileClassification.getAssetTypeName(), this.fileTemplateGUID, null, placeholderProperties);
                                if (newFileGUID != null) {
                                    this.auditLog.logMessage(methodName, BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_CREATED_FROM_TEMPLATE.getMessageDefinition(this.sourceName, fileClassification.getPathName(), newFileGUID, this.fileTemplateQualifiedName, this.fileTemplateGUID));
                                }
                                if (this.newFileProcessName != null) {
                                    StewardshipAction stewardshipAction = this.integrationConnector.getContext().getIntegrationGovernanceContext().getStewardshipAction();
                                    HashMap<String, String> requestParameters = new HashMap<String, String>();
                                    if (this.configurationProperties != null) {
                                        for (String configurationProperty : this.configurationProperties.keySet()) {
                                            if (this.configurationProperties.get(configurationProperty) == null) continue;
                                            requestParameters.put(configurationProperty, this.configurationProperties.get(configurationProperty).toString());
                                        }
                                    }
                                    ArrayList<NewActionTarget> actionTargets = new ArrayList<NewActionTarget>();
                                    NewActionTarget actionTarget = new NewActionTarget();
                                    actionTarget.setActionTargetGUID(newFileGUID);
                                    actionTarget.setActionTargetName("sourceFile");
                                    actionTargets.add(actionTarget);
                                    stewardshipAction.initiateGovernanceActionProcess(this.newFileProcessName, null, actionTargets, null, requestParameters, this.connectorName, null);
                                }
                            }
                        }
                    } else {
                        this.updateFileInCatalog(file);
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block23;
                    this.auditLog.logException(methodName, BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.sourceName, file.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    private void updateFileInCatalog(File file) {
        if (this.integrationConnector.isActive()) {
            String methodName = "updateFileInCatalog";
            try {
                DataFileElement dataFileInCatalog = this.integrationConnector.getContext().getFileByPathName(file.getAbsolutePath());
                if (dataFileInCatalog != null) {
                    if (dataFileInCatalog.getElementHeader() != null && dataFileInCatalog.getElementHeader().getGUID() != null && dataFileInCatalog.getProperties() != null && dataFileInCatalog.getProperties().getPathName() != null) {
                        DataFileProperties properties = new DataFileProperties();
                        Date fileLastModifiedDate = new Date(file.lastModified());
                        if (properties.getModifiedTime() == null || fileLastModifiedDate.after(properties.getModifiedTime())) {
                            properties.setModifiedTime(fileLastModifiedDate);
                            this.integrationConnector.getContext().updateDataFileInCatalog(dataFileInCatalog.getElementHeader().getGUID(), true, properties);
                            this.auditLog.logMessage("updateFileInCatalog", BasicFilesIntegrationConnectorsAuditCode.DATA_FILE_UPDATED.getMessageDefinition(this.connectorName, dataFileInCatalog.getProperties().getPathName(), dataFileInCatalog.getElementHeader().getGUID()));
                        }
                    } else {
                        this.auditLog.logMessage("updateFileInCatalog", BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, dataFileInCatalog.toString()));
                    }
                }
            }
            catch (Exception error) {
                this.auditLog.logException("updateFileInCatalog", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.sourceName, file.getAbsolutePath(), error.getMessage()), (Throwable)error);
            }
        }
    }

    protected String addDataFileToCatalog(DataFileProperties properties) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List guids = this.integrationConnector.getContext().addDataFileToCatalog(properties, null);
        if (guids != null && !guids.isEmpty()) {
            return (String)guids.get(guids.size() - 1);
        }
        return null;
    }

    protected String addDataFileViaTemplate(String assetTypeName, String fileTemplateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataAccess openMetadataAccess = this.integrationConnector.getContext().getIntegrationGovernanceContext().getOpenMetadataAccess();
        return openMetadataAccess.createMetadataElementFromTemplate(assetTypeName, null, true, null, null, fileTemplateGUID, replacementProperties, placeholderProperties, null, null, null, false);
    }
}

