/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.basicfiles;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFolderProvider;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitorIntegrationConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DataFilesMonitorForTarget;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DirectoryToMonitor;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.BasicFilesIntegrationConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.ffdc.exception.FileException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DeleteMethod;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileFolderElement;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;

public class DataFilesMonitorIntegrationConnector
extends BasicFilesMonitorIntegrationConnectorBase {
    @Override
    public DirectoryToMonitor createDirectoryToMonitor(String sourceName, String pathName, String catalogTargetGUID, DeleteMethod deleteMethod, Map<String, String> templates, Map<String, Object> configurationProperties) throws ConnectorCheckedException {
        return new DataFilesMonitorForTarget(this.connectorName, sourceName, pathName, catalogTargetGUID, deleteMethod, templates, configurationProperties, this, this.getFolderElement(new File(pathName)), this.auditLog);
    }

    @Override
    FileFolderElement getFolderElement(File dataFolderFile) throws ConnectorCheckedException {
        return super.getFolderElement(dataFolderFile, DeployedImplementationType.FILE_FOLDER.getAssociatedTypeName(), DeployedImplementationType.FILE_FOLDER.getDeployedImplementationType(), BasicFolderProvider.class.getName());
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        List<DirectoryToMonitor> directoriesToMonitor = super.getDirectoriesToMonitor();
        for (DirectoryToMonitor directoryToMonitor : directoriesToMonitor) {
            directoryToMonitor.refresh();
            try {
                FileFolderElement folder = this.getFolderElement(directoryToMonitor.directoryFile);
                if (folder == null) continue;
                int startFrom = 0;
                int pageSize = 100;
                List cataloguedFiles = this.getContext().getFolderFiles(folder.getElementHeader().getGUID(), startFrom, pageSize);
                while (cataloguedFiles != null && !cataloguedFiles.isEmpty()) {
                    for (DataFileElement dataFile : cataloguedFiles) {
                        if (dataFile == null) continue;
                        if (dataFile.getElementHeader() != null && dataFile.getElementHeader().getGUID() != null && dataFile.getProperties() != null && dataFile.getProperties().getPathName() != null) {
                            File file = new File(dataFile.getProperties().getPathName());
                            if (file.exists()) continue;
                            this.archiveFileInCatalog(file, dataFile, false, "refresh");
                            continue;
                        }
                        if (this.auditLog == null) continue;
                        this.auditLog.logMessage("refresh", BasicFilesIntegrationConnectorsAuditCode.BAD_FILE_ELEMENT.getMessageDefinition(this.connectorName, dataFile.toString()));
                    }
                    cataloguedFiles = this.getContext().getFolderFiles(folder.getElementHeader().getGUID(), startFrom += pageSize, pageSize);
                }
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("refresh", BasicFilesIntegrationConnectorsAuditCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, directoryToMonitor.directoryFile.getAbsolutePath(), error.getMessage()), (Throwable)error);
                }
                throw new FileException(BasicFilesIntegrationConnectorsErrorCode.UNEXPECTED_EXC_DATA_FILE_UPDATE.getMessageDefinition(error.getClass().getName(), this.connectorName, directoryToMonitor.directoryFile.getAbsolutePath(), error.getMessage()), error.getClass().getName(), "refresh", error, directoryToMonitor.directoryFile.getAbsolutePath());
            }
        }
    }
}

