/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.files.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.FilesAndFoldersClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ArchiveProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.StructSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class FilesIntegratorContext {
    private FilesAndFoldersClient client;
    private DataManagerEventClient eventClient;
    private String userId;
    private String fileServerCapabilityGUID;
    private String fileServerCapabilityName;
    private boolean fileServerCapabilityIsHome = true;

    public FilesIntegratorContext(FilesAndFoldersClient client, DataManagerEventClient eventClient, String userId, String fileServerCapabilityGUID, String fileServerCapabilityName) {
        this.client = client;
        this.eventClient = eventClient;
        this.userId = userId;
        this.fileServerCapabilityGUID = fileServerCapabilityGUID;
        this.fileServerCapabilityName = fileServerCapabilityName;
        if (fileServerCapabilityGUID == null) {
            this.fileServerCapabilityIsHome = false;
        }
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public List<String> createNestedFolders(String parentGUID, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createNestedFolders(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, parentGUID, pathName);
    }

    public void attachTopLevelFolder(String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.attachTopLevelFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, fileSystemGUID, folderGUID);
    }

    public void detachTopLevelFolder(String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.detachTopLevelFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, fileSystemGUID, folderGUID);
    }

    public List<String> addDataFileToCatalog(DataFileProperties dataFileProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.addDataFileToCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileProperties, connectorProviderName);
    }

    public List<String> addDataFileToCatalogFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.addDataFileToCatalogFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, templateGUID, templateProperties);
    }

    public void updateDataFileInCatalog(String dataFileGUID, boolean isMergeUpdate, DataFileProperties dataFileProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateDataFileInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileGUID, isMergeUpdate, dataFileProperties);
    }

    public void archiveDataFileInCatalog(String dataFileGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.archiveDataFileInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileGUID, archiveProperties);
    }

    public void deleteDataFileFromCatalog(String dataFileGUID, String fullPathname) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.deleteDataFileFromCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileGUID, fullPathname);
    }

    public List<String> addDataFolderToCatalog(FileFolderProperties fileFolderProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.addDataFolderToCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, fileFolderProperties, connectorProviderName);
    }

    public List<String> addDataFolderToCatalogFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.addDataFolderToCatalogFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, templateGUID, templateProperties);
    }

    public void updateDataFolderInCatalog(String dataFolderGUID, boolean isMergeUpdate, FileFolderProperties fileFolderProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateDataFolderInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFolderGUID, isMergeUpdate, fileFolderProperties);
    }

    public void archiveDataFolderInCatalog(String dataFolderGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.archiveDataFolderInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFolderGUID, archiveProperties);
    }

    public void attachDataFileAssetToFolder(String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.attachDataFileAssetToFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, folderGUID, fileGUID);
    }

    public void detachDataFileAssetFromFolder(String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.detachDataFileAssetFromFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, folderGUID, fileGUID);
    }

    public FileFolderElement getFolderByGUID(String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFolderByGUID(this.userId, folderGUID);
    }

    public FileFolderElement getFolderByPathName(String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFolderByPathName(this.userId, pathName);
    }

    public List<FileFolderElement> getTopLevelFolders(String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTopLevelFolders(this.userId, fileSystemGUID, startFrom, pageSize);
    }

    public List<FileFolderElement> getNestedFolders(String parentFolderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getNestedFolders(this.userId, parentFolderGUID, startFrom, pageSize);
    }

    public List<DataFileElement> getTopLevelDataFiles(String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTopLevelDataFiles(this.userId, fileSystemGUID, startFrom, pageSize);
    }

    public List<DataFileElement> getFolderFiles(String folderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFolderFiles(this.userId, folderGUID, startFrom, pageSize);
    }

    public DataFileElement getFileByGUID(String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFileByGUID(this.userId, fileGUID);
    }

    public DataFileElement getFileByPathName(String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFileByPathName(this.userId, pathName);
    }

    public String createPrimitiveSchemaType(PrimitiveSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createPrimitiveSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, this.fileServerCapabilityIsHome, schemaTypeProperties);
    }

    public String createLiteralSchemaType(LiteralSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createLiteralSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, this.fileServerCapabilityIsHome, schemaTypeProperties);
    }

    public String createEnumSchemaType(EnumSchemaTypeProperties schemaTypeProperties, String validValuesSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createEnumSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, this.fileServerCapabilityIsHome, schemaTypeProperties, validValuesSetGUID);
    }

    public List<ValidValueSetElement> getValidValueSetByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getValidValueSetByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueSetElement> findValidValueSet(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findValidValueSet(this.userId, searchString, startFrom, pageSize);
    }

    public String createStructSchemaType(StructSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createStructSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, this.fileServerCapabilityIsHome, schemaTypeProperties);
    }

    public String createSchemaTypeChoice(SchemaTypeChoiceProperties schemaTypeProperties, List<String> schemaTypeOptionGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createSchemaTypeChoice(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, this.fileServerCapabilityIsHome, schemaTypeProperties, schemaTypeOptionGUIDs);
    }

    public String createMapSchemaType(MapSchemaTypeProperties schemaTypeProperties, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createMapSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, this.fileServerCapabilityIsHome, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
    }

    public String createSchemaTypeFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createSchemaTypeFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, this.fileServerCapabilityIsHome, templateGUID, templateProperties);
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeGUID, isMergeUpdate, schemaTypeProperties);
    }

    public void removeSchemaType(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeGUID);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findSchemaType(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeForElement(this.userId, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeByGUID(this.userId, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeParent(this.userId, schemaTypeGUID);
    }

    public String createSchemaAttribute(String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createSchemaAttribute(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, this.fileServerCapabilityIsHome, schemaElementGUID, schemaAttributeProperties);
    }

    public String createSchemaAttributeFromTemplate(String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createSchemaAttributeFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, this.fileServerCapabilityIsHome, schemaElementGUID, templateGUID, templateProperties);
    }

    public void setupSchemaType(String schemaAttributeGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setupSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaAttributeGUID, schemaTypeGUID);
    }

    public void clearSchemaType(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaAttributeGUID);
    }

    public void updateSchemaAttribute(String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateSchemaAttribute(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaAttributeGUID, isMergeUpdate, schemaAttributeProperties);
    }

    public void removeSchemaAttribute(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeSchemaAttribute(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaAttributeGUID);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findSchemaAttributes(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getNestedAttributes(String parentSchemaElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getNestedAttributes(this.userId, parentSchemaElementGUID, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaAttributesByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaAttributeByGUID(this.userId, schemaAttributeGUID);
    }
}

