/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.files.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.FilesAndFoldersClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ArchiveProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class FilesIntegratorContext {
    private FilesAndFoldersClient client;
    private DataManagerEventClient eventClient;
    private String userId;
    private String fileServerCapabilityGUID;
    private String fileServerCapabilityName;

    public FilesIntegratorContext(FilesAndFoldersClient client, DataManagerEventClient eventClient, String userId, String fileServerCapabilityGUID, String fileServerCapabilityName) {
        this.client = client;
        this.eventClient = eventClient;
        this.userId = userId;
        this.fileServerCapabilityGUID = fileServerCapabilityGUID;
        this.fileServerCapabilityName = fileServerCapabilityName;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public List<String> createNestedFolders(String parentGUID, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createNestedFolders(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, parentGUID, pathName);
    }

    public void attachTopLevelFolder(String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.attachTopLevelFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, fileSystemGUID, folderGUID);
    }

    public void detachTopLevelFolder(String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.detachTopLevelFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, fileSystemGUID, folderGUID);
    }

    public List<String> addDataFileToCatalog(DataFileProperties dataFileProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.addDataFileToCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileProperties, connectorProviderName);
    }

    public List<String> addDataFileToCatalogFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.addDataFileToCatalogFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, templateGUID, templateProperties);
    }

    public void updateDataFileInCatalog(String dataFileGUID, boolean isMergeUpdate, DataFileProperties dataFileProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateDataFileInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileGUID, isMergeUpdate, dataFileProperties);
    }

    public void archiveDataFileInCatalog(String dataFileGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.archiveDataFileInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileGUID, archiveProperties);
    }

    public void deleteDataFileFromCatalog(String dataFileGUID, String fullPathname) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.deleteDataFileFromCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileGUID, fullPathname);
    }

    public List<String> addDataFolderToCatalog(FileFolderProperties fileFolderProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.addDataFolderToCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, fileFolderProperties, connectorProviderName);
    }

    public List<String> addDataFolderToCatalogFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.addDataFolderToCatalogFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, templateGUID, templateProperties);
    }

    public void updateDataFolderInCatalog(String dataFolderGUID, boolean isMergeUpdate, FileFolderProperties fileFolderProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateDataFolderInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFolderGUID, isMergeUpdate, fileFolderProperties);
    }

    public void archiveDataFolderInCatalog(String dataFolderGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.archiveDataFolderInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFolderGUID, archiveProperties);
    }

    public void attachDataFileAssetToFolder(String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.attachDataFileAssetToFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, folderGUID, fileGUID);
    }

    public void detachDataFileAssetFromFolder(String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.detachDataFileAssetFromFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, folderGUID, fileGUID);
    }

    public FileFolderElement getFolderByGUID(String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFolderByGUID(this.userId, folderGUID);
    }

    public FileFolderElement getFolderByPathName(String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFolderByPathName(this.userId, pathName);
    }

    public List<FileFolderElement> getTopLevelFolders(String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTopLevelFolders(this.userId, fileSystemGUID, startFrom, pageSize);
    }

    public List<FileFolderElement> getNestedFolders(String parentFolderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getNestedFolders(this.userId, parentFolderGUID, startFrom, pageSize);
    }

    public List<DataFileElement> getTopLevelDataFiles(String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTopLevelDataFiles(this.userId, fileSystemGUID, startFrom, pageSize);
    }

    public List<DataFileElement> getFolderFiles(String folderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFolderFiles(this.userId, folderGUID, startFrom, pageSize);
    }

    public DataFileElement getFileByGUID(String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFileByGUID(this.userId, fileGUID);
    }

    public DataFileElement getFileByPathName(String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFileByPathName(this.userId, pathName);
    }
}

