/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.files.connector;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.FilesAndFoldersClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ArchiveProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.StructSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

public class FilesIntegratorContext {
    private final ConnectionManagerClient connectionManagerClient;
    private final FilesAndFoldersClient filesAndFoldersClient;
    private final DataManagerEventClient eventClient;
    private final String userId;
    private final String fileServerCapabilityGUID;
    private final String fileServerCapabilityName;

    public FilesIntegratorContext(FilesAndFoldersClient filesAndFoldersClient, ConnectionManagerClient connectionManagerClient, DataManagerEventClient eventClient, String userId, String fileServerCapabilityGUID, String fileServerCapabilityName) {
        this.filesAndFoldersClient = filesAndFoldersClient;
        this.connectionManagerClient = connectionManagerClient;
        this.eventClient = eventClient;
        this.userId = userId;
        this.fileServerCapabilityGUID = fileServerCapabilityGUID;
        this.fileServerCapabilityName = fileServerCapabilityName;
    }

    public String getFileServerName() {
        return this.fileServerCapabilityName;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public List<String> createNestedFolders(String parentGUID, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createNestedFolders(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, parentGUID, pathName);
    }

    public void attachTopLevelFolder(String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.attachTopLevelFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, fileSystemGUID, folderGUID);
    }

    public void detachTopLevelFolder(String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.detachTopLevelFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, fileSystemGUID, folderGUID);
    }

    public List<String> addDataFileToCatalog(DataFileProperties dataFileProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.addDataFileToCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileProperties, connectorProviderName);
    }

    public List<String> addDataFileToCatalogFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.addDataFileToCatalogFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, templateGUID, templateProperties);
    }

    public void updateDataFileInCatalog(String dataFileGUID, boolean isMergeUpdate, DataFileProperties dataFileProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.updateDataFileInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileGUID, isMergeUpdate, dataFileProperties);
    }

    public void archiveDataFileInCatalog(String dataFileGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.archiveDataFileInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileGUID, archiveProperties);
    }

    public void deleteDataFileFromCatalog(String dataFileGUID, String fullPathname) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.deleteDataFileFromCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFileGUID, fullPathname);
    }

    public List<String> addDataFolderToCatalog(FileFolderProperties fileFolderProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.addDataFolderToCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, fileFolderProperties, connectorProviderName);
    }

    public List<String> addDataFolderToCatalogFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.addDataFolderToCatalogFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, templateGUID, templateProperties);
    }

    public void updateDataFolderInCatalog(String dataFolderGUID, boolean isMergeUpdate, FileFolderProperties fileFolderProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.updateDataFolderInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFolderGUID, isMergeUpdate, fileFolderProperties);
    }

    public void archiveDataFolderInCatalog(String dataFolderGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.archiveDataFolderInCatalog(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, dataFolderGUID, archiveProperties);
    }

    public void attachDataFileAssetToFolder(String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.attachDataFileAssetToFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, folderGUID, fileGUID);
    }

    public void detachDataFileAssetFromFolder(String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.detachDataFileAssetFromFolder(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, folderGUID, fileGUID);
    }

    public FileFolderElement getFolderByGUID(String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFolderByGUID(this.userId, folderGUID);
    }

    public FileFolderElement getFolderByPathName(String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFolderByPathName(this.userId, pathName);
    }

    public List<FileFolderElement> getTopLevelFolders(String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getTopLevelFolders(this.userId, fileSystemGUID, startFrom, pageSize);
    }

    public List<FileFolderElement> getNestedFolders(String parentFolderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getNestedFolders(this.userId, parentFolderGUID, startFrom, pageSize);
    }

    public List<DataFileElement> getTopLevelDataFiles(String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getTopLevelDataFiles(this.userId, fileSystemGUID, startFrom, pageSize);
    }

    public List<DataFileElement> getFolderFiles(String folderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFolderFiles(this.userId, folderGUID, startFrom, pageSize);
    }

    public DataFileElement getFileByGUID(String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFileByGUID(this.userId, fileGUID);
    }

    public DataFileElement getFileByPathName(String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFileByPathName(this.userId, pathName);
    }

    public String createPrimitiveSchemaType(PrimitiveSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createPrimitiveSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeProperties);
    }

    public String createLiteralSchemaType(LiteralSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createLiteralSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeProperties);
    }

    public String createEnumSchemaType(EnumSchemaTypeProperties schemaTypeProperties, String validValuesSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createEnumSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeProperties, validValuesSetGUID);
    }

    public List<ValidValueSetElement> getValidValueSetByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getValidValueSetByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueSetElement> findValidValueSet(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.findValidValueSet(this.userId, searchString, startFrom, pageSize);
    }

    public String createStructSchemaType(StructSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createStructSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeProperties);
    }

    public String createSchemaTypeChoice(SchemaTypeChoiceProperties schemaTypeProperties, List<String> schemaTypeOptionGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createSchemaTypeChoice(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeProperties, schemaTypeOptionGUIDs);
    }

    public String createMapSchemaType(MapSchemaTypeProperties schemaTypeProperties, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createMapSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
    }

    public String createSchemaTypeFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createSchemaTypeFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, templateGUID, templateProperties);
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.updateSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeGUID, isMergeUpdate, schemaTypeProperties);
    }

    public void removeSchemaType(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.removeSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaTypeGUID);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.findSchemaType(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaTypeForElement(this.userId, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaTypeByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaTypeByGUID(this.userId, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaTypeParent(this.userId, schemaTypeGUID);
    }

    public String createSchemaAttribute(String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createSchemaAttribute(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaElementGUID, schemaAttributeProperties);
    }

    public String createSchemaAttributeFromTemplate(String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.createSchemaAttributeFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaElementGUID, templateGUID, templateProperties);
    }

    public void setupSchemaType(String relationshipTypeName, String schemaAttributeGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.setupSchemaType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, relationshipTypeName, schemaAttributeGUID, schemaTypeGUID);
    }

    public void clearSchemaTypes(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.clearSchemaTypes(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaAttributeGUID);
    }

    public void updateSchemaAttribute(String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.updateSchemaAttribute(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaAttributeGUID, isMergeUpdate, schemaAttributeProperties);
    }

    public void removeSchemaAttribute(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.removeSchemaAttribute(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, schemaAttributeGUID);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.findSchemaAttributes(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getNestedAttributes(String parentSchemaElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getNestedAttributes(this.userId, parentSchemaElementGUID, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaAttributesByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaAttributeByGUID(this.userId, schemaAttributeGUID);
    }

    public String createConnection(ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createConnection(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, connectionProperties);
    }

    public String createConnectionFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createConnectionFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, templateGUID, templateProperties);
    }

    public void updateConnection(String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateConnection(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, connectionGUID, isMergeUpdate, connectionProperties);
    }

    public void setupConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupConnectorType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, connectionGUID, connectorTypeGUID);
    }

    public void clearConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearConnectorType(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, connectionGUID, connectorTypeGUID);
    }

    public void setupEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEndpoint(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, connectionGUID, endpointGUID);
    }

    public void clearEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEndpoint(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, connectionGUID, endpointGUID);
    }

    public void setupEmbeddedConnection(String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEmbeddedConnection(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, connectionGUID, position, displayName, arguments, embeddedConnectionGUID);
    }

    public void clearEmbeddedConnection(String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEmbeddedConnection(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, connectionGUID, embeddedConnectionGUID);
    }

    public void setupAssetConnection(String assetGUID, String assetSummary, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupAssetConnection(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, assetGUID, assetSummary, connectionGUID);
    }

    public void clearAssetConnection(String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearAssetConnection(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, assetGUID, connectionGUID);
    }

    public void removeConnection(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeConnection(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, connectionGUID);
    }

    public List<ConnectionElement> findConnections(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findConnections(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectionElement> getConnectionsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionsByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectionElement getConnectionByGUID(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionByGUID(this.userId, connectionGUID);
    }

    public String createEndpoint(EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createEndpoint(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, endpointProperties);
    }

    public String createEndpointFromTemplate(String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createEndpointFromTemplate(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, networkAddress, templateGUID, templateProperties);
    }

    public void updateEndpoint(boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateEndpoint(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, isMergeUpdate, endpointGUID, endpointProperties);
    }

    public void removeEndpoint(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeEndpoint(this.userId, this.fileServerCapabilityGUID, this.fileServerCapabilityName, endpointGUID);
    }

    public List<EndpointElement> findEndpoints(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findEndpoints(this.userId, searchString, startFrom, pageSize);
    }

    public List<EndpointElement> getEndpointsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointsByName(this.userId, name, startFrom, pageSize);
    }

    public EndpointElement getEndpointByGUID(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointByGUID(this.userId, endpointGUID);
    }

    public List<ConnectorTypeElement> findConnectorTypes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findConnectorTypes(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectorTypesByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectorTypeByGUID(this.userId, connectorTypeGUID);
    }
}

