/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.files.connector;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.FilesAndFoldersClient;
import org.odpi.openmetadata.accessservices.datamanager.client.ValidValueManagement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ArchiveProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.StructSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ValidValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ValidValueMembershipProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ValidValueProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;

public class FilesIntegratorContext
extends IntegrationContext {
    private final ConnectionManagerClient connectionManagerClient;
    private final FilesAndFoldersClient filesAndFoldersClient;
    private final DataManagerEventClient eventClient;
    private final ValidValueManagement validValueManagement;

    public FilesIntegratorContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, OpenMetadataClient openMetadataStoreClient, FilesAndFoldersClient filesAndFoldersClient, ConnectionManagerClient connectionManagerClient, ValidValueManagement validValueManagement, DataManagerEventClient eventClient, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String integrationConnectorGUID, String externalSourceGUID, String externalSourceName, int maxPageSize) {
        super(connectorId, connectorName, connectorUserId, serverName, openIntegrationClient, openMetadataStoreClient, generateIntegrationReport, permittedSynchronization, externalSourceGUID, externalSourceName, integrationConnectorGUID, maxPageSize);
        this.filesAndFoldersClient = filesAndFoldersClient;
        this.connectionManagerClient = connectionManagerClient;
        this.validValueManagement = validValueManagement;
        this.eventClient = eventClient;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public List<String> createNestedFolders(String parentGUID, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List nestedFolderGUIDs = this.filesAndFoldersClient.createNestedFolders(this.userId, this.externalSourceGUID, this.externalSourceName, parentGUID, pathName);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(parentGUID, parentGUID);
            this.integrationReportWriter.reportElementUpdate(parentGUID);
            if (nestedFolderGUIDs != null && nestedFolderGUIDs.size() > 0) {
                for (String folderGUID : nestedFolderGUIDs) {
                    this.integrationReportWriter.setAnchor(folderGUID, folderGUID);
                    this.integrationReportWriter.reportElementCreation(folderGUID);
                }
            }
        }
        return nestedFolderGUIDs;
    }

    public void attachTopLevelFolder(String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.attachTopLevelFolder(this.userId, this.externalSourceGUID, this.externalSourceName, fileSystemGUID, folderGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(folderGUID, folderGUID);
            this.integrationReportWriter.setAnchor(fileSystemGUID, fileSystemGUID);
            this.integrationReportWriter.reportElementUpdate(fileSystemGUID);
            this.integrationReportWriter.reportElementUpdate(folderGUID);
        }
    }

    public void detachTopLevelFolder(String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.detachTopLevelFolder(this.userId, this.externalSourceGUID, this.externalSourceName, fileSystemGUID, folderGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(folderGUID, folderGUID);
            this.integrationReportWriter.setAnchor(fileSystemGUID, fileSystemGUID);
            this.integrationReportWriter.reportElementUpdate(fileSystemGUID);
            this.integrationReportWriter.reportElementUpdate(folderGUID);
        }
    }

    public List<String> addDataFileToCatalog(DataFileProperties dataFileProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List nestedFolderGUIDs = this.filesAndFoldersClient.addDataFileToCatalog(this.userId, this.externalSourceGUID, this.externalSourceName, dataFileProperties, connectorProviderName);
        if (nestedFolderGUIDs != null && nestedFolderGUIDs.size() > 0 && this.integrationReportWriter != null) {
            for (String folderGUID : nestedFolderGUIDs) {
                this.integrationReportWriter.setAnchor(folderGUID, folderGUID);
                this.integrationReportWriter.reportElementCreation(folderGUID);
            }
        }
        return nestedFolderGUIDs;
    }

    public List<String> addDataFileToCatalogFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List nestedFolderGUIDs = this.filesAndFoldersClient.addDataFileToCatalogFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, templateGUID, templateProperties);
        if (nestedFolderGUIDs != null && nestedFolderGUIDs.size() > 0 && this.integrationReportWriter != null) {
            for (String folderGUID : nestedFolderGUIDs) {
                this.integrationReportWriter.setAnchor(folderGUID, folderGUID);
                this.integrationReportWriter.reportElementCreation(folderGUID);
            }
        }
        return nestedFolderGUIDs;
    }

    public void updateDataFileInCatalog(String dataFileGUID, boolean isMergeUpdate, DataFileProperties dataFileProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.updateDataFileInCatalog(this.userId, this.externalSourceGUID, this.externalSourceName, dataFileGUID, isMergeUpdate, dataFileProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(dataFileGUID, dataFileGUID);
            this.integrationReportWriter.reportElementUpdate(dataFileGUID);
        }
    }

    public void archiveDataFileInCatalog(String dataFileGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.archiveDataFileInCatalog(this.userId, this.externalSourceGUID, this.externalSourceName, dataFileGUID, archiveProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(dataFileGUID, dataFileGUID);
            this.integrationReportWriter.reportElementDelete(dataFileGUID);
        }
    }

    public void deleteDataFileFromCatalog(String dataFileGUID, String fullPathname) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.deleteDataFileFromCatalog(this.userId, this.externalSourceGUID, this.externalSourceName, dataFileGUID, fullPathname);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(dataFileGUID, dataFileGUID);
            this.integrationReportWriter.reportElementDelete(dataFileGUID);
        }
    }

    public List<String> addDataFolderToCatalog(FileFolderProperties fileFolderProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List nestedFolderGUIDs = this.filesAndFoldersClient.addDataFolderToCatalog(this.userId, this.externalSourceGUID, this.externalSourceName, fileFolderProperties, connectorProviderName);
        if (nestedFolderGUIDs != null && nestedFolderGUIDs.size() > 0 && this.integrationReportWriter != null) {
            for (String folderGUID : nestedFolderGUIDs) {
                this.integrationReportWriter.setAnchor(folderGUID, folderGUID);
                this.integrationReportWriter.reportElementCreation(folderGUID);
            }
        }
        return nestedFolderGUIDs;
    }

    public List<String> addDataFolderToCatalogFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List nestedFolderGUIDs = this.filesAndFoldersClient.addDataFolderToCatalogFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, templateGUID, templateProperties);
        if (nestedFolderGUIDs != null && nestedFolderGUIDs.size() > 0 && this.integrationReportWriter != null) {
            for (String folderGUID : nestedFolderGUIDs) {
                this.integrationReportWriter.setAnchor(folderGUID, folderGUID);
                this.integrationReportWriter.reportElementCreation(folderGUID);
            }
        }
        return nestedFolderGUIDs;
    }

    public void updateDataFolderInCatalog(String dataFolderGUID, boolean isMergeUpdate, FileFolderProperties fileFolderProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.updateDataFolderInCatalog(this.userId, this.externalSourceGUID, this.externalSourceName, dataFolderGUID, isMergeUpdate, fileFolderProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(dataFolderGUID, dataFolderGUID);
            this.integrationReportWriter.reportElementUpdate(dataFolderGUID);
        }
    }

    public void archiveDataFolderInCatalog(String dataFolderGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.archiveDataFolderInCatalog(this.userId, this.externalSourceGUID, this.externalSourceName, dataFolderGUID, archiveProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(dataFolderGUID, dataFolderGUID);
            this.integrationReportWriter.reportElementDelete(dataFolderGUID);
        }
    }

    public void attachDataFileAssetToFolder(String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.attachDataFileAssetToFolder(this.userId, this.externalSourceGUID, this.externalSourceName, folderGUID, fileGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(folderGUID, folderGUID);
            this.integrationReportWriter.reportElementUpdate(folderGUID);
            this.integrationReportWriter.setAnchor(fileGUID, fileGUID);
            this.integrationReportWriter.reportElementUpdate(fileGUID);
        }
    }

    public void detachDataFileAssetFromFolder(String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.detachDataFileAssetFromFolder(this.userId, this.externalSourceGUID, this.externalSourceName, folderGUID, fileGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(folderGUID, folderGUID);
            this.integrationReportWriter.reportElementUpdate(folderGUID);
            this.integrationReportWriter.setAnchor(fileGUID, fileGUID);
            this.integrationReportWriter.reportElementUpdate(fileGUID);
        }
    }

    public FileFolderElement getFolderByGUID(String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFolderByGUID(this.userId, folderGUID);
    }

    public FileFolderElement getFolderByPathName(String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFolderByPathName(this.userId, pathName);
    }

    public List<FileFolderElement> getTopLevelFolders(String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getTopLevelFolders(this.userId, fileSystemGUID, startFrom, pageSize);
    }

    public List<FileFolderElement> getNestedFolders(String parentFolderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getNestedFolders(this.userId, parentFolderGUID, startFrom, pageSize);
    }

    public List<DataFileElement> getTopLevelDataFiles(String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getTopLevelDataFiles(this.userId, fileSystemGUID, startFrom, pageSize);
    }

    public List<DataFileElement> getFolderFiles(String folderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFolderFiles(this.userId, folderGUID, startFrom, pageSize);
    }

    public DataFileElement getFileByGUID(String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFileByGUID(this.userId, fileGUID);
    }

    public DataFileElement getFileByPathName(String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getFileByPathName(this.userId, pathName);
    }

    public String createPrimitiveSchemaType(PrimitiveSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.filesAndFoldersClient.createPrimitiveSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties) : this.filesAndFoldersClient.createPrimitiveSchemaType(this.userId, null, null, schemaTypeProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createLiteralSchemaType(LiteralSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.filesAndFoldersClient.createLiteralSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties) : this.filesAndFoldersClient.createLiteralSchemaType(this.userId, null, null, schemaTypeProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createEnumSchemaType(EnumSchemaTypeProperties schemaTypeProperties, String validValuesSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.filesAndFoldersClient.createEnumSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties, validValuesSetGUID) : this.filesAndFoldersClient.createEnumSchemaType(this.userId, null, null, schemaTypeProperties, validValuesSetGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public List<ValidValueSetElement> getValidValueSetByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getValidValueSetByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueSetElement> findValidValueSet(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.findValidValueSet(this.userId, searchString, startFrom, pageSize);
    }

    public String createStructSchemaType(StructSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.filesAndFoldersClient.createStructSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties) : this.filesAndFoldersClient.createStructSchemaType(this.userId, null, null, schemaTypeProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createSchemaTypeChoice(SchemaTypeChoiceProperties schemaTypeProperties, List<String> schemaTypeOptionGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.filesAndFoldersClient.createSchemaTypeChoice(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties, schemaTypeOptionGUIDs) : this.filesAndFoldersClient.createSchemaTypeChoice(this.userId, null, null, schemaTypeProperties, schemaTypeOptionGUIDs);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createMapSchemaType(MapSchemaTypeProperties schemaTypeProperties, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.filesAndFoldersClient.createMapSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID) : this.filesAndFoldersClient.createMapSchemaType(this.userId, null, null, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createSchemaTypeFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.filesAndFoldersClient.createSchemaTypeFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, templateGUID, templateProperties) : this.filesAndFoldersClient.createSchemaTypeFromTemplate(this.userId, null, null, templateGUID, templateProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.updateSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeGUID, isMergeUpdate, schemaTypeProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(schemaTypeGUID);
        }
    }

    public void removeSchemaType(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.removeSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(schemaTypeGUID);
        }
    }

    public void setupSchemaElementRelationship(String endOneGUID, String endTwoGUID, String relationshipTypeName, RelationshipProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.setupSchemaElementRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, endOneGUID, endTwoGUID, relationshipTypeName, properties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(endTwoGUID, endOneGUID);
            this.integrationReportWriter.reportElementUpdate(endOneGUID);
        }
    }

    public void clearSchemaElementRelationship(String endOneGUID, String endTwoGUID, String relationshipTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.clearSchemaElementRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, endOneGUID, endTwoGUID, relationshipTypeName);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.findSchemaType(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaTypeForElement(this.userId, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaTypeByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaTypeByGUID(this.userId, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaTypeParent(this.userId, schemaTypeGUID);
    }

    public String createSchemaAttribute(String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaAttributeGUID = this.externalSourceIsHome ? this.filesAndFoldersClient.createSchemaAttribute(this.userId, this.externalSourceGUID, this.externalSourceName, schemaElementGUID, schemaAttributeProperties) : this.filesAndFoldersClient.createSchemaAttribute(this.userId, null, null, schemaElementGUID, schemaAttributeProperties);
        if (schemaAttributeGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaElementGUID);
        }
        return schemaAttributeGUID;
    }

    public String createSchemaAttributeFromTemplate(String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaAttributeGUID = this.externalSourceIsHome ? this.filesAndFoldersClient.createSchemaAttributeFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, schemaElementGUID, templateGUID, templateProperties) : this.filesAndFoldersClient.createSchemaAttributeFromTemplate(this.userId, null, null, schemaElementGUID, templateGUID, templateProperties);
        if (schemaAttributeGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaElementGUID);
        }
        return schemaAttributeGUID;
    }

    public void setupSchemaType(String relationshipTypeName, String schemaAttributeGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.externalSourceIsHome) {
            this.filesAndFoldersClient.setupSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipTypeName, schemaAttributeGUID, schemaTypeGUID);
        } else {
            this.filesAndFoldersClient.setupSchemaType(this.userId, null, null, relationshipTypeName, schemaAttributeGUID, schemaTypeGUID);
        }
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(schemaTypeGUID, schemaAttributeGUID);
        }
    }

    public void clearSchemaTypes(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.clearSchemaTypes(this.userId, this.externalSourceGUID, this.externalSourceName, schemaAttributeGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(schemaAttributeGUID);
        }
    }

    public void updateSchemaAttribute(String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.updateSchemaAttribute(this.userId, this.externalSourceGUID, this.externalSourceName, schemaAttributeGUID, isMergeUpdate, schemaAttributeProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(schemaAttributeGUID);
        }
    }

    public void removeSchemaAttribute(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.filesAndFoldersClient.removeSchemaAttribute(this.userId, this.externalSourceGUID, this.externalSourceName, schemaAttributeGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(schemaAttributeGUID);
        }
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.findSchemaAttributes(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getNestedAttributes(String parentSchemaElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getNestedAttributes(this.userId, parentSchemaElementGUID, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaAttributesByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.filesAndFoldersClient.getSchemaAttributeByGUID(this.userId, schemaAttributeGUID);
    }

    public String createConnection(ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUID = this.connectionManagerClient.createConnection(this.userId, null, null, connectionProperties);
        if (connectionGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(connectionGUID);
        }
        return connectionGUID;
    }

    public String createConnectionFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUID = this.connectionManagerClient.createConnectionFromTemplate(this.userId, null, null, templateGUID, templateProperties);
        if (connectionGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(connectionGUID);
        }
        return connectionGUID;
    }

    public void updateConnection(String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, isMergeUpdate, connectionProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(connectionGUID);
        }
    }

    public void setupConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupConnectorType(this.userId, null, null, connectionGUID, connectorTypeGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(connectionGUID);
        }
    }

    public void clearConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, connectorTypeGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(connectionGUID);
        }
    }

    public void setupEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEndpoint(this.userId, null, null, connectionGUID, endpointGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(connectionGUID);
        }
    }

    public void clearEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, endpointGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(connectionGUID);
        }
    }

    public void setupEmbeddedConnection(String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEmbeddedConnection(this.userId, null, null, connectionGUID, position, displayName, arguments, embeddedConnectionGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(embeddedConnectionGUID, connectionGUID);
            this.integrationReportWriter.reportElementUpdate(embeddedConnectionGUID);
        }
    }

    public void clearEmbeddedConnection(String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEmbeddedConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, embeddedConnectionGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(embeddedConnectionGUID, connectionGUID);
            this.integrationReportWriter.reportElementUpdate(embeddedConnectionGUID);
        }
    }

    public void setupAssetConnection(String assetGUID, String assetSummary, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupAssetConnection(this.userId, null, null, assetGUID, assetSummary, connectionGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(connectionGUID, assetGUID);
            this.integrationReportWriter.reportElementUpdate(connectionGUID);
        }
    }

    public void clearAssetConnection(String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearAssetConnection(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, connectionGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(connectionGUID, assetGUID);
            this.integrationReportWriter.reportElementUpdate(connectionGUID);
        }
    }

    public void removeConnection(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID);
    }

    public List<ConnectionElement> findConnections(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findConnections(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectionElement> getConnectionsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionsByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectionElement getConnectionByGUID(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionByGUID(this.userId, connectionGUID);
    }

    public String createEndpoint(EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointGUID = this.connectionManagerClient.createEndpoint(this.userId, null, null, endpointProperties);
        if (endpointGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(endpointGUID);
        }
        return endpointGUID;
    }

    public String createEndpointFromTemplate(String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointGUID = this.connectionManagerClient.createEndpointFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, networkAddress, templateGUID, templateProperties);
        if (endpointGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(endpointGUID);
        }
        return endpointGUID;
    }

    public void updateEndpoint(boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, isMergeUpdate, endpointGUID, endpointProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(endpointGUID);
        }
    }

    public void removeEndpoint(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, endpointGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(endpointGUID);
        }
    }

    public List<EndpointElement> findEndpoints(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findEndpoints(this.userId, searchString, startFrom, pageSize);
    }

    public List<EndpointElement> getEndpointsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointsByName(this.userId, name, startFrom, pageSize);
    }

    public EndpointElement getEndpointByGUID(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointByGUID(this.userId, endpointGUID);
    }

    public List<ConnectorTypeElement> findConnectorTypes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findConnectorTypes(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectorTypesByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectorTypeByGUID(this.userId, connectorTypeGUID);
    }

    public String createValidValue(ValidValueProperties validValueProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUID = this.validValueManagement.createValidValue(this.userId, this.externalSourceGUID, this.externalSourceName, validValueProperties);
        if (validValueGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(validValueGUID);
        }
        return validValueGUID;
    }

    public void updateValidValue(String validValueGUID, boolean isMergeUpdate, ValidValueProperties validValueProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.updateValidValue(this.userId, this.externalSourceGUID, this.externalSourceName, validValueGUID, isMergeUpdate, validValueProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(validValueGUID);
        }
    }

    public void setupValidValueMember(String validValueSetGUID, ValidValueMembershipProperties properties, String validValueMemberGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.setupValidValueMember(this.userId, this.externalSourceGUID, this.externalSourceName, validValueSetGUID, properties, validValueMemberGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(validValueMemberGUID, validValueSetGUID);
            this.integrationReportWriter.reportElementUpdate(validValueSetGUID);
        }
    }

    public void clearValidValueMember(String validValueSetGUID, String validValueMemberGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.clearValidValueMember(this.userId, this.externalSourceGUID, this.externalSourceName, validValueSetGUID, validValueMemberGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(validValueMemberGUID, validValueSetGUID);
            this.integrationReportWriter.reportElementUpdate(validValueSetGUID);
        }
    }

    public void setupValidValues(String elementGUID, ValidValueAssignmentProperties properties, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.setupValidValues(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, properties, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    public void clearValidValues(String elementGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.clearValidValues(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    public void setupReferenceValueTag(String elementGUID, ReferenceValueAssignmentProperties properties, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.setupReferenceValueTag(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, properties, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    public void clearReferenceValueTag(String elementGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.clearReferenceValueTag(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    public void removeValidValue(String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.removeValidValue(this.userId, this.externalSourceGUID, this.externalSourceName, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(validValueGUID);
        }
    }

    public List<ValidValueElement> findValidValues(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.findValidValues(this.userId, searchString, startFrom, pageSize);
    }

    public List<ValidValueElement> getValidValuesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getValidValuesByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueElement> getAllValidValues(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getAllValidValues(this.userId, startFrom, pageSize);
    }

    public List<ValidValueElement> getValidValueSetMembers(String validValueSetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getValidValueSetMembers(this.userId, validValueSetGUID, startFrom, pageSize);
    }

    public List<ValidValueElement> getSetsForValidValue(String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getSetsForValidValue(this.userId, validValueGUID, startFrom, pageSize);
    }

    public ValidValueElement getValidValuesForConsumer(String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getValidValuesForConsumer(this.userId, elementGUID);
    }

    public List<RelatedElement> getConsumersOfValidValue(String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getConsumersOfValidValue(this.userId, validValueGUID, startFrom, pageSize);
    }

    public List<ValidValueElement> getReferenceValues(String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getReferenceValues(this.userId, elementGUID, startFrom, pageSize);
    }

    public List<RelatedElement> getAssigneesOfReferenceValue(String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getAssigneesOfReferenceValue(this.userId, validValueGUID, startFrom, pageSize);
    }

    public ValidValueElement getValidValueByGUID(String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getValidValueByGUID(this.userId, validValueGUID);
    }
}

