/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.fvt.utilities;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecord;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class FVTResults {
    private String testCaseName = null;
    private int numberOfTests = 0;
    private int numberOfSuccesses = 0;
    private List<Exception> capturedErrors = new ArrayList<Exception>();
    private FVTAuditLogDestination auditLogDestination = new FVTAuditLogDestination();

    public FVTResults(String testCaseName) {
        this.testCaseName = testCaseName;
    }

    public synchronized void incrementNumberOfTests() {
        ++this.numberOfTests;
    }

    public synchronized void incrementNumberOfSuccesses() {
        ++this.numberOfSuccesses;
    }

    public synchronized void addCapturedError(Exception exception) {
        this.capturedErrors.add(exception);
    }

    public synchronized int getNumberOfTests() {
        return this.numberOfTests;
    }

    public synchronized int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public synchronized List<Exception> getCapturedErrors() {
        return this.capturedErrors;
    }

    public synchronized FVTAuditLogDestination getAuditLogDestination() {
        return this.auditLogDestination;
    }

    public synchronized boolean isSuccessful() {
        return this.numberOfTests == this.numberOfSuccesses;
    }

    public synchronized void printResults() {
        System.out.println("==========================================");
        if (this.isSuccessful() && this.capturedErrors.isEmpty()) {
            System.out.println(this.testCaseName + " FVT ran successfully");
        } else {
            int numberOfFailedTests = this.numberOfTests - this.numberOfSuccesses;
            System.out.println(this.testCaseName + " FVT failed");
            System.out.println("Number of Failed tests: " + numberOfFailedTests);
            System.out.println("Captured Exceptions: " + this.capturedErrors.size());
            for (Exception exception : this.capturedErrors) {
                System.out.println(" ==> " + exception.getClass().getName() + " with message " + exception.getMessage());
                System.out.println(exception.toString());
                exception.printStackTrace();
            }
        }
        System.out.println("Captured AuditLog");
        int recordId = 0;
        for (AuditLogRecord logRecord : this.auditLogDestination.getAuditLogRecords()) {
            System.out.println("_______________________________________________________________");
            System.out.println("[" + recordId + "] " + logRecord.toString());
            System.out.println("_______________________________________________________________");
        }
    }
}

