/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.fvt.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;

public abstract class FVTSuiteBase {
    static String fvtSuiteClassName = null;

    public static void main(String[] args) {
        int exitCode;
        try {
            String url = FVTSuiteBase.getUrl(args);
            String serverName = FVTSuiteBase.getServerName(args);
            String userId = FVTSuiteBase.getUserId(args);
            Class<?> fvtSuiteClass = Class.forName(fvtSuiteClassName);
            FVTSuiteBase fvtSuite = (FVTSuiteBase)fvtSuiteClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            exitCode = fvtSuite.performFVT(url, serverName, userId);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            System.out.println("Invalid FVTSuite class: " + fvtSuiteClassName);
            error.printStackTrace();
            exitCode = -99;
        }
        catch (IOException error) {
            System.out.println("Error getting user input");
            error.printStackTrace();
            exitCode = -99;
        }
        System.exit(exitCode);
    }

    protected abstract int performFVT(String var1, String var2, String var3);

    private static String getServerName(String[] args) throws IOException {
        String name;
        if (args.length > 1) {
            name = args[1];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a OMAG Server Name. Press enter to get the default (fvtMDS)) :");
            name = br.readLine();
            if (name.equals("")) {
                name = "fvtMDS";
            }
        }
        return name;
    }

    private static String getUserId(String[] args) throws IOException {
        String userId;
        if (args.length > 2) {
            userId = args[2];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a userId. Press enter to get the default (testUser)) :");
            userId = br.readLine();
            if (userId.equals("")) {
                userId = "testUser";
            }
        }
        return userId;
    }

    private static String getUrl(String[] args) throws IOException {
        String url;
        if (args.length > 0) {
            url = args[0];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a URL. Press enter to get the default (https://localhost:9443.)) :");
            url = br.readLine();
            if (url.equals("")) {
                url = "https://localhost:9443";
            }
        }
        return url;
    }
}

