/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.gaf.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum OpenMetadataStoreAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OPEN-METADATA-STORE-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Open Metadata Store Services are initializing a new server instance", "The local server has started up a new instance of the Open Metadata Store Services.  It will support open metadata store REST requests.", "This is part of the normal start up of the service.  No action is required if this service startup was intentional."),
    SERVICE_INITIALIZED("OPEN-METADATA-STORE-0005", OMRSAuditLogRecordSeverity.STARTUP, "The Open Metadata Store Services has initialized a new instance for server {0}", "The Open Metadata Store Services has completed initialization of a new server instance.", "Verify that there are no error messages logged by the service.  If there are none it means that all parts of the service initialized successfully."),
    SERVICE_INSTANCE_FAILURE("OPEN-METADATA-STORE-0006", OMRSAuditLogRecordSeverity.ERROR, "The Open Metadata Store Services are unable to initialize a new instance; error message is {0}", "The service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    UNEXPECTED_INITIALIZATION_EXCEPTION("OPEN-METADATA-STORE-0008", OMRSAuditLogRecordSeverity.EXCEPTION, "The Open Metadata Store Services detected an unexpected {0} exception during the initialization of its services; error message is {1}", "The service detected an error during the start up of a specific server instance.  Its services are not available for the server and an error is returned to the caller.", "Review the error message and any other reported failures to determine the cause of the problem.  In particular consider the state of the Event Bus.  Once this is resolved, restart the server."),
    SERVICE_TERMINATING("OPEN-METADATA-STORE-0009", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Open Metadata Store Services are shutting down server instance {0}", "The local handlers has requested shut down of the Open Metadata Store Services.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OPEN-METADATA-STORE-0012", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Open Metadata Store Services are shutting down its instance for server {0}", "The local administrator has requested shut down of an Open Metadata Store Services instance.  The open metadata store interfaces are no longer available and no configuration events will be published to the out topic", "This is part of the normal shutdown of the service.  Verify that all resources have been released."),
    ASSET_AUDIT_LOG("OPEN-METADATA-STORE-0020", OMRSAuditLogRecordSeverity.INFO, "Log message for asset {0} from governance service {1}: {2}", "A governance service has logged a message about an asset.", "Review the message to ensure no action is required.");

    private final AuditLogMessageDefinition messageDefinition;

    private OpenMetadataStoreAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "OpenMetadataStoreAuditCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

