/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworkservices.gaf.rest.StewardshipRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConsolidatedDuplicatesRequestBody
extends StewardshipRequestBody {
    private String consolidatedElementGUID = null;
    private List<String> sourceElementGUIDs = null;

    public ConsolidatedDuplicatesRequestBody() {
    }

    public ConsolidatedDuplicatesRequestBody(ConsolidatedDuplicatesRequestBody template) {
        super(template);
        if (template != null) {
            this.consolidatedElementGUID = template.getConsolidatedElementGUID();
            this.sourceElementGUIDs = template.getSourceElementGUIDs();
        }
    }

    public String getConsolidatedElementGUID() {
        return this.consolidatedElementGUID;
    }

    public void setConsolidatedElementGUID(String consolidatedElementGUID) {
        this.consolidatedElementGUID = consolidatedElementGUID;
    }

    public List<String> getSourceElementGUIDs() {
        return this.sourceElementGUIDs;
    }

    public void setSourceElementGUIDs(List<String> sourceElementGUIDs) {
        this.sourceElementGUIDs = sourceElementGUIDs;
    }

    @Override
    public String toString() {
        return "ConsolidatedDuplicatesRequestBody{consolidatedElementGUID='" + this.consolidatedElementGUID + "', sourceElementGUIDs=" + this.sourceElementGUIDs + ", statusIdentifier=" + this.getStatusIdentifier() + ", steward='" + this.getSteward() + "', stewardTypeName='" + this.getStewardTypeName() + "', stewardPropertyName='" + this.getStewardPropertyName() + "', source='" + this.getSource() + "', notes='" + this.getNotes() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ConsolidatedDuplicatesRequestBody that = (ConsolidatedDuplicatesRequestBody)objectToCompare;
        return Objects.equals(this.consolidatedElementGUID, that.consolidatedElementGUID) && Objects.equals(this.sourceElementGUIDs, that.sourceElementGUIDs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.consolidatedElementGUID, this.sourceElementGUIDs);
    }
}

