/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDef;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OMAGGAFAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AttributeTypeDefListResponse
extends OMAGGAFAPIResponse {
    private List<OpenMetadataAttributeTypeDef> attributeTypeDefs = null;

    public AttributeTypeDefListResponse() {
    }

    public AttributeTypeDefListResponse(AttributeTypeDefListResponse template) {
        super(template);
        if (template != null) {
            this.attributeTypeDefs = template.getAttributeTypeDefs();
        }
    }

    public List<OpenMetadataAttributeTypeDef> getAttributeTypeDefs() {
        if (this.attributeTypeDefs == null) {
            return null;
        }
        if (this.attributeTypeDefs.isEmpty()) {
            return null;
        }
        ArrayList<OpenMetadataAttributeTypeDef> clonedTypeDefs = new ArrayList<OpenMetadataAttributeTypeDef>();
        for (OpenMetadataAttributeTypeDef attributeTypeDef : this.attributeTypeDefs) {
            clonedTypeDefs.add(attributeTypeDef.cloneFromSubclass());
        }
        return clonedTypeDefs;
    }

    public void setAttributeTypeDefs(List<OpenMetadataAttributeTypeDef> attributeTypeDefs) {
        this.attributeTypeDefs = attributeTypeDefs;
    }

    @Override
    public String toString() {
        return "AttributeTypeDefListResponse{attributeTypeDefs=" + this.attributeTypeDefs + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AttributeTypeDefListResponse)) {
            return false;
        }
        AttributeTypeDefListResponse that = (AttributeTypeDefListResponse)((Object)objectToCompare);
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return Objects.equals(this.getAttributeTypeDefs(), that.getAttributeTypeDefs());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAttributeTypeDefs());
    }
}

