/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworkservices.gaf.rest.MetadataSourceRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateRequestBody
extends MetadataSourceRequestBody {
    private String typeName = null;
    private ElementStatus initialStatus = null;
    private Map<String, ElementProperties> initialClassifications = null;
    private String anchorGUID = null;
    private boolean isOwnAnchor = false;
    private boolean allowRetrieve = false;
    private Date effectiveFrom = null;
    private Date effectiveTo = null;
    private String templateGUID = null;
    private ElementProperties replacementProperties = null;
    private Map<String, String> placeholderPropertyValues = null;
    private String parentGUID = null;
    private String parentRelationshipTypeName = null;
    private ElementProperties parentRelationshipProperties = null;
    private boolean parentAtEnd1 = true;
    private Date effectiveTime = null;

    public TemplateRequestBody() {
    }

    public TemplateRequestBody(TemplateRequestBody template) {
        super(template);
        if (template != null) {
            this.typeName = template.getTypeName();
            this.initialStatus = template.getInitialStatus();
            this.initialClassifications = template.getInitialClassifications();
            this.anchorGUID = template.getAnchorGUID();
            this.isOwnAnchor = template.getIsOwnAnchor();
            this.allowRetrieve = template.getAllowRetrieve();
            this.effectiveFrom = template.getEffectiveFrom();
            this.effectiveTo = template.getEffectiveTo();
            this.replacementProperties = template.getReplacementProperties();
            this.templateGUID = template.getTemplateGUID();
            this.parentGUID = template.getParentGUID();
            this.placeholderPropertyValues = template.getPlaceholderPropertyValues();
            this.parentRelationshipTypeName = template.getParentRelationshipTypeName();
            this.parentRelationshipProperties = template.getParentRelationshipProperties();
            this.parentAtEnd1 = template.getParentAtEnd1();
            this.effectiveTime = template.getEffectiveTime();
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public ElementStatus getInitialStatus() {
        return this.initialStatus;
    }

    public Map<String, ElementProperties> getInitialClassifications() {
        return this.initialClassifications;
    }

    public void setInitialClassifications(Map<String, ElementProperties> initialClassifications) {
        this.initialClassifications = initialClassifications;
    }

    public String getAnchorGUID() {
        return this.anchorGUID;
    }

    public void setAnchorGUID(String anchorGUID) {
        this.anchorGUID = anchorGUID;
    }

    public boolean getIsOwnAnchor() {
        return this.isOwnAnchor;
    }

    public void setIsOwnAnchor(boolean ownAnchor) {
        this.isOwnAnchor = ownAnchor;
    }

    public boolean getAllowRetrieve() {
        return this.allowRetrieve;
    }

    public void setAllowRetrieve(boolean allowRetrieve) {
        this.allowRetrieve = allowRetrieve;
    }

    public void setInitialStatus(ElementStatus initialStatus) {
        this.initialStatus = initialStatus;
    }

    public Date getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public Date getEffectiveTo() {
        return this.effectiveTo;
    }

    public void setEffectiveTo(Date effectiveTo) {
        this.effectiveTo = effectiveTo;
    }

    public ElementProperties getReplacementProperties() {
        return this.replacementProperties;
    }

    public void setReplacementProperties(ElementProperties templateProperties) {
        this.replacementProperties = templateProperties;
    }

    public void setTemplateGUID(String templateGUID) {
        this.templateGUID = templateGUID;
    }

    public String getTemplateGUID() {
        return this.templateGUID;
    }

    public Map<String, String> getPlaceholderPropertyValues() {
        return this.placeholderPropertyValues;
    }

    public void setPlaceholderPropertyValues(Map<String, String> placeholderPropertyValues) {
        this.placeholderPropertyValues = placeholderPropertyValues;
    }

    public String getParentGUID() {
        return this.parentGUID;
    }

    public void setParentGUID(String parentGUID) {
        this.parentGUID = parentGUID;
    }

    public String getParentRelationshipTypeName() {
        return this.parentRelationshipTypeName;
    }

    public void setParentRelationshipTypeName(String parentRelationshipTypeName) {
        this.parentRelationshipTypeName = parentRelationshipTypeName;
    }

    public ElementProperties getParentRelationshipProperties() {
        return this.parentRelationshipProperties;
    }

    public void setParentRelationshipProperties(ElementProperties parentRelationshipProperties) {
        this.parentRelationshipProperties = parentRelationshipProperties;
    }

    public boolean getParentAtEnd1() {
        return this.parentAtEnd1;
    }

    public void setParentAtEnd1(boolean parentAtEnd1) {
        this.parentAtEnd1 = parentAtEnd1;
    }

    public Date getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    @Override
    public String toString() {
        return "NewOpenMetadataElementRequestBody{typeName='" + this.typeName + "', initialStatus=" + this.initialStatus + ", initialClassifications=" + this.initialClassifications + ", anchorGUID='" + this.anchorGUID + "', isOwnAnchor='" + this.isOwnAnchor + "', effectiveFrom=" + this.effectiveFrom + ", effectiveTo=" + this.effectiveTo + ", templateGUID='" + this.templateGUID + "', replacementProperties=" + this.replacementProperties + ", placeholderProperties=" + this.placeholderPropertyValues + ", parentGUID='" + this.parentGUID + "', parentRelationshipTypeName='" + this.parentRelationshipTypeName + "', parentRelationshipProperties=" + this.parentRelationshipProperties + ", parentAtEnd1=" + this.parentAtEnd1 + ", effectiveTime=" + this.effectiveTime + ", externalSourceGUID='" + this.getExternalSourceGUID() + "', externalSourceName='" + this.getExternalSourceName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof TemplateRequestBody)) {
            return false;
        }
        TemplateRequestBody that = (TemplateRequestBody)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return this.parentAtEnd1 == that.parentAtEnd1 && this.isOwnAnchor == that.isOwnAnchor && Objects.equals(this.typeName, that.typeName) && this.initialStatus == that.initialStatus && Objects.equals(this.initialClassifications, that.initialClassifications) && Objects.equals(this.anchorGUID, that.anchorGUID) && Objects.equals(this.effectiveFrom, that.effectiveFrom) && Objects.equals(this.effectiveTo, that.effectiveTo) && Objects.equals(this.replacementProperties, that.replacementProperties) && Objects.equals(this.placeholderPropertyValues, that.placeholderPropertyValues) && Objects.equals(this.templateGUID, that.templateGUID) && Objects.equals(this.parentGUID, that.parentGUID) && Objects.equals(this.parentRelationshipTypeName, that.parentRelationshipTypeName) && Objects.equals(this.parentRelationshipProperties, that.parentRelationshipProperties) && Objects.equals(this.effectiveTime, that.effectiveTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.typeName, this.initialStatus, this.initialClassifications, this.anchorGUID, this.isOwnAnchor, this.effectiveFrom, this.effectiveTo, this.replacementProperties, this.templateGUID, this.placeholderPropertyValues, this.parentGUID, this.parentRelationshipTypeName, this.parentRelationshipProperties, this.parentAtEnd1, this.effectiveTime);
    }
}

