/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum OpenGovernanceAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OPEN-GOVERNANCE-0001", AuditLogRecordSeverityLevel.STARTUP, "The Open Metadata Store Services are initializing a new server instance", "The local server has started up a new instance of the Open Metadata Store Services.  It will support open metadata store REST requests.", "This is part of the normal start up of the service.  No action is required if this service startup was intentional."),
    SERVICE_INITIALIZED("OPEN-GOVERNANCE-0005", AuditLogRecordSeverityLevel.STARTUP, "The Open Metadata Store Services has initialized a new instance for server {0}", "The Open Metadata Store Services has completed initialization of a new server instance.", "Verify that there are no error messages logged by the service.  If there are none it means that all parts of the service initialized successfully."),
    SERVICE_INSTANCE_FAILURE("OPEN-GOVERNANCE-0006", AuditLogRecordSeverityLevel.ERROR, "The Open Metadata Store Services are unable to initialize a new instance; error message is {0}", "The service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    UNEXPECTED_INITIALIZATION_EXCEPTION("OPEN-GOVERNANCE-0008", AuditLogRecordSeverityLevel.EXCEPTION, "The Open Metadata Store Services detected an unexpected {0} exception during the initialization of its services; error message is {1}", "The service detected an error during the start up of a specific server instance.  Its services are not available for the server and an error is returned to the caller.", "Review the error message and any other reported failures to determine the cause of the problem.  In particular consider the state of the Event Bus.  Once this is resolved, restart the server."),
    SERVICE_TERMINATING("OPEN-GOVERNANCE-0009", AuditLogRecordSeverityLevel.SHUTDOWN, "The Open Metadata Store Services are shutting down server instance {0}", "The local handlers has requested shut down of the Open Metadata Store Services.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OPEN-GOVERNANCE-0012", AuditLogRecordSeverityLevel.SHUTDOWN, "The Open Metadata Store Services are shutting down its instance for server {0}", "The local administrator has requested shut down of an Open Metadata Store Services instance.  The open metadata store interfaces are no longer available and no configuration events will be published to the out topic", "This is part of the normal shutdown of the service.  Verify that all resources have been released."),
    WATCHDOG_EVENT_FAILURE("OMES-GOVERNANCE-ACTION-0015", AuditLogRecordSeverityLevel.ERROR, "The Governance Action Framework received an {0} exception from the {1} governance action service while it was processing a watchdog event of type {2}; error message is {3}", "The engine services detected an error while processing a watchdog event.", "Review the error message and any other reported failures to determine the cause of the problem.  It may also be necessary to initiate the action that did not occur due to the failure to process this event."),
    ASSET_AUDIT_LOG("OPEN-GOVERNANCE-0020", AuditLogRecordSeverityLevel.INFO, "Log message for asset {0} from governance service {1}: {2}", "A governance service has logged a message about an asset.", "Review the message to ensure no action is required."),
    WATCHDOG_LISTENER_EXCEPTION("OPEN-GOVERNANCE-0021", AuditLogRecordSeverityLevel.ERROR, "Failed to publish watchdog event to Watchdog Governance Action Service for governance engine {0}.  The exception was {1} with error message {2}", "An open watchdog governance action service has raised an exception while processing an incoming watchdog event.  The exception explains the reason.", "Review the error messages and resolve the cause of the problem if needed.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private OpenGovernanceAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "AuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

