/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.gaf.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.gaf.api.MetadataElementInterface;
import org.odpi.openmetadata.commonservices.gaf.api.SpecialGovernanceActionInterface;
import org.odpi.openmetadata.commonservices.gaf.client.rest.OpenMetadataStoreRESTClient;
import org.odpi.openmetadata.commonservices.gaf.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.FindRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.PeerDuplicatesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;

public abstract class OpenMetadataStoreClientBase
implements MetadataElementInterface,
SpecialGovernanceActionInterface {
    private final String serverName;
    private final String serviceURLMarker;
    private final String serverPlatformURLRoot;
    private final OpenMetadataStoreRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public OpenMetadataStoreClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serviceURLMarker = serviceURLMarker;
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new OpenMetadataStoreRESTClient(serverName, serverPlatformURLRoot);
    }

    public OpenMetadataStoreClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serviceURLMarker = serviceURLMarker;
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new OpenMetadataStoreRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public OpenMetadataStoreClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, OpenMetadataStoreRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serviceURLMarker = serviceURLMarker;
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    private long getEffectiveTimeAsLong(Date effectiveTime) {
        long effectiveTimeLong = 0L;
        if (effectiveTime != null) {
            effectiveTimeLong = effectiveTime.getTime();
        }
        return effectiveTimeLong;
    }

    public OpenMetadataElement getMetadataElementByGUID(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByGUID";
        String guidParameterName = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}?forLineage={4}&forDuplicateProcessing={5}&effectiveTime={6}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByGUID");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getMetadataElementByGUID");
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementGetRESTCall("getMetadataElementByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}?forLineage={4}&forDuplicateProcessing={5}&effectiveTime={6}", this.serverName, this.serviceURLMarker, userId, elementGUID, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    public OpenMetadataElement getMetadataElementByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-unique-name?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementPostRESTCall("getMetadataElementByUniqueName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-unique-name?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}", requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementGUIDByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/guid-by-unique-name?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementGUIDByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementGUIDByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataElementGUIDByUniqueName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/guid-by-unique-name?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}", requestBody, new Object[]{this.serverName, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime)});
        return restResult.getGUID();
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String userId, String searchString, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElementsWithString";
        String searchStringParameterName = "searchString";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-string?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElementsWithString");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findMetadataElementsWithString");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElementsWithString", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-string?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}", requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElements";
        String guidParameterName = "elementGUID";
        String typeNameParameterName = "relationshipTypeName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/type/{4}?startingAtEnd={5}&forLineage={6}&forDuplicateProcessing={7}&effectiveTime={8}&startFrom={9}&pageSize={10}";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedMetadataElements");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getRelatedMetadataElements");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getRelatedMetadataElements");
        RelatedMetadataElementListResponse restResult = this.restClient.callRelatedMetadataElementListGetRESTCall("getRelatedMetadataElements", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/type/{4}?startingAtEnd={5}&forLineage={6}&forDuplicateProcessing={7}&effectiveTime={8}&startFrom={9}&pageSize={10}", this.serverName, this.serviceURLMarker, userId, elementGUID, relationshipTypeName, Integer.toString(startingAtEnd), forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<OpenMetadataElement> findMetadataElements(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElements";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(metadataElementTypeName);
        requestBody.setMetadataElementSubtypeName(metadataElementSubtypeName);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setMatchClassifications(matchClassifications);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElements", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}", requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String userId, String relationshipTypeName, SearchProperties searchProperties, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findRelationshipsBetweenMetadataElements";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findRelationshipsBetweenMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(relationshipTypeName);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        RelatedMetadataElementsListResponse restResult = this.restClient.callRelatedMetadataElementsListPostRESTCall("findRelationshipsBetweenMetadataElements", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}", requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataElementInStore";
        String elementTypeParameterName = "metadataElementTypeName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/new";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataElementInStore");
        this.invalidParameterHandler.validateName(metadataElementTypeName, "metadataElementTypeName", "createMetadataElementInStore");
        NewMetadataElementRequestBody requestBody = new NewMetadataElementRequestBody();
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setInitialStatus(initialStatus);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setTemplateGUID(templateGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataElementInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/new", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public void updateMetadataElementInStore(String userId, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-properties", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void updateMetadataElementStatusInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementStatusInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-status";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementStatusInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementStatusInStore");
        UpdateStatusRequestBody requestBody = new UpdateStatusRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setNewStatus(newElementStatus);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementStatusInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-status", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void updateMetadataElementEffectivityInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementEffectivityInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-effectivity", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void deleteMetadataElementInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "deleteMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("deleteMetadataElementInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/delete", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void classifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/new";
        this.invalidParameterHandler.validateUserId(userId, "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "classifyMetadataElementInStore");
        NewClassificationRequestBody requestBody = new NewClassificationRequestBody();
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("classifyMetadataElementInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/new", requestBody, new Object[]{this.serverName, userId, metadataElementGUID, classificationName});
    }

    public void reclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "reclassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "reclassifyMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("reclassifyMetadataElementInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-properties", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public void updateClassificationEffectivityInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateClassificationEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "updateClassificationEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateClassificationEffectivityInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-effectivity", requestBody, new Object[]{this.serverName, userId, metadataElementGUID, classificationName});
    }

    public void unclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unclassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "unclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "unclassifyMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("unclassifyMetadataElementInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/delete", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public String createRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createRelatedElementsInStore";
        String elementTypeParameterName = "relationshipTypeName";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/new";
        this.invalidParameterHandler.validateUserId(userId, "createRelatedElementsInStore");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "createRelatedElementsInStore");
        NewRelatedElementsRequestBody requestBody = new NewRelatedElementsRequestBody();
        requestBody.setTypeName(relationshipTypeName);
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createRelatedElementsInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/new", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public void updateRelatedElementsInStore(String userId, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-properties", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, relationshipGUID});
    }

    public void updateRelatedElementsEffectivityInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsEffectivityInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsEffectivityInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsEffectivityInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-effectivity", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, relationshipGUID});
    }

    public void deleteRelatedElementsInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "deleteRelatedElementsInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("deleteRelatedElementsInStore", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/delete", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, relationshipGUID});
    }

    public String createIncidentReport(String userId, String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties, String originatorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIncidentReport";
        String qualifiedNameParameterName = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/incident-reports";
        this.invalidParameterHandler.validateUserId(userId, "createIncidentReport");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createIncidentReport");
        IncidentReportRequestBody requestBody = new IncidentReportRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setBackground(background);
        requestBody.setImpactedResources(impactedResources);
        requestBody.setPreviousIncidents(previousIncidents);
        requestBody.setIncidentClassifiers(incidentClassifiers);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setOriginatorGUID(originatorGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIncidentReport", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/incident-reports", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public String openToDo(String userId, String toDoQualifiedName, String title, String instructions, int priority, Date dueDate, String assignTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "openToDo";
        String todoTypeName = "ToDo";
        String personRoleTypeName = "PersonRole";
        String actionAssignmentTypeName = "ActionAssignment";
        String qualifiedNamePropertyName = "qualifiedName";
        String titlePropertyName = "name";
        String instructionsPropertyName = "description";
        String priorityPropertyName = "priority";
        String dueDatePropertyName = "dueTime";
        String statusPropertyName = "status";
        String statusPropertyTypeName = "ToDoStatus";
        String openEnumPropertyValue = "Open";
        String toDoQualifiedNameParameterName = "toDoQualifiedName";
        String assignToParameterName = "assignTo";
        this.propertyHelper.validateMandatoryName(toDoQualifiedName, "toDoQualifiedName", "openToDo");
        this.propertyHelper.validateMandatoryName(assignTo, "assignTo", "openToDo");
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition condition = new PropertyCondition();
        PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
        primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        primitiveTypePropertyValue.setPrimitiveValue((Object)assignTo);
        primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        condition.setProperty("qualifiedName");
        condition.setOperator(PropertyComparisonOperator.EQ);
        condition.setValue((PropertyValue)primitiveTypePropertyValue);
        conditions.add(condition);
        searchProperties.setConditions(conditions);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        List<OpenMetadataElement> personRoleMatches = this.findMetadataElements(userId, "PersonRole", null, searchProperties, null, null, null, null, false, false, new Date(), 0, 0);
        if (personRoleMatches == null || personRoleMatches.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.UNKNOWN_ELEMENT.getMessageDefinition(new String[]{toDoQualifiedName, "toDoQualifiedName", "openToDo"}), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        if (personRoleMatches.size() > 1) {
            ArrayList<String> matchingGUIDs = new ArrayList<String>();
            for (OpenMetadataElement element : personRoleMatches) {
                if (element == null) continue;
                matchingGUIDs.add(element.getElementGUID());
            }
            throw new InvalidParameterException(GAFErrorCode.DUPLICATE_ELEMENT.getMessageDefinition(new String[]{toDoQualifiedName, "toDoQualifiedName", "openToDo", ((Object)matchingGUIDs).toString()}), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        OpenMetadataElement personRoleElement = personRoleMatches.get(0);
        String personRoleGUID = null;
        if (personRoleElement != null && personRoleElement.getElementGUID() != null) {
            personRoleGUID = personRoleElement.getElementGUID();
        }
        ElementProperties properties = this.propertyHelper.addStringProperty(null, "qualifiedName", toDoQualifiedName);
        if (title != null) {
            properties = this.propertyHelper.addStringProperty(properties, "name", title);
        }
        if (instructions != null) {
            properties = this.propertyHelper.addStringProperty(properties, "description", "description");
        }
        if (dueDate != null) {
            properties = this.propertyHelper.addDateProperty(properties, "dueTime", dueDate);
        }
        properties = this.propertyHelper.addIntProperty(properties, "priority", priority);
        properties = this.propertyHelper.addEnumProperty(properties, "status", "ToDoStatus", "Open");
        String todoGUID = this.createMetadataElementInStore(userId, "ToDo", ElementStatus.ACTIVE, null, null, properties, null);
        this.createRelatedElementsInStore(userId, "ActionAssignment", personRoleGUID, todoGUID, false, false, null, null, null, new Date());
        return todoGUID;
    }

    public void linkElementsAsPeerDuplicates(String userId, String metadataElement1GUID, String metadataElement2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, boolean setKnownDuplicate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementsAsPeerDuplicates";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/link-as-peer-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "linkElementsAsPeerDuplicates");
        PeerDuplicatesRequestBody requestBody = new PeerDuplicatesRequestBody();
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSetKnownDuplicate(setKnownDuplicate);
        this.restClient.callVoidPostRESTCall("linkElementsAsPeerDuplicates", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/link-as-peer-duplicate", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
    }

    public void linkConsolidatedDuplicate(String userId, String consolidatedElementGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkConsolidatedDuplicate";
        String consolidatedElementGUIDParameterName = "consolidatedElementGUID";
        String sourceElementGUIDsParameterName = "sourceElementGUIDs";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/link-as-consolidated-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedElementGUID, "consolidatedElementGUID", "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateObject(sourceElementGUIDs, "sourceElementGUIDs", "linkConsolidatedDuplicate");
        ConsolidatedDuplicatesRequestBody requestBody = new ConsolidatedDuplicatesRequestBody();
        requestBody.setConsolidatedElementGUID(consolidatedElementGUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSourceElementGUIDs(sourceElementGUIDs);
        this.restClient.callVoidPostRESTCall("linkConsolidatedDuplicate", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/link-as-consolidated-duplicate", requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
    }
}

