/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.gaf.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.gaf.api.MetadataElementInterface;
import org.odpi.openmetadata.commonservices.gaf.api.MultiLanguageInterface;
import org.odpi.openmetadata.commonservices.gaf.api.StewardshipActionInterface;
import org.odpi.openmetadata.commonservices.gaf.api.ValidMetadataValuesInterface;
import org.odpi.openmetadata.commonservices.gaf.client.rest.OpenMetadataStoreRESTClient;
import org.odpi.openmetadata.commonservices.gaf.properties.TranslationDetail;
import org.odpi.openmetadata.commonservices.gaf.properties.ValidMetadataValue;
import org.odpi.openmetadata.commonservices.gaf.rest.FindRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.TranslationDetailResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.TranslationListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.commonservices.gaf.rest.ValidMetadataValueListResponse;
import org.odpi.openmetadata.commonservices.gaf.rest.ValidMetadataValueResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;

public abstract class OpenMetadataStoreClientBase
implements MetadataElementInterface,
StewardshipActionInterface,
MultiLanguageInterface,
ValidMetadataValuesInterface {
    protected final String serverName;
    protected final String serviceURLMarker;
    protected final String serverPlatformURLRoot;
    private final OpenMetadataStoreRESTClient restClient;
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public OpenMetadataStoreClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serviceURLMarker = serviceURLMarker;
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new OpenMetadataStoreRESTClient(serverName, serverPlatformURLRoot);
    }

    public OpenMetadataStoreClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serviceURLMarker = serviceURLMarker;
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new OpenMetadataStoreRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public OpenMetadataStoreClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, OpenMetadataStoreRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serviceURLMarker = serviceURLMarker;
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    private long getEffectiveTimeAsLong(Date effectiveTime) {
        long effectiveTimeLong = 0L;
        if (effectiveTime != null) {
            effectiveTimeLong = effectiveTime.getTime();
        }
        return effectiveTimeLong;
    }

    public OpenMetadataElement getMetadataElementByGUID(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByGUID";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}?forLineage={4}&forDuplicateProcessing={5}&effectiveTime={6}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByGUID");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getMetadataElementByGUID");
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementGetRESTCall("getMetadataElementByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    public OpenMetadataElement getMetadataElementByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-unique-name?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementPostRESTCall("getMetadataElementByUniqueName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementGUIDByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/guid-by-unique-name?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementGUIDByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementGUIDByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataElementGUIDByUniqueName", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime)});
        return restResult.getGUID();
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String userId, String searchString, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElementsWithString";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-string?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElementsWithString");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findMetadataElementsWithString");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElementsWithString", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElements";
        String guidParameterName = "elementGUID";
        String allURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}?startingAtEnd={4}&forLineage={5}&forDuplicateProcessing={6}&effectiveTime={7}&startFrom={8}&pageSize={9}";
        String specificURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/type/{4}?startingAtEnd={5}&forLineage={6}&forDuplicateProcessing={7}&effectiveTime={8}&startFrom={9}&pageSize={10}";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedMetadataElements");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getRelatedMetadataElements");
        RelatedMetadataElementListResponse restResult = relationshipTypeName == null ? this.restClient.callRelatedMetadataElementListGetRESTCall("getRelatedMetadataElements", allURLTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, Integer.toString(startingAtEnd), forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize)) : this.restClient.callRelatedMetadataElementListGetRESTCall("getRelatedMetadataElements", specificURLTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, relationshipTypeName, Integer.toString(startingAtEnd), forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<OpenMetadataElement> findMetadataElements(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(metadataElementTypeName);
        requestBody.setMetadataElementSubtypeName(metadataElementSubtypeName);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setMatchClassifications(matchClassifications);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElements", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String userId, String relationshipTypeName, SearchProperties searchProperties, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findRelationshipsBetweenMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findRelationshipsBetweenMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(relationshipTypeName);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        RelatedMetadataElementsListResponse restResult = this.restClient.callRelatedMetadataElementsListPostRESTCall("findRelationshipsBetweenMetadataElements", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementInStore(userId, null, null, metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties, templateGUID);
    }

    public String createMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataElementInStore";
        String elementTypeParameterName = "metadataElementTypeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/new";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataElementInStore");
        this.invalidParameterHandler.validateName(metadataElementTypeName, "metadataElementTypeName", "createMetadataElementInStore");
        NewMetadataElementRequestBody requestBody = new NewMetadataElementRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setInitialStatus(initialStatus);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setTemplateGUID(templateGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public void updateMetadataElementInStore(String userId, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementInStore(userId, null, null, metadataElementGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    public void updateMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void updateMetadataElementStatusInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementStatusInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, newElementStatus, effectiveTime);
    }

    public void updateMetadataElementStatusInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementStatusInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-status";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementStatusInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementStatusInStore");
        UpdateStatusRequestBody requestBody = new UpdateStatusRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setNewStatus(newElementStatus);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementStatusInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void updateMetadataElementEffectivityInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementEffectivityInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    public void updateMetadataElementEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementEffectivityInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void deleteMetadataElementInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteMetadataElementInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void deleteMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "deleteMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("deleteMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID});
    }

    public void classifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.classifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    public void classifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/new";
        this.invalidParameterHandler.validateUserId(userId, "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "classifyMetadataElementInStore");
        NewClassificationRequestBody requestBody = new NewClassificationRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("classifyMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public void reclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.reclassifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    public void reclassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "reclassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "reclassifyMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("reclassifyMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public void updateClassificationEffectivityInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateClassificationEffectivityInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    public void updateClassificationEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateClassificationEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "updateClassificationEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateClassificationEffectivityInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public void unclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unclassifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void unclassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unclassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "unclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "unclassifyMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("unclassifyMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName});
    }

    public String createRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createRelatedElementsInStore(userId, null, null, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    public String createRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createRelatedElementsInStore";
        String elementTypeParameterName = "relationshipTypeName";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/new";
        this.invalidParameterHandler.validateUserId(userId, "createRelatedElementsInStore");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "createRelatedElementsInStore");
        NewRelatedElementsRequestBody requestBody = new NewRelatedElementsRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(relationshipTypeName);
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createRelatedElementsInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public void updateRelatedElementsInStore(String userId, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelatedElementsInStore(userId, null, null, relationshipGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    public void updateRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, relationshipGUID});
    }

    public void updateRelatedElementsEffectivityInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelatedElementsEffectivityInStore(userId, null, null, relationshipGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    public void updateRelatedElementsEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsEffectivityInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsEffectivityInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsEffectivityInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, relationshipGUID});
    }

    public void deleteRelatedElementsInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteRelatedElementsInStore(userId, null, null, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void deleteRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "deleteRelatedElementsInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("deleteRelatedElementsInStore", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, relationshipGUID});
    }

    public String createIncidentReport(String userId, String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties, String originatorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIncidentReport";
        String qualifiedNameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/incident-reports";
        this.invalidParameterHandler.validateUserId(userId, "createIncidentReport");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createIncidentReport");
        IncidentReportRequestBody requestBody = new IncidentReportRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setBackground(background);
        requestBody.setImpactedResources(impactedResources);
        requestBody.setPreviousIncidents(previousIncidents);
        requestBody.setIncidentClassifiers(incidentClassifiers);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setOriginatorGUID(originatorGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIncidentReport", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public String openToDo(String userId, String toDoQualifiedName, String title, String instructions, int priority, Date dueDate, String assignTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "openToDo";
        String todoTypeName = "ToDo";
        String personRoleTypeName = "PersonRole";
        String actionAssignmentTypeName = "ActionAssignment";
        String qualifiedNamePropertyName = "qualifiedName";
        String titlePropertyName = "name";
        String instructionsPropertyName = "description";
        String priorityPropertyName = "priority";
        String dueDatePropertyName = "dueTime";
        String statusPropertyName = "status";
        String statusPropertyTypeName = "ToDoStatus";
        String openEnumPropertyValue = "Open";
        String toDoQualifiedNameParameterName = "toDoQualifiedName";
        String assignToParameterName = "assignTo";
        this.propertyHelper.validateMandatoryName(toDoQualifiedName, "toDoQualifiedName", "openToDo");
        this.propertyHelper.validateMandatoryName(assignTo, "assignTo", "openToDo");
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition condition = new PropertyCondition();
        PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
        primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        primitiveTypePropertyValue.setPrimitiveValue((Object)assignTo);
        primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        condition.setProperty("qualifiedName");
        condition.setOperator(PropertyComparisonOperator.EQ);
        condition.setValue((PropertyValue)primitiveTypePropertyValue);
        conditions.add(condition);
        searchProperties.setConditions(conditions);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        List<OpenMetadataElement> personRoleMatches = this.findMetadataElements(userId, "PersonRole", null, searchProperties, null, null, null, null, false, false, new Date(), 0, 0);
        if (personRoleMatches == null || personRoleMatches.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.UNKNOWN_ELEMENT.getMessageDefinition(new String[]{toDoQualifiedName, "toDoQualifiedName", "openToDo"}), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        if (personRoleMatches.size() > 1) {
            ArrayList<String> matchingGUIDs = new ArrayList<String>();
            for (OpenMetadataElement element : personRoleMatches) {
                if (element == null) continue;
                matchingGUIDs.add(element.getElementGUID());
            }
            throw new InvalidParameterException(GAFErrorCode.DUPLICATE_ELEMENT.getMessageDefinition(new String[]{toDoQualifiedName, "toDoQualifiedName", "openToDo", ((Object)matchingGUIDs).toString()}), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        OpenMetadataElement personRoleElement = personRoleMatches.get(0);
        String personRoleGUID = null;
        if (personRoleElement != null && personRoleElement.getElementGUID() != null) {
            personRoleGUID = personRoleElement.getElementGUID();
        }
        ElementProperties properties = this.propertyHelper.addStringProperty(null, "qualifiedName", toDoQualifiedName);
        if (title != null) {
            properties = this.propertyHelper.addStringProperty(properties, "name", title);
        }
        if (instructions != null) {
            properties = this.propertyHelper.addStringProperty(properties, "description", "description");
        }
        if (dueDate != null) {
            properties = this.propertyHelper.addDateProperty(properties, "dueTime", dueDate);
        }
        properties = this.propertyHelper.addIntProperty(properties, "priority", priority);
        properties = this.propertyHelper.addEnumProperty(properties, "status", "ToDoStatus", "Open");
        String todoGUID = this.createMetadataElementInStore(userId, "ToDo", ElementStatus.ACTIVE, null, null, properties, null);
        this.createRelatedElementsInStore(userId, "ActionAssignment", personRoleGUID, todoGUID, false, false, null, null, null, new Date());
        return todoGUID;
    }

    public void setTranslation(String userId, String elementGUID, TranslationDetail translationDetail) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTranslation";
        String elementGUIDParameterName = "elementGUID";
        String translationDetailParameterName = "translationDetail";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/multi-language/set-translation/{3}";
        this.invalidParameterHandler.validateUserId(userId, "setTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "setTranslation");
        this.invalidParameterHandler.validateObject((Object)translationDetail, "translationDetail", "setTranslation");
        this.restClient.callVoidPostRESTCall("setTranslation", urlTemplate, translationDetail, new Object[]{this.serverName, this.serviceURLMarker, userId, elementGUID});
    }

    public void clearTranslation(String userId, String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTranslation";
        String elementGUIDParameterName = "elementGUID";
        String languageParameterName = "language";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/multi-language/clear-translation/{3}?language={4}&locale={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "clearTranslation");
        this.invalidParameterHandler.validateName(language, "language", "clearTranslation");
        this.restClient.callVoidPostRESTCall("clearTranslation", urlTemplate, new NullRequestBody(), new Object[]{this.serverName, this.serviceURLMarker, userId, elementGUID, language, locale});
    }

    public TranslationDetail getTranslation(String userId, String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTranslation";
        String elementGUIDParameterName = "elementGUID";
        String languageParameterName = "language";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/multi-language/get-translation/{3}?language={4}&locale={5}";
        this.invalidParameterHandler.validateUserId(userId, "getTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getTranslation");
        this.invalidParameterHandler.validateName(language, "language", "getTranslation");
        TranslationDetailResponse response = this.restClient.callTranslationDetailGetRESTCall("getTranslation", urlTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, language, locale);
        return response.getElement();
    }

    public List<TranslationDetail> getTranslations(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTranslations";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/multi-language/get-translations/{3}?startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getTranslations");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getTranslations");
        TranslationListResponse response = this.restClient.callTranslationListGetRESTCall("getTranslations", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, elementGUID, startFrom, pageSize);
        return response.getElementList();
    }

    public void setUpValidMetadataValue(String userId, String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-valid-metadata-value/{3}?typeName={4}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataValue");
        this.invalidParameterHandler.validateObject((Object)validMetadataValue, "validMetadataValue", "setUpValidMetadataValue");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataValue", urlTemplate, validMetadataValue, new Object[]{this.serverName, this.serviceURLMarker, userId, propertyName, typeName});
    }

    public void clearValidMetadataValue(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-valid-metadata-value/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataValue");
        this.restClient.callVoidPostRESTCall("clearValidMetadataValue", urlTemplate, new NullRequestBody(), new Object[]{this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName});
    }

    public boolean validateMetadataValue(String userId, String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate/{3}?actualValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataValue");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataValue", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName, actualValue, typeName);
        return response.getFlag();
    }

    public ValidMetadataValue getValidMetadataValue(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-valid-metadata-value/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValue");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataValue", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
        return response.getElement();
    }

    public List<ValidMetadataValue> getValidMetadataValues(String userId, String typeName, String propertyName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataValues";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-valid-metadata-values/{3}?typeName={4}?startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataValues");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValues");
        ValidMetadataValueListResponse response = this.restClient.callValidMetadataValueListGetRESTCall("getValidMetadataValues", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName, typeName, startFrom, pageSize);
        return response.getElementList();
    }
}

