/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceListener;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.frameworkservices.gaf.ffdc.OpenMetadataStoreAuditCode;

public class GovernanceListenerManager {
    private final Map<String, WatchdogListener> listenerMap = new HashMap<String, WatchdogListener>();
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final AuditLog auditLog;
    private final String governanceEngineName;

    public GovernanceListenerManager(AuditLog auditLog, String governanceEngineName) {
        this.auditLog = auditLog;
        this.governanceEngineName = governanceEngineName;
    }

    public synchronized void processEvent(WatchdogGovernanceEvent event) throws InvalidParameterException {
        if (event != null) {
            for (String connectorId : this.listenerMap.keySet()) {
                WatchdogListener watchdogListener;
                if (connectorId == null || (watchdogListener = this.listenerMap.get(connectorId)) == null) continue;
                watchdogListener.processWatchdogEvent(event);
            }
        }
    }

    synchronized void registerListener(String connectorId, WatchdogGovernanceListener listener, List<WatchdogEventType> interestingEventTypes, List<String> interestingMetadataTypes, String specificInstance) {
        WatchdogListener watchdogListener = this.listenerMap.get(connectorId);
        if (watchdogListener == null) {
            watchdogListener = new WatchdogListener();
        }
        watchdogListener.setListenerSpec(listener, interestingEventTypes, interestingMetadataTypes, specificInstance);
        this.listenerMap.put(connectorId, watchdogListener);
    }

    public synchronized void removeListener(String connectorId) {
        this.listenerMap.remove(connectorId);
    }

    private class WatchdogListener {
        private WatchdogGovernanceListener listener = null;
        private List<WatchdogEventType> interestingEventTypes = null;
        private List<String> interestingMetadataTypes = null;
        private String specificInstance = null;

        WatchdogListener() {
        }

        void setListenerSpec(WatchdogGovernanceListener listener, List<WatchdogEventType> interestingEventTypes, List<String> interestingMetadataType, String specificInstance) {
            this.listener = listener;
            this.interestingEventTypes = interestingEventTypes;
            this.interestingMetadataTypes = interestingMetadataType;
            this.specificInstance = specificInstance;
        }

        void processWatchdogEvent(WatchdogGovernanceEvent event) throws InvalidParameterException {
            String methodName = "WatchdogListener.processWatchdogEvent";
            String eventParameterName = "event";
            String eventTypeParameterName = "eventType";
            GovernanceListenerManager.this.invalidParameterHandler.validateObject((Object)event, "event", "WatchdogListener.processWatchdogEvent");
            GovernanceListenerManager.this.invalidParameterHandler.validateEnum((Object)event.getEventType(), "eventType", "WatchdogListener.processWatchdogEvent");
            if (this.listener != null && (this.interestingEventTypes == null || this.interestingEventTypes.contains(event.getEventType()))) {
                WatchdogRelatedElementsEvent relatedElementsEvent;
                if (event instanceof WatchdogClassificationEvent) {
                    String elementParameterName = "watchdogClassificationEvent.getMetadataElement()";
                    String classificationParameterName = "watchdogClassificationEvent.getChangedClassification()";
                    String elementGUIDParameterName = "watchdogClassificationEvent.getMetadataElement().getElementGUID()";
                    String typeNameParameterName = "watchdogClassificationEvent.getChangedClassification().getClassificationName()";
                    WatchdogClassificationEvent watchdogClassificationEvent = (WatchdogClassificationEvent)event;
                    GovernanceListenerManager.this.invalidParameterHandler.validateObject((Object)watchdogClassificationEvent.getMetadataElement(), "watchdogClassificationEvent.getMetadataElement()", "WatchdogListener.processWatchdogEvent");
                    GovernanceListenerManager.this.invalidParameterHandler.validateObject((Object)watchdogClassificationEvent.getChangedClassification(), "watchdogClassificationEvent.getChangedClassification()", "WatchdogListener.processWatchdogEvent");
                    GovernanceListenerManager.this.invalidParameterHandler.validateGUID(watchdogClassificationEvent.getMetadataElement().getElementGUID(), "watchdogClassificationEvent.getMetadataElement().getElementGUID()", "WatchdogListener.processWatchdogEvent");
                    GovernanceListenerManager.this.invalidParameterHandler.validateName(watchdogClassificationEvent.getChangedClassification().getClassificationName(), "watchdogClassificationEvent.getChangedClassification().getClassificationName()", "WatchdogListener.processWatchdogEvent");
                    if (this.elementIsInteresting(watchdogClassificationEvent.getMetadataElement().getElementGUID(), watchdogClassificationEvent.getChangedClassification().getClassificationName(), null)) {
                        this.callListener(event);
                    }
                } else if (event instanceof WatchdogMetadataElementEvent) {
                    String elementParameterName = "watchdogMetadataElementEvent.getMetadataElement()";
                    String elementTypeParameterName = "watchdogMetadataElementEvent.getElementType()";
                    String elementGUIDParameterName = "watchdogMetadataElementEvent.getMetadataElement().getElementGUID()";
                    String typeNameParameterName = "watchdogMetadataElementEvent.getMetadataElement().getElementType().getElementTypeName()";
                    WatchdogMetadataElementEvent watchdogMetadataElementEvent = (WatchdogMetadataElementEvent)event;
                    GovernanceListenerManager.this.invalidParameterHandler.validateObject((Object)watchdogMetadataElementEvent.getMetadataElement(), "watchdogMetadataElementEvent.getMetadataElement()", "WatchdogListener.processWatchdogEvent");
                    GovernanceListenerManager.this.invalidParameterHandler.validateObject((Object)watchdogMetadataElementEvent.getMetadataElement().getType(), "watchdogMetadataElementEvent.getElementType()", "WatchdogListener.processWatchdogEvent");
                    GovernanceListenerManager.this.invalidParameterHandler.validateGUID(watchdogMetadataElementEvent.getMetadataElement().getElementGUID(), "watchdogMetadataElementEvent.getMetadataElement().getElementGUID()", "WatchdogListener.processWatchdogEvent");
                    GovernanceListenerManager.this.invalidParameterHandler.validateName(watchdogMetadataElementEvent.getMetadataElement().getType().getTypeName(), "watchdogMetadataElementEvent.getMetadataElement().getElementType().getElementTypeName()", "WatchdogListener.processWatchdogEvent");
                    if (this.elementIsInteresting(watchdogMetadataElementEvent.getMetadataElement().getElementGUID(), watchdogMetadataElementEvent.getMetadataElement().getType().getTypeName(), watchdogMetadataElementEvent.getMetadataElement().getType().getSuperTypeNames())) {
                        this.callListener(event);
                    }
                } else if (event instanceof WatchdogRelatedElementsEvent && this.elementIsInteresting((relatedElementsEvent = (WatchdogRelatedElementsEvent)event).getRelatedMetadataElements().getRelationshipGUID(), relatedElementsEvent.getRelatedMetadataElements().getRelationshipType().getTypeName(), relatedElementsEvent.getRelatedMetadataElements().getRelationshipType().getSuperTypeNames())) {
                    this.callListener(event);
                }
            }
        }

        private boolean elementIsInteresting(String elementGUID, String elementTypeName, List<String> elementSuperTypeNames) {
            if (this.specificInstance != null && this.specificInstance.equals(elementGUID)) {
                return true;
            }
            if (this.interestingMetadataTypes == null || this.interestingMetadataTypes.contains(elementTypeName)) {
                return true;
            }
            if (elementSuperTypeNames != null && !elementSuperTypeNames.isEmpty()) {
                for (String typeName : elementSuperTypeNames) {
                    if (typeName == null || !this.interestingMetadataTypes.contains(typeName)) continue;
                    return true;
                }
            }
            return false;
        }

        private void callListener(WatchdogGovernanceEvent event) {
            try {
                this.listener.processEvent(event);
            }
            catch (Exception error) {
                String actionDescription = "publish watchdog event to listener";
                GovernanceListenerManager.this.auditLog.logMessage("publish watchdog event to listener", OpenMetadataStoreAuditCode.WATCHDOG_LISTENER_EXCEPTION.getMessageDefinition(new String[]{GovernanceListenerManager.this.governanceEngineName, error.getClass().getName(), error.getMessage()}), event.toString());
            }
        }
    }
}

