/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceListener;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenGovernanceClient;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworkservices.gaf.client.GovernanceListenerManager;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.PeerDuplicatesRequestBody;

public class OpenGovernanceClientBase
extends OpenGovernanceClient {
    private final GAFRESTClient restClient;
    protected GovernanceListenerManager governanceListenerManager = null;
    protected String listenerId = null;
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public OpenGovernanceClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot);
    }

    public void setListenerManager(GovernanceListenerManager governanceListenerManager, String listenerId) {
        this.governanceListenerManager = governanceListenerManager;
        this.listenerId = listenerId;
    }

    public OpenGovernanceClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Client Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with security)");
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public OpenGovernanceClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, GAFRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Client Constructor (with REST client)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with REST client)");
        this.restClient = restClient;
    }

    public void updateActionTargetStatus(String userId, String actionTargetGUID, GovernanceActionStatus status, Date startDate, Date completionDate, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateActionTargetStatus";
        String guidParameterName = "actionTargetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-actions/action-targets/update";
        this.invalidParameterHandler.validateUserId(userId, "updateActionTargetStatus");
        this.invalidParameterHandler.validateGUID(actionTargetGUID, "actionTargetGUID", "updateActionTargetStatus");
        ActionTargetStatusRequestBody requestBody = new ActionTargetStatusRequestBody();
        requestBody.setActionTargetGUID(actionTargetGUID);
        requestBody.setStatus(status);
        requestBody.setStartDate(startDate);
        requestBody.setCompletionDate(completionDate);
        requestBody.setCompletionMessage(completionMessage);
        this.restClient.callVoidPostRESTCall("updateActionTargetStatus", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
    }

    public void recordCompletionStatus(String userId, String governanceActionGUID, Map<String, String> requestParameters, CompletionStatus status, List<String> outputGuards, List<NewActionTarget> newActionTargets, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "recordCompletionStatus";
        String statusParameterName = "status";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-actions/{3}/completion-status";
        this.invalidParameterHandler.validateUserId(userId, "recordCompletionStatus");
        this.invalidParameterHandler.validateEnum((Object)status, "status", "recordCompletionStatus");
        CompletionStatusRequestBody requestBody = new CompletionStatusRequestBody();
        requestBody.setRequestParameters(requestParameters);
        requestBody.setStatus(status);
        requestBody.setOutputGuards(outputGuards);
        requestBody.setNewActionTargets(newActionTargets);
        requestBody.setCompletionMessage(completionMessage);
        this.restClient.callVoidPostRESTCall("recordCompletionStatus", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, governanceActionGUID});
    }

    public String initiateGovernanceAction(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String processName, String requestSourceName, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceAction";
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-engines/{3}/governance-actions/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceAction");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "initiateGovernanceAction");
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", "initiateGovernanceAction");
        GovernanceActionRequestBody requestBody = new GovernanceActionRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setReceivedGuards(receivedGuards);
        requestBody.setStartTime(startTime);
        requestBody.setRequestType(requestType);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setProcessName(processName);
        requestBody.setRequestSourceName(requestSourceName);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceAction", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, governanceEngineName});
        return restResult.getGUID();
    }

    public String initiateGovernanceActionProcess(String userId, String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceActionProcess";
        String qualifiedNameParameterName = "processQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceActionProcess");
        this.invalidParameterHandler.validateName(processQualifiedName, "processQualifiedName", "initiateGovernanceActionProcess");
        GovernanceActionProcessRequestBody requestBody = new GovernanceActionProcessRequestBody();
        requestBody.setProcessQualifiedName(processQualifiedName);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setStartTime(startTime);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceActionProcess", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public void linkElementsAsPeerDuplicates(String userId, String metadataElement1GUID, String metadataElement2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, boolean setKnownDuplicate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementsAsPeerDuplicates";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/related-elements/link-as-peer-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "linkElementsAsPeerDuplicates");
        PeerDuplicatesRequestBody requestBody = new PeerDuplicatesRequestBody();
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSetKnownDuplicate(setKnownDuplicate);
        this.restClient.callVoidPostRESTCall("linkElementsAsPeerDuplicates", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
    }

    public void linkConsolidatedDuplicate(String userId, String consolidatedElementGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkConsolidatedDuplicate";
        String consolidatedElementGUIDParameterName = "consolidatedElementGUID";
        String sourceElementGUIDsParameterName = "sourceElementGUIDs";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/related-elements/link-as-consolidated-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedElementGUID, "consolidatedElementGUID", "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateObject(sourceElementGUIDs, "sourceElementGUIDs", "linkConsolidatedDuplicate");
        ConsolidatedDuplicatesRequestBody requestBody = new ConsolidatedDuplicatesRequestBody();
        requestBody.setConsolidatedElementGUID(consolidatedElementGUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSourceElementGUIDs(sourceElementGUIDs);
        this.restClient.callVoidPostRESTCall("linkConsolidatedDuplicate", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
    }

    public void registerListener(WatchdogGovernanceListener listener, List<WatchdogEventType> interestingEventTypes, List<String> interestingMetadataTypes, String specificInstance) throws InvalidParameterException {
        this.governanceListenerManager.registerListener(this.listenerId, listener, interestingEventTypes, interestingMetadataTypes, specificInstance);
    }

    public void disconnectListener() {
        this.governanceListenerManager.removeListener(this.listenerId);
    }
}

