/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceEngineConfiguration;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceRegistrationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServiceResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServicesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceServiceRequestBody;

public class GovernanceEngineConfigurationClientBase
extends GovernanceEngineConfiguration {
    private final GAFRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private final NullRequestBody nullRequestBody = new NullRequestBody();
    private AuditLog auditLog = null;

    public GovernanceEngineConfigurationClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLMarker);
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceEngineConfigurationClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLMarker);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceEngineConfigurationClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, GAFRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLMarker);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = restClient;
        this.auditLog = auditLog;
    }

    public String getConfigurationServerName() {
        return this.serverName;
    }

    public String createGovernanceEngine(String userId, String governanceEngineType, String qualifiedName, String displayName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceEngine";
        String engineTypeParameterName = "governanceEngineType";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/{3}";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceEngine");
        this.invalidParameterHandler.validateName(governanceEngineType, "governanceEngineType", "createGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createGovernanceEngine");
        NewGovernanceEngineRequestBody requestBody = new NewGovernanceEngineRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceEngine", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, governanceEngineType});
        return restResult.getGUID();
    }

    public GovernanceEngineElement getGovernanceEngineByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceEngineByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getGovernanceEngineByGUID");
        GovernanceEngineElementResponse restResult = this.restClient.callGovernanceEngineGetRESTCall("getGovernanceEngineByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getElement();
    }

    public GovernanceEngineElement getGovernanceEngineByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/by-name";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceEngineByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceEngineByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        GovernanceEngineElementResponse restResult = this.restClient.callGovernanceEnginePostRESTCall("getGovernanceEngineByName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getElement();
    }

    public List<GovernanceEngineElement> getAllGovernanceEngines(String userId, String governanceEngineType, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceEngines";
        String engineTypeParameterName = "governanceEngineType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/{3}?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getAllGovernanceEngines");
        this.invalidParameterHandler.validateName(governanceEngineType, "governanceEngineType", "getAllGovernanceEngines");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllGovernanceEngines");
        GovernanceEngineElementsResponse restResult = this.restClient.callGovernanceEnginesGetRESTCall("getAllGovernanceEngines", urlTemplate, this.serverName, this.serviceURLMarker, userId, governanceEngineType, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getElements();
    }

    public void updateGovernanceEngine(String userId, String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceEngine";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceEngine");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateGovernanceEngine");
        UpdateGovernanceEngineRequestBody requestBody = new UpdateGovernanceEngineRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setTypeDescription(typeDescription);
        requestBody.setVersion(version);
        requestBody.setPatchLevel(patchLevel);
        requestBody.setSource(source);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceEngine", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, guid});
    }

    public void deleteGovernanceEngine(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceEngine";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceEngine");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteGovernanceEngine");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteGovernanceEngine", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, guid});
    }

    public String createGovernanceService(String userId, String governanceServiceType, String qualifiedName, String displayName, String description, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceService";
        String serviceTypeParameterName = "governanceServiceType";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-services/types/{3}";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceService");
        this.invalidParameterHandler.validateName(governanceServiceType, "governanceServiceType", "createGovernanceService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createGovernanceService");
        this.invalidParameterHandler.validateConnection(connection, "connection", "createGovernanceService");
        NewGovernanceServiceRequestBody requestBody = new NewGovernanceServiceRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setConnection(connection);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceService", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, governanceServiceType});
        return restResult.getGUID();
    }

    public GovernanceServiceElement getGovernanceServiceByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-services/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServiceByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getGovernanceServiceByGUID");
        GovernanceServiceElementResponse restResult = this.restClient.callGovernanceServiceGetRESTCall("getGovernanceServiceByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getElement();
    }

    public GovernanceServiceElement getGovernanceServiceByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-services/by-name";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServiceByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceServiceByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        GovernanceServiceElementResponse restResult = this.restClient.callGovernanceServicePostRESTCall("getGovernanceServiceByName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getElement();
    }

    public List<GovernanceServiceElement> getAllGovernanceServices(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceServices";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-services?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getAllGovernanceServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllGovernanceServices");
        GovernanceServiceElementsResponse restResult = this.restClient.callGovernanceServicesGetRESTCall("getAllGovernanceServices", urlTemplate, this.serverName, this.serviceURLMarker, userId, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getElements();
    }

    public List<String> getGovernanceServiceRegistrations(String userId, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceRegistrations";
        String guidParameter = "governanceServiceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-services/{3}/registrations";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServiceRegistrations");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getGovernanceServiceRegistrations");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getGovernanceServiceRegistrations", urlTemplate, new Object[]{this.serverName, this.serviceURLMarker, userId, governanceServiceGUID});
        return restResult.getGUIDs();
    }

    public void updateGovernanceService(String userId, String guid, String qualifiedName, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceService";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-services/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceService");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateGovernanceService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateGovernanceService");
        this.invalidParameterHandler.validateConnection(connection, "connection", "updateGovernanceService");
        UpdateGovernanceServiceRequestBody requestBody = new UpdateGovernanceServiceRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setConnection(connection);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceService", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, guid});
    }

    public void deleteGovernanceService(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceService";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-services/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceService");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteGovernanceService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteGovernanceService");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteGovernanceService", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, guid});
    }

    @Deprecated
    public void registerGovernanceServiceWithEngine(String userId, String governanceEngineGUID, String governanceServiceGUID, String governanceRequestType, Map<String, String> requestParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.registerGovernanceServiceWithEngine(userId, governanceEngineGUID, governanceServiceGUID, governanceRequestType, null, requestParameters);
    }

    public void registerGovernanceServiceWithEngine(String userId, String governanceEngineGUID, String governanceServiceGUID, String governanceRequestType, String serviceRequestType, Map<String, String> requestParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerGovernanceServiceWithEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String governanceRequestTypesParameter = "governanceRequestType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/{3}/governance-services";
        this.invalidParameterHandler.validateUserId(userId, "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateName(governanceRequestType, "governanceRequestType", "registerGovernanceServiceWithEngine");
        GovernanceServiceRegistrationRequestBody requestBody = new GovernanceServiceRegistrationRequestBody();
        requestBody.setGovernanceServiceGUID(governanceServiceGUID);
        requestBody.setRequestType(governanceRequestType);
        requestBody.setServiceRequestType(serviceRequestType);
        requestBody.setRequestParameters(requestParameters);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("registerGovernanceServiceWithEngine", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, governanceEngineGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
    }

    public RegisteredGovernanceServiceElement getRegisteredGovernanceService(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceService";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/{3}/governance-services/{4}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getRegisteredGovernanceService");
        RegisteredGovernanceServiceResponse restResult = this.restClient.callRegisteredGovernanceServiceGetRESTCall("getRegisteredGovernanceService", urlTemplate, this.serverName, this.serviceURLMarker, userId, governanceEngineGUID, governanceServiceGUID);
        return restResult.getRegisteredGovernanceService();
    }

    public List<RegisteredGovernanceServiceElement> getRegisteredGovernanceServices(String userId, String governanceEngineGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceServices";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/{3}/governance-services?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceServices");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getRegisteredGovernanceServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getRegisteredGovernanceServices");
        RegisteredGovernanceServicesResponse restResult = this.restClient.callRegisteredGovernanceServicesGetRESTCall("getRegisteredGovernanceServices", urlTemplate, this.serverName, this.serviceURLMarker, userId, governanceEngineGUID, startingFrom, maximumResults);
        return restResult.getElements();
    }

    public void unregisterGovernanceServiceFromEngine(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterGovernanceServiceFromEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-engine-configuration-service/users/{2}/governance-engines/{3}/governance-services/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "unregisterGovernanceServiceFromEngine");
        this.restClient.callVoidPostRESTCall("unregisterGovernanceServiceFromEngine", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, governanceEngineGUID, governanceServiceGUID});
    }
}

